/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraInvalidMessageException;
import org.eclipse.kura.certificate.CertificatesService;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.CloudConnectionEstablishedEvent;
import org.eclipse.kura.cloud.CloudConnectionLostEvent;
import org.eclipse.kura.cloud.CloudPayloadProtoBufDecoder;
import org.eclipse.kura.cloud.CloudPayloadProtoBufEncoder;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.cloud.CloudClientImpl;
import org.eclipse.kura.core.cloud.CloudPayloadEncoder;
import org.eclipse.kura.core.cloud.CloudPayloadGZipEncoder;
import org.eclipse.kura.core.cloud.CloudPayloadProtoBufDecoderImpl;
import org.eclipse.kura.core.cloud.CloudPayloadProtoBufEncoderImpl;
import org.eclipse.kura.core.cloud.CloudServiceOptions;
import org.eclipse.kura.core.cloud.LifeCyclePayloadBuilder;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.data.DataServiceListener;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraRequestPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.eclipse.kura.message.KuraTopic;
import org.eclipse.kura.net.NetworkService;
import org.eclipse.kura.net.modem.ModemReadyEvent;
import org.eclipse.kura.position.PositionService;
import org.eclipse.kura.system.SystemAdminService;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudServiceImpl
implements CloudService,
DataServiceListener,
ConfigurableComponent,
EventHandler,
CloudPayloadProtoBufEncoder,
CloudPayloadProtoBufDecoder {
    private static final Logger s_logger = LoggerFactory.getLogger(CloudServiceImpl.class);
    private static final String TOPIC_BA_APP = "BA";
    private static final String TOPIC_MQTT_APP = "MQTT";
    private ComponentContext m_ctx;
    private CloudServiceOptions m_options;
    private DataService m_dataService;
    private SystemService m_systemService;
    private SystemAdminService m_systemAdminService;
    private NetworkService m_networkService;
    private PositionService m_positionService;
    private EventAdmin m_eventAdmin;
    private CertificatesService m_certificatesService;
    private List<CloudClientImpl> m_cloudClients = new CopyOnWriteArrayList<CloudClientImpl>();
    String m_imei;
    String m_iccid;
    String m_imsi;
    String m_rssi;
    private boolean m_subscribed;
    private boolean m_birthPublished;
    private AtomicInteger m_messageId = new AtomicInteger();

    public void setDataService(DataService dataService) {
        this.m_dataService = dataService;
    }

    public void unsetDataService(DataService dataService) {
        this.m_dataService = null;
    }

    public DataService getDataService() {
        return this.m_dataService;
    }

    public void setSystemAdminService(SystemAdminService systemAdminService) {
        this.m_systemAdminService = systemAdminService;
    }

    public void unsetSystemAdminService(SystemAdminService systemAdminService) {
        this.m_systemAdminService = null;
    }

    public SystemAdminService getSystemAdminService() {
        return this.m_systemAdminService;
    }

    public void setSystemService(SystemService systemService) {
        this.m_systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.m_systemService = null;
    }

    public SystemService getSystemService() {
        return this.m_systemService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.m_networkService = networkService;
    }

    public void unsetNetworkService(NetworkService networkService) {
        this.m_networkService = null;
    }

    public NetworkService getNetworkService() {
        return this.m_networkService;
    }

    public void setPositionService(PositionService positionService) {
        this.m_positionService = positionService;
    }

    public void unsetPositionService(PositionService positionService) {
        this.m_positionService = null;
    }

    public PositionService getPositionService() {
        return this.m_positionService;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.m_eventAdmin = eventAdmin;
    }

    public void unsetEventAdmin(EventAdmin eventAdmin) {
        this.m_eventAdmin = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        s_logger.info("activate...");
        this.m_ctx = componentContext;
        this.m_options = new CloudServiceOptions(properties, this.m_systemService);
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        String[] eventTopics = new String[]{"org/eclipse/kura/position/locked", "org/eclipse/kura/net/modem/READY"};
        ((Dictionary)props).put("event.topics", eventTopics);
        this.m_ctx.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, props);
        if (this.isConnected()) {
            try {
                this.setupCloudConnection(true);
            }
            catch (KuraException kuraException) {
                s_logger.warn("Cannot setup cloud service connection");
            }
        }
    }

    public void updated(Map<String, Object> properties) {
        s_logger.info("updated...: " + properties);
        this.m_options = new CloudServiceOptions(properties, this.m_systemService);
        if (this.isConnected()) {
            try {
                this.setupCloudConnection(false);
            }
            catch (KuraException kuraException) {
                s_logger.warn("Cannot setup cloud service connection");
            }
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.info("deactivate...");
        if (this.isConnected()) {
            try {
                this.publishDisconnectCertificate();
            }
            catch (KuraException kuraException) {
                s_logger.warn("Cannot publish disconnect certificate");
            }
        }
        this.m_cloudClients.clear();
        this.m_dataService = null;
        this.m_systemService = null;
        this.m_systemAdminService = null;
        this.m_networkService = null;
        this.m_positionService = null;
        this.m_eventAdmin = null;
        this.m_certificatesService = null;
    }

    public void handleEvent(Event event) {
        if ("org/eclipse/kura/position/locked".contains(event.getTopic())) {
            s_logger.info("Handling PositionLockedEvent");
            if (this.m_dataService.isConnected() && this.m_options.getRepubBirthCertOnGpsLock()) {
                try {
                    this.publishBirthCertificate();
                }
                catch (KuraException e) {
                    s_logger.warn("Cannot publish birth certificate", e);
                }
            }
        } else if ("org/eclipse/kura/net/modem/READY".contains(event.getTopic())) {
            s_logger.info("Handling ModemReadyEvent");
            ModemReadyEvent modemReadyEvent = (ModemReadyEvent)event;
            this.m_imei = (String)modemReadyEvent.getProperty("IMEI");
            this.m_imsi = (String)modemReadyEvent.getProperty("IMSI");
            this.m_iccid = (String)modemReadyEvent.getProperty("ICCID");
            this.m_rssi = (String)modemReadyEvent.getProperty("RSSI");
            s_logger.trace("handleEvent() :: IMEI={}", (Object)this.m_imei);
            s_logger.trace("handleEvent() :: IMSI={}", (Object)this.m_imsi);
            s_logger.trace("handleEvent() :: ICCID={}", (Object)this.m_iccid);
            s_logger.trace("handleEvent() :: RSSI={}", (Object)this.m_rssi);
            if (this.m_dataService.isConnected() && this.m_options.getRepubBirthCertOnModemDetection() && (this.m_imei != null && this.m_imei.length() != 0 && !this.m_imei.equals("ERROR") || this.m_imsi != null && this.m_imsi.length() != 0 && !this.m_imsi.equals("ERROR") || this.m_iccid != null && this.m_iccid.length() != 0 && !this.m_iccid.equals("ERROR"))) {
                s_logger.debug("handleEvent() :: publishing BIRTH certificate ...");
                try {
                    this.publishBirthCertificate();
                }
                catch (KuraException e) {
                    s_logger.warn("Cannot publish birth certificate", e);
                }
            }
        }
    }

    @Override
    public CloudClient newCloudClient(String applicationId) throws KuraException {
        CloudClientImpl cloudClient = new CloudClientImpl(applicationId, this.m_dataService, this);
        this.m_cloudClients.add(cloudClient);
        if (this.isConnected()) {
            this.publishAppCertificate();
        }
        return cloudClient;
    }

    @Override
    public String[] getCloudApplicationIdentifiers() {
        ArrayList<String> appIds = new ArrayList<String>();
        for (CloudClientImpl cloudClient : this.m_cloudClients) {
            appIds.add(cloudClient.getApplicationId());
        }
        return appIds.toArray(new String[0]);
    }

    @Override
    public boolean isConnected() {
        return this.m_dataService != null && this.m_dataService.isConnected();
    }

    public CloudServiceOptions getCloudServiceOptions() {
        return this.m_options;
    }

    public void removeCloudClient(CloudClientImpl cloudClient) {
        this.m_cloudClients.remove(cloudClient);
        if (this.isConnected()) {
            try {
                this.publishAppCertificate();
            }
            catch (KuraException kuraException) {
                s_logger.warn("Cannot publish app certificate");
            }
        }
    }

    byte[] encodePayload(KuraPayload payload) throws KuraException {
        byte[] bytes = new byte[]{};
        if (payload == null) {
            return bytes;
        }
        CloudPayloadEncoder encoder = new CloudPayloadProtoBufEncoderImpl(payload);
        if (this.m_options.getEncodeGzip()) {
            encoder = new CloudPayloadGZipEncoder(encoder);
        }
        try {
            bytes = encoder.getBytes();
            return bytes;
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void onConnectionEstablished() {
        try {
            this.setupCloudConnection(true);
        }
        catch (KuraException kuraException) {
            s_logger.warn("Cannot setup cloud service connection");
        }
        this.m_eventAdmin.postEvent((Event)new CloudConnectionEstablishedEvent(new HashMap()));
        for (CloudClientImpl cloudClient : this.m_cloudClients) {
            cloudClient.onConnectionEstablished();
        }
    }

    private void setupDeviceSubscriptions(boolean subscribe) throws KuraException {
        StringBuilder sbDeviceSubscription = new StringBuilder();
        sbDeviceSubscription.append(this.m_options.getTopicControlPrefix()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAccountToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicClientIdToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicWildCard());
        if (subscribe) {
            this.m_dataService.subscribe(sbDeviceSubscription.toString(), 1);
        } else {
            this.m_dataService.unsubscribe(sbDeviceSubscription.toString());
        }
    }

    @Override
    public void onDisconnecting() {
        try {
            this.publishDisconnectCertificate();
        }
        catch (KuraException kuraException) {
            s_logger.warn("Cannot publish disconnect certificate");
        }
    }

    @Override
    public void onDisconnected() {
        this.m_eventAdmin.postEvent((Event)new CloudConnectionLostEvent(new HashMap()));
    }

    @Override
    public void onConnectionLost(Throwable cause) {
        this.m_eventAdmin.postEvent((Event)new CloudConnectionLostEvent(new HashMap()));
        for (CloudClientImpl cloudClient : this.m_cloudClients) {
            cloudClient.onConnectionLost();
        }
    }

    @Override
    public void onMessageArrived(String topic, byte[] payload, int qos, boolean retained) {
        s_logger.info("Message arrived on topic: {}", (Object)topic);
        KuraTopic kuraTopic = new KuraTopic(topic);
        if (TOPIC_MQTT_APP.equals(kuraTopic.getApplicationId()) || TOPIC_BA_APP.equals(kuraTopic.getApplicationId())) {
            s_logger.info("Ignoring feedback message from " + topic);
        } else {
            KuraPayload kuraPayload = null;
            try {
                kuraPayload = new CloudPayloadProtoBufDecoderImpl(payload).buildFromByteArray();
            }
            catch (Exception exception) {
                s_logger.debug("Received message on topic " + topic + " that could not be decoded. Wrapping it into an KuraPayload.");
                kuraPayload = new KuraPayload();
                kuraPayload.setBody(payload);
            }
            for (CloudClientImpl cloudClient : this.m_cloudClients) {
                if (!cloudClient.getApplicationId().equals(kuraTopic.getApplicationId())) continue;
                try {
                    if (this.m_options.getTopicControlPrefix().equals(kuraTopic.getPrefix())) {
                        ServiceReference sr;
                        if (this.m_certificatesService == null && (sr = this.m_ctx.getBundleContext().getServiceReference(CertificatesService.class)) != null) {
                            this.m_certificatesService = (CertificatesService)this.m_ctx.getBundleContext().getService(sr);
                        }
                        boolean validMessage = false;
                        if (this.m_certificatesService == null) {
                            validMessage = true;
                        } else if (this.m_certificatesService.verifySignature(kuraTopic, kuraPayload)) {
                            validMessage = true;
                        }
                        if (validMessage) {
                            cloudClient.onControlMessageArrived(kuraTopic.getDeviceId(), kuraTopic.getApplicationTopic(), kuraPayload, qos, retained);
                            continue;
                        }
                        s_logger.debug("Message verification failed! Not valid signature or message not signed.");
                        KuraRequestPayload reqPayload = KuraRequestPayload.buildFromKuraPayload(kuraPayload);
                        KuraResponsePayload respPayload = new KuraResponsePayload(500);
                        respPayload.setTimestamp(new Date());
                        StringBuilder sb = new StringBuilder("REPLY").append("/").append(reqPayload.getRequestId());
                        String requesterClientId = reqPayload.getRequesterClientId();
                        cloudClient.controlPublish(requesterClientId, sb.toString(), respPayload, 0, false, 1);
                        continue;
                    }
                    cloudClient.onMessageArrived(kuraTopic.getDeviceId(), kuraTopic.getApplicationTopic(), kuraPayload, qos, retained);
                }
                catch (Exception e) {
                    s_logger.error("Error during CloudClientListener notification.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessagePublished(int messageId, String topic) {
        AtomicInteger atomicInteger = this.m_messageId;
        synchronized (atomicInteger) {
            if (this.m_messageId.get() != -1 && this.m_messageId.get() == messageId) {
                if (this.m_options.getLifeCycleMessageQos() == 0) {
                    this.m_messageId.set(-1);
                }
                this.m_messageId.notifyAll();
                return;
            }
        }
        KuraTopic kuraTopic = new KuraTopic(topic);
        for (CloudClientImpl cloudClient : this.m_cloudClients) {
            if (!cloudClient.getApplicationId().equals(kuraTopic.getApplicationId())) continue;
            cloudClient.onMessagePublished(messageId, kuraTopic.getApplicationTopic());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessageConfirmed(int messageId, String topic) {
        AtomicInteger atomicInteger = this.m_messageId;
        synchronized (atomicInteger) {
            if (this.m_messageId.get() != -1 && this.m_messageId.get() == messageId) {
                this.m_messageId.set(-1);
                this.m_messageId.notifyAll();
                return;
            }
        }
        KuraTopic kuraTopic = new KuraTopic(topic);
        for (CloudClientImpl cloudClient : this.m_cloudClients) {
            if (!cloudClient.getApplicationId().equals(kuraTopic.getApplicationId())) continue;
            cloudClient.onMessageConfirmed(messageId, kuraTopic.getApplicationTopic());
        }
    }

    @Override
    public byte[] getBytes(KuraPayload kuraPayload, boolean gzipped) throws KuraException {
        CloudPayloadEncoder encoder = new CloudPayloadProtoBufEncoderImpl(kuraPayload);
        if (gzipped) {
            encoder = new CloudPayloadGZipEncoder(encoder);
        }
        try {
            byte[] bytes = encoder.getBytes();
            return bytes;
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public KuraPayload buildFromByteArray(byte[] payload) throws KuraException {
        CloudPayloadProtoBufDecoderImpl encoder = new CloudPayloadProtoBufDecoderImpl(payload);
        try {
            KuraPayload kuraPayload = encoder.buildFromByteArray();
            return kuraPayload;
        }
        catch (KuraInvalidMessageException e) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    private void setupCloudConnection(boolean onConnect) throws KuraException {
        if (onConnect) {
            this.m_subscribed = false;
        }
        boolean publishBirth = true;
        if (this.m_birthPublished && this.m_options.getDisableRepubBirthCertOnReconnect()) {
            publishBirth = false;
            s_logger.info("Birth certificate republish is disabled in configuration");
        }
        if (publishBirth) {
            this.publishBirthCertificate();
            this.m_birthPublished = true;
        }
        if (this.m_options.getDisableDefaultSubscriptions()) {
            s_logger.info("Default subscriptions are disabled in configuration");
            if (this.m_subscribed) {
                this.setupDeviceSubscriptions(false);
                this.m_subscribed = false;
            }
        } else if (!this.m_subscribed) {
            this.setupDeviceSubscriptions(true);
            this.m_subscribed = true;
        }
    }

    private void publishBirthCertificate() throws KuraException {
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(this.m_options.getTopicControlPrefix()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAccountToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicClientIdToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicBirthSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createBirthPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private void publishDisconnectCertificate() throws KuraException {
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(this.m_options.getTopicControlPrefix()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAccountToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicClientIdToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicDisconnectSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createDisconnectPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private void publishAppCertificate() throws KuraException {
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(this.m_options.getTopicControlPrefix()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAccountToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicClientIdToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAppsSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createBirthPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private KuraPayload createBirthPayload() {
        LifeCyclePayloadBuilder payloadBuilder = new LifeCyclePayloadBuilder(this);
        return payloadBuilder.buildBirthPayload();
    }

    private KuraPayload createDisconnectPayload() {
        LifeCyclePayloadBuilder payloadBuilder = new LifeCyclePayloadBuilder(this);
        return payloadBuilder.buildDisconnectPayload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishLifeCycleMessage(String topic, KuraPayload payload) throws KuraException {
        AtomicInteger atomicInteger = this.m_messageId;
        synchronized (atomicInteger) {
            this.m_messageId.set(-1);
            byte[] encodedPayload = this.encodePayload(payload);
            int messageId = this.m_dataService.publish(topic, encodedPayload, this.m_options.getLifeCycleMessageQos(), this.m_options.getLifeCycleMessageRetain(), this.m_options.getLifeCycleMessagePriority());
            this.m_messageId.set(messageId);
            try {
                this.m_messageId.wait(1000L);
            }
            catch (InterruptedException e) {
                s_logger.info("Interrupted while waiting for the message to be published", e);
            }
        }
    }
}

