/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.comm;

import java.net.URISyntaxException;

public class CommURI {
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_SPACE = 4;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_1_5 = 3;
    public static final int STOPBITS_2 = 2;
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_RTSCTS_IN = 1;
    public static final int FLOWCONTROL_RTSCTS_OUT = 2;
    public static final int FLOWCONTROL_XONXOFF_IN = 4;
    public static final int FLOWCONTROL_XONXOFF_OUT = 8;
    private String m_port;
    private int m_baudRate;
    private int m_dataBits;
    private int m_stopBits;
    private int m_parity;
    private int m_flowControl;
    private int m_timeout;

    private CommURI(Builder builder) {
        this.m_port = builder.m_port;
        this.m_baudRate = builder.m_baudRate;
        this.m_dataBits = builder.m_dataBits;
        this.m_stopBits = builder.m_stopBits;
        this.m_parity = builder.m_parity;
        this.m_flowControl = builder.m_flowControl;
        this.m_timeout = builder.m_timeout;
    }

    public String getPort() {
        return this.m_port;
    }

    public int getBaudRate() {
        return this.m_baudRate;
    }

    public int getDataBits() {
        return this.m_dataBits;
    }

    public int getStopBits() {
        return this.m_stopBits;
    }

    public int getParity() {
        return this.m_parity;
    }

    public int getFlowControl() {
        return this.m_flowControl;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("comm:").append(this.m_port).append(";baudrate=").append(this.m_baudRate).append(";databits=").append(this.m_dataBits).append(";stopbits=").append(this.m_stopBits).append(";parity=").append(this.m_parity).append(";flowcontrol=").append(this.m_flowControl).append(";timeout=").append(this.m_timeout);
        return sb.toString();
    }

    public static CommURI parseString(String uri) throws URISyntaxException {
        if (!uri.startsWith("comm:")) {
            throw new URISyntaxException(uri, "Does not start with comm:");
        }
        int idx = uri.indexOf(";") == -1 ? uri.length() : uri.indexOf(";");
        String port = uri.substring(5, idx);
        Builder builder = new Builder(port);
        if (idx != uri.length()) {
            String[] params;
            String[] stringArray = params = uri.substring(idx).split(";");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                int i = param.indexOf("=");
                if (i != -1) {
                    String name = param.substring(0, i);
                    String value = param.substring(i + 1);
                    if ("baudrate".equals(name)) {
                        builder = builder.withBaudRate(Integer.parseInt(value));
                    } else if ("databits".equals(name)) {
                        builder = builder.withDataBits(Integer.parseInt(value));
                    } else if ("stopbits".equals(name)) {
                        builder = builder.withStopBits(Integer.parseInt(value));
                    } else if ("parity".equals(name)) {
                        builder = builder.withParity(Integer.parseInt(value));
                    } else if ("flowcontrol".equals(name)) {
                        builder = builder.withFlowControl(Integer.parseInt(value));
                    } else if ("timeout".equals(name)) {
                        builder = builder.withTimeout(Integer.parseInt(value));
                    }
                }
                ++n2;
            }
        }
        return builder.build();
    }

    /* synthetic */ CommURI(Builder builder, CommURI commURI) {
        this(builder);
    }

    public static class Builder {
        private String m_port;
        private int m_baudRate = 19200;
        private int m_dataBits = 8;
        private int m_stopBits = 1;
        private int m_parity = 0;
        private int m_flowControl = 0;
        private int m_timeout = 2000;

        public Builder(String port) {
            this.m_port = port;
        }

        public Builder withBaudRate(int baudRate) {
            this.m_baudRate = baudRate;
            return this;
        }

        public Builder withDataBits(int dataBits) {
            this.m_dataBits = dataBits;
            return this;
        }

        public Builder withStopBits(int stopBits) {
            this.m_stopBits = stopBits;
            return this;
        }

        public Builder withParity(int parity) {
            this.m_parity = parity;
            return this;
        }

        public Builder withFlowControl(int flowControl) {
            this.m_flowControl = flowControl;
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.m_timeout = timeout;
            return this;
        }

        public CommURI build() {
            return new CommURI(this, null);
        }
    }
}

