/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud;

import java.util.Date;
import java.util.concurrent.Callable;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.Cloudlet;
import org.eclipse.kura.cloud.CloudletTopic;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraRequestPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageHandlerCallable
implements Callable<Void> {
    private static final Logger s_logger = LoggerFactory.getLogger(MessageHandlerCallable.class);
    private Cloudlet m_cloudApp;
    private String m_deviceId;
    private String m_appTopic;
    private KuraPayload m_msg;
    private int m_qos;
    private boolean m_retain;

    public MessageHandlerCallable(Cloudlet cloudApp, String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {
        this.m_cloudApp = cloudApp;
        this.m_deviceId = deviceId;
        this.m_appTopic = appTopic;
        this.m_msg = msg;
        this.m_qos = qos;
        this.m_retain = retain;
    }

    @Override
    public Void call() throws Exception {
        s_logger.debug("Control Arrived on topic: {}", (Object)this.m_appTopic);
        KuraRequestPayload reqPayload = KuraRequestPayload.buildFromKuraPayload(this.m_msg);
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        try {
            CloudletTopic reqTopic = CloudletTopic.parseAppTopic(this.m_appTopic);
            CloudletTopic.Method method = reqTopic.getMethod();
            switch (method) {
                case GET: {
                    s_logger.debug("Handling GET request topic: {}", (Object)this.m_appTopic);
                    this.m_cloudApp.doGet(reqTopic, reqPayload, respPayload);
                    break;
                }
                case PUT: {
                    s_logger.debug("Handling PUT request topic: {}", (Object)this.m_appTopic);
                    this.m_cloudApp.doPut(reqTopic, reqPayload, respPayload);
                    break;
                }
                case POST: {
                    s_logger.debug("Handling POST request topic: {}", (Object)this.m_appTopic);
                    this.m_cloudApp.doPost(reqTopic, reqPayload, respPayload);
                    break;
                }
                case DEL: {
                    s_logger.debug("Handling DEL request topic: {}", (Object)this.m_appTopic);
                    this.m_cloudApp.doDel(reqTopic, reqPayload, respPayload);
                    break;
                }
                case EXEC: {
                    s_logger.debug("Handling EXEC request topic: {}", (Object)this.m_appTopic);
                    this.m_cloudApp.doExec(reqTopic, reqPayload, respPayload);
                    break;
                }
                default: {
                    s_logger.error("Bad request topic: {}", (Object)this.m_appTopic);
                    respPayload.setResponseCode(400);
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            s_logger.error("Bad request topic: {}", (Object)this.m_appTopic);
            respPayload.setResponseCode(400);
        }
        catch (KuraException e) {
            s_logger.error("Error handling request topic: {}\n{}", (Object)this.m_appTopic, (Object)e);
            respPayload.setResponseCode(500);
            respPayload.setException(e);
        }
        try {
            CloudClient cloudClient = this.m_cloudApp.getCloudApplicationClient();
            respPayload.setTimestamp(new Date());
            StringBuilder sb = new StringBuilder("REPLY").append("/").append(reqPayload.getRequestId());
            String requesterClientId = reqPayload.getRequesterClientId();
            s_logger.debug("Publishing response topic: {}", (Object)sb.toString());
            cloudClient.controlPublish(requesterClientId, sb.toString(), respPayload, 0, false, 1);
        }
        catch (KuraException e) {
            s_logger.error("Error publishing response for topic: {}\n{}", (Object)this.m_appTopic, (Object)e);
        }
        return null;
    }
}

