/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud;

public class CloudletTopic {
    private Method m_method;
    private String[] m_resources;

    public static CloudletTopic parseAppTopic(String appTopic) {
        CloudletTopic edcApplicationTopic = new CloudletTopic();
        String[] parts = appTopic.split("/");
        edcApplicationTopic.m_method = Method.valueOf(parts[0]);
        if (parts.length > 1) {
            edcApplicationTopic.m_resources = new String[parts.length - 1];
            int i = 0;
            while (i < edcApplicationTopic.m_resources.length) {
                edcApplicationTopic.m_resources[i] = parts[i + 1];
                ++i;
            }
        }
        return edcApplicationTopic;
    }

    private CloudletTopic() {
    }

    public Method getMethod() {
        return this.m_method;
    }

    public String[] getResources() {
        return this.m_resources;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.m_method.name());
        if (this.m_resources != null) {
            int i = 0;
            while (i < this.m_resources.length) {
                sb.append("/");
                sb.append(this.m_resources[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DEL,
        EXEC;

    }
}

