/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.CloudClientListener;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.cloud.CloudletTopic;
import org.eclipse.kura.cloud.MessageHandlerCallable;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraRequestPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Cloudlet
implements CloudClientListener {
    private static final Logger s_logger = LoggerFactory.getLogger(Cloudlet.class);
    protected static final int DFLT_PUB_QOS = 0;
    protected static final boolean DFLT_RETAIN = false;
    protected static final int DFLT_PRIORITY = 1;
    private static int NUM_CONCURRENT_CALLBACKS = 2;
    private static ExecutorService m_callbackExecutor = Executors.newFixedThreadPool(NUM_CONCURRENT_CALLBACKS);
    private CloudService m_cloudService;
    private CloudClient m_cloudClient;
    private ComponentContext m_ctx;
    private String m_applicationId;

    public void setCloudService(CloudService cloudService) {
        this.m_cloudService = cloudService;
    }

    public void unsetCloudService(CloudService cloudService) {
        this.m_cloudService = null;
    }

    protected void activate(ComponentContext componentContext) {
        try {
            s_logger.info("Getting CloudApplicationClient for {}...", (Object)this.m_applicationId);
            this.m_cloudClient = this.m_cloudService.newCloudClient(this.m_applicationId);
            this.m_cloudClient.addCloudClientListener(this);
            this.m_ctx = componentContext;
        }
        catch (KuraException e) {
            s_logger.error("Cannot activate", e);
            throw new ComponentException((Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.info("Releasing CloudApplicationClient for {}...", (Object)this.m_applicationId);
        if (this.m_cloudClient != null) {
            this.m_cloudClient.release();
        }
        this.m_cloudService = null;
    }

    protected Cloudlet(String appId) {
        this.m_applicationId = appId;
    }

    public String getAppId() {
        return this.m_applicationId;
    }

    protected CloudService getCloudService() {
        return this.m_cloudService;
    }

    protected CloudClient getCloudApplicationClient() {
        return this.m_cloudClient;
    }

    protected ComponentContext getComponentContext() {
        return this.m_ctx;
    }

    protected void doGet(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        s_logger.info("Default GET handler");
        respPayload.setResponseCode(404);
    }

    protected void doPut(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        s_logger.info("Default PUT handler");
        respPayload.setResponseCode(404);
    }

    protected void doPost(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        s_logger.info("Default POST handler");
        respPayload.setResponseCode(404);
    }

    protected void doDel(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        s_logger.info("Default DEL handler");
        respPayload.setResponseCode(404);
    }

    protected void doExec(CloudletTopic reqTopic, KuraRequestPayload reqPayload, KuraResponsePayload respPayload) throws KuraException {
        s_logger.info("Default EXEC handler");
        respPayload.setResponseCode(404);
    }

    @Override
    public void onControlMessageArrived(String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {
        try {
            s_logger.debug("Control Arrived on topic: {}", (Object)appTopic);
            StringBuilder sb = new StringBuilder(this.m_applicationId).append("/").append("REPLY");
            if (appTopic.startsWith(sb.toString())) {
                return;
            }
            m_callbackExecutor.submit(new MessageHandlerCallable(this, deviceId, appTopic, msg, qos, retain));
        }
        catch (Throwable t) {
            s_logger.error("Unexpected throwable: {}", t);
        }
    }

    @Override
    public void onMessageArrived(String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {
        s_logger.error("Unexpected message arrived on topic: " + appTopic);
    }

    @Override
    public void onConnectionLost() {
        s_logger.warn("Cloud Client Connection Lost!");
    }

    @Override
    public void onConnectionEstablished() {
        s_logger.info("Cloud Client Connection Restored");
    }

    @Override
    public void onMessageConfirmed(int messageId, String topic) {
        s_logger.debug("Message Confirmed (" + messageId + ")");
    }

    @Override
    public void onMessagePublished(int messageId, String topic) {
        s_logger.debug("Message Published (" + messageId + ")");
    }
}

