/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.kura.KuraErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuraException
extends Exception {
    private static final long serialVersionUID = 7468633737373095296L;
    private static final Logger s_logger = LoggerFactory.getLogger(KuraException.class);
    private static final String KURA_GENERIC_MESSAGES_PATTERN = "Generic Error - {0}: {1}";
    private static final String KURA_EXCEPTION_MESSAGES_BUNDLE = "org.eclipse.kura.core.messages.KuraExceptionMessagesBundle";
    protected KuraErrorCode m_code;
    private Object[] m_arguments;

    private KuraException() {
    }

    public KuraException(KuraErrorCode code) {
        this.m_code = code;
    }

    public KuraException(KuraErrorCode code, Object ... arguments) {
        this.m_code = code;
        this.m_arguments = arguments;
    }

    public KuraException(KuraErrorCode code, Throwable cause, Object ... arguments) {
        super(cause);
        this.m_code = code;
        this.m_arguments = arguments;
    }

    public static KuraException internalError(Throwable cause, String message) {
        return new KuraException(KuraErrorCode.INTERNAL_ERROR, cause, message);
    }

    public static KuraException internalError(Throwable cause) {
        return new KuraException(KuraErrorCode.INTERNAL_ERROR, cause, "");
    }

    public static KuraException internalError(String message) {
        return new KuraException(KuraErrorCode.INTERNAL_ERROR, null, message);
    }

    public KuraErrorCode getCode() {
        return this.m_code;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.US);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    private String getLocalizedMessage(Locale locale) {
        String pattern = this.getMessagePattern(locale, this.m_code);
        if ((this.m_code == null || KuraErrorCode.INTERNAL_ERROR.equals((Object)this.m_code)) && this.m_arguments != null && this.m_arguments.length > 1) {
            StringBuilder sbAllArgs = new StringBuilder();
            Object[] objectArray = this.m_arguments;
            int n = this.m_arguments.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                sbAllArgs.append(" - ");
                sbAllArgs.append(arg);
                ++n2;
            }
            this.m_arguments = new Object[]{sbAllArgs.toString()};
        }
        String message = MessageFormat.format(pattern, this.m_arguments);
        return message;
    }

    private String getMessagePattern(Locale locale, KuraErrorCode code) {
        String messagePattern = null;
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(KURA_EXCEPTION_MESSAGES_BUNDLE, locale);
            if (resourceBundle != null && code != null && (messagePattern = resourceBundle.getString(code.name())) == null) {
                s_logger.warn("Could not find Exception Messages for Locale {} and code {}", (Object)locale, (Object)code);
            }
        }
        catch (MissingResourceException missingResourceException) {
            s_logger.warn("Could not load Exception Messages Bundle for Locale {}", (Object)locale);
        }
        if (messagePattern == null) {
            messagePattern = code != null ? MessageFormat.format(KURA_GENERIC_MESSAGES_PATTERN, code.name()) : MessageFormat.format(KURA_GENERIC_MESSAGES_PATTERN, "Unknown");
        }
        return messagePattern;
    }
}

