/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.subscriptions;

import io.moquette.spi.ISessionsStore;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.Token;
import io.moquette.spi.impl.subscriptions.TreeNode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionsStore {
    private AtomicReference<TreeNode> subscriptions = new AtomicReference<TreeNode>(new TreeNode());
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionsStore.class);
    private volatile ISessionsStore m_sessionsStore;

    public static boolean validate(String topicFilter) {
        try {
            SubscriptionsStore.parseTopic(topicFilter);
            return true;
        }
        catch (ParseException pex) {
            LOG.info("Bad matching topic filter <{}>", (Object)topicFilter);
            return false;
        }
    }

    public void init(ISessionsStore sessionsStore) {
        LOG.debug("init invoked");
        this.m_sessionsStore = sessionsStore;
        List<ISessionsStore.ClientTopicCouple> subscriptions = sessionsStore.listAllSubscriptions();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reloading all stored subscriptions...subscription tree before {}", (Object)this.dumpTree());
        }
        for (ISessionsStore.ClientTopicCouple clientTopic : subscriptions) {
            LOG.debug("Re-subscribing {} to topic {}", (Object)clientTopic.clientID, (Object)clientTopic.topicFilter);
            this.add(clientTopic);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Finished loading. Subscription tree after {}", (Object)this.dumpTree());
        }
    }

    public void add(ISessionsStore.ClientTopicCouple newSubscription) {
        NodeCouple couple;
        TreeNode oldRoot;
        do {
            oldRoot = this.subscriptions.get();
            couple = this.recreatePath(newSubscription.topicFilter, oldRoot);
            couple.createdNode.addSubscription(newSubscription);
        } while (!this.subscriptions.compareAndSet(oldRoot, couple.root));
        LOG.debug("root ref {}, original root was {}", (Object)couple.root, (Object)oldRoot);
    }

    protected NodeCouple recreatePath(String topic, TreeNode oldRoot) {
        TreeNode newRoot;
        List<Object> tokens = new ArrayList();
        try {
            tokens = SubscriptionsStore.parseTopic(topic);
        }
        catch (ParseException ex) {
            LOG.error(null, ex);
        }
        TreeNode parent = newRoot = oldRoot.copy();
        TreeNode current = newRoot;
        for (Token token : tokens) {
            TreeNode matchingChildren = current.childWithToken(token);
            if (matchingChildren != null) {
                current = matchingChildren.copy();
                parent.updateChild(matchingChildren, current);
                parent = current;
                continue;
            }
            matchingChildren = new TreeNode();
            matchingChildren.setToken(token);
            current.addChild(matchingChildren);
            current = matchingChildren;
        }
        return new NodeCouple(newRoot, current);
    }

    public void removeSubscription(String topic, String clientID) {
        NodeCouple couple;
        TreeNode oldRoot;
        do {
            oldRoot = this.subscriptions.get();
            couple = this.recreatePath(topic, oldRoot);
            couple.createdNode.remove(new ISessionsStore.ClientTopicCouple(clientID, topic));
        } while (!this.subscriptions.compareAndSet(oldRoot, couple.root));
    }

    public void removeForClient(String clientID) {
        TreeNode newRoot;
        TreeNode oldRoot;
        while (!this.subscriptions.compareAndSet(oldRoot = this.subscriptions.get(), newRoot = oldRoot.removeClientSubscriptions(clientID))) {
        }
    }

    public List<Subscription> matches(String topic) {
        List<Token> tokens;
        try {
            tokens = SubscriptionsStore.parseTopic(topic);
        }
        catch (ParseException ex) {
            LOG.error(null, ex);
            return Collections.emptyList();
        }
        LinkedBlockingDeque<Token> tokenQueue = new LinkedBlockingDeque<Token>(tokens);
        ArrayList<ISessionsStore.ClientTopicCouple> matchingSubs = new ArrayList<ISessionsStore.ClientTopicCouple>();
        this.subscriptions.get().matches(tokenQueue, matchingSubs);
        HashMap<String, Subscription> subsForClient = new HashMap<String, Subscription>();
        for (ISessionsStore.ClientTopicCouple matchingCouple : matchingSubs) {
            Subscription existingSub = (Subscription)subsForClient.get(matchingCouple.clientID);
            Subscription sub = this.m_sessionsStore.getSubscription(matchingCouple);
            if (existingSub != null && existingSub.getRequestedQos().byteValue() >= sub.getRequestedQos().byteValue()) continue;
            subsForClient.put(matchingCouple.clientID, sub);
        }
        return new ArrayList<Subscription>(subsForClient.values());
    }

    public boolean contains(Subscription sub) {
        return !this.matches(sub.topicFilter).isEmpty();
    }

    public int size() {
        return this.subscriptions.get().size();
    }

    public String dumpTree() {
        DumpTreeVisitor visitor = new DumpTreeVisitor();
        this.bfsVisit(this.subscriptions.get(), visitor, 0);
        return visitor.getResult();
    }

    private void bfsVisit(TreeNode node, IVisitor visitor, int deep) {
        if (node == null) {
            return;
        }
        visitor.visit(node, deep);
        for (TreeNode child : node.m_children) {
            this.bfsVisit(child, visitor, ++deep);
        }
    }

    public static boolean matchTopics(String msgTopic, String subscriptionTopic) {
        try {
            int i;
            List<Token> msgTokens = SubscriptionsStore.parseTopic(msgTopic);
            List<Token> subscriptionTokens = SubscriptionsStore.parseTopic(subscriptionTopic);
            for (i = 0; i < subscriptionTokens.size(); ++i) {
                Token subToken = subscriptionTokens.get(i);
                if (subToken != Token.MULTI && subToken != Token.SINGLE) {
                    if (i >= msgTokens.size()) {
                        return false;
                    }
                    Token msgToken = msgTokens.get(i);
                    if (msgToken.equals(subToken)) continue;
                    return false;
                }
                if (subToken == Token.MULTI) {
                    return true;
                }
                if (subToken != Token.SINGLE) continue;
            }
            return i == msgTokens.size();
        }
        catch (ParseException ex) {
            LOG.error(null, ex);
            throw new RuntimeException(ex);
        }
    }

    protected static List<Token> parseTopic(String topic) throws ParseException {
        ArrayList<Token> res = new ArrayList<Token>();
        String[] splitted = topic.split("/");
        if (splitted.length == 0) {
            res.add(Token.EMPTY);
        }
        if (topic.endsWith("/")) {
            String[] newSplitted = new String[splitted.length + 1];
            System.arraycopy(splitted, 0, newSplitted, 0, splitted.length);
            newSplitted[splitted.length] = "";
            splitted = newSplitted;
        }
        for (int i = 0; i < splitted.length; ++i) {
            String s = splitted[i];
            if (s.isEmpty()) {
                res.add(Token.EMPTY);
                continue;
            }
            if (s.equals("#")) {
                if (i != splitted.length - 1) {
                    throw new ParseException("Bad format of topic, the multi symbol (#) has to be the last one after a separator", i);
                }
                res.add(Token.MULTI);
                continue;
            }
            if (s.contains("#")) {
                throw new ParseException("Bad format of topic, invalid subtopic name: " + s, i);
            }
            if (s.equals("+")) {
                res.add(Token.SINGLE);
                continue;
            }
            if (s.contains("+")) {
                throw new ParseException("Bad format of topic, invalid subtopic name: " + s, i);
            }
            res.add(new Token(s));
        }
        return res;
    }

    private class DumpTreeVisitor
    implements IVisitor<String> {
        String s = "";

        private DumpTreeVisitor() {
        }

        @Override
        public void visit(TreeNode node, int deep) {
            String subScriptionsStr = "";
            String indentTabs = this.indentTabs(deep);
            for (ISessionsStore.ClientTopicCouple couple : node.m_subscriptions) {
                subScriptionsStr = subScriptionsStr + indentTabs + couple.toString() + "\n";
            }
            this.s = this.s + (node.getToken() == null ? "" : node.getToken().toString());
            this.s = this.s + "\n" + (node.m_subscriptions.isEmpty() ? indentTabs : "") + subScriptionsStr;
        }

        private String indentTabs(int deep) {
            String s = "";
            for (int i = 0; i < deep; ++i) {
                s = s + "\t";
            }
            return s;
        }

        @Override
        public String getResult() {
            return this.s;
        }
    }

    public static interface IVisitor<T> {
        public void visit(TreeNode var1, int var2);

        public T getResult();
    }

    public static class NodeCouple {
        final TreeNode root;
        final TreeNode createdNode;

        public NodeCouple(TreeNode root, TreeNode createdNode) {
            this.root = root;
            this.createdNode = createdNode;
        }
    }
}

