/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.xml.XMLSchemaUtils;

public class XMLParser {
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;

    public XMLParser(String namespace, String schema) throws XMLException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)namespace);
            this.marshaller = jc.createMarshaller();
            this.marshaller.setSchema(XMLSchemaUtils.createSchema(schema));
            this.unmarshaller = jc.createUnmarshaller();
            this.unmarshaller.setSchema(XMLSchemaUtils.createSchema(schema));
        }
        catch (JAXBException e) {
            throw new XMLException("Cannot instantiate marshaller/unmarshaller for " + namespace, e);
        }
    }

    public XMLParser(Class classToBeBound, String schema) throws XMLException {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{classToBeBound});
            this.marshaller = jc.createMarshaller();
            this.marshaller.setSchema(XMLSchemaUtils.createSchema(schema));
            this.unmarshaller = jc.createUnmarshaller();
            this.unmarshaller.setSchema(XMLSchemaUtils.createSchema(schema));
        }
        catch (JAXBException e) {
            throw new XMLException("Cannot instantiate marshaller/unmarshaller for " + classToBeBound, e);
        }
    }

    public XMLParser(String namespace, String[] schemas) throws XMLException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)namespace);
            this.marshaller = jc.createMarshaller();
            this.marshaller.setSchema(XMLSchemaUtils.createSchema(schemas));
            this.unmarshaller = jc.createUnmarshaller();
            this.unmarshaller.setSchema(XMLSchemaUtils.createSchema(schemas));
        }
        catch (JAXBException e) {
            throw new XMLException("Cannot instantiate marshaller/unmarshaller for " + namespace, e);
        }
    }

    public XMLParser(Class classToBeBound, String[] schemas) throws XMLException {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{classToBeBound});
            this.marshaller = jc.createMarshaller();
            this.marshaller.setSchema(XMLSchemaUtils.createSchema(schemas));
            this.unmarshaller = jc.createUnmarshaller();
            this.unmarshaller.setSchema(XMLSchemaUtils.createSchema(schemas));
        }
        catch (JAXBException e) {
            throw new XMLException("Cannot instantiate marshaller/unmarshaller for " + classToBeBound, e);
        }
    }

    public XMLParser(Class classToBeBound) throws XMLException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)classToBeBound.getPackage().getName());
            this.marshaller = jc.createMarshaller();
            this.unmarshaller = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new XMLException("Cannot instantiate marshaller/unmarshaller for " + classToBeBound, e);
        }
    }

    public Object unmarshal(String xml) throws XMLException {
        Object readObject = null;
        try {
            readObject = this.unmarshaller.unmarshal((Source)new StreamSource(xml));
            if (readObject instanceof JAXBElement) {
                readObject = ((JAXBElement)readObject).getValue();
            }
        }
        catch (JAXBException e) {
            throw new XMLException("Cannot read the XML ", e);
        }
        catch (IllegalArgumentException e) {
            throw new XMLException("Cannot read the XML ", e);
        }
        return readObject;
    }

    public Object unmarshal(String xml, Class rootClass) throws XMLException {
        Object readObject = null;
        try {
            if (xml == null || xml.isEmpty()) {
                throw new XMLException("Cannot parse empty XML");
            }
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            readObject = this.unmarshaller.unmarshal(db.parse(is).getFirstChild(), rootClass);
            if (readObject instanceof JAXBElement) {
                readObject = readObject.getValue();
            }
        }
        catch (JAXBException e) {
            throw new XMLException("Cannot read the XML ", e);
        }
        catch (IllegalArgumentException e) {
            throw new XMLException("Cannot read the XML ", e);
        }
        catch (SAXException e) {
            throw new XMLException("Cannot read the XML ", e);
        }
        catch (IOException e) {
            throw new XMLException("Cannot read the XML ", e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException("Cannot read the XML ", e);
        }
        return readObject;
    }

    public Object loadFromString(String xml) throws XMLException {
        Object readObject = null;
        try {
            readObject = this.unmarshaller.unmarshal((Reader)new StringReader(xml));
            if (readObject instanceof JAXBElement) {
                readObject = ((JAXBElement)readObject).getValue();
            }
        }
        catch (JAXBException e) {
            throw new XMLException("Cannot unmarshal the XML", e);
        }
        catch (IllegalArgumentException e) {
            throw new XMLException("Cannot unmarshal the XML", e);
        }
        return readObject;
    }

    public Object loadFromInputStream(InputStream inputStream) throws XMLException {
        Object readObject = null;
        try {
            readObject = this.unmarshaller.unmarshal(inputStream);
            if (readObject instanceof JAXBElement) {
                readObject = ((JAXBElement)readObject).getValue();
            }
        }
        catch (JAXBException e) {
            try {
                throw new XMLException("Cannot unmarshal the XML: " + IOUtils.toString(inputStream), e);
            }
            catch (IOException e1) {
                throw new XMLException("Cannot unmarshal the XML", e1);
            }
        }
        catch (IllegalArgumentException e) {
            try {
                throw new XMLException("Cannot unmarshal the XML: " + IOUtils.toString(inputStream), e);
            }
            catch (IOException e1) {
                throw new XMLException("Cannot unmarshal the XML", e1);
            }
        }
        return readObject;
    }

    public Object loadFromFile(File file) throws XMLException, FileNotFoundException {
        if (file == null) {
            throw new FileNotFoundException("Cannot load a null file");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Cannot load the file from " + file.getAbsolutePath());
        }
        Object readObject = null;
        try {
            readObject = this.unmarshaller.unmarshal(file);
            if (readObject instanceof JAXBElement) {
                readObject = ((JAXBElement)readObject).getValue();
            }
        }
        catch (JAXBException e) {
            throw new XMLException("Cannot unmarshal the XML from " + file.getAbsolutePath(), e);
        }
        catch (IllegalArgumentException e) {
            throw new XMLException("Cannot unmarshal the XML from " + file.getAbsolutePath(), e);
        }
        return readObject;
    }

    public void saveToFile(File file, Object objectToSave) throws XMLException {
        try {
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            this.marshaller.marshal(objectToSave, (Writer)writer);
            this.marshaller.marshal(objectToSave, file);
        }
        catch (Exception e) {
            throw new XMLException("Cannot save to " + file.getAbsolutePath(), e);
        }
    }
}

