/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.utils;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import pl.baczkowicz.spy.exceptions.ConversionException;
import pl.baczkowicz.spy.exceptions.CriticalException;

public class ConversionUtils {
    public static final String LINE_SEPARATOR_LINUX = "\n";
    public static final String LINE_SEPARATOR_MAC = "\r";
    public static final String LINE_SEPARATOR_WIN = "\r\n";
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static String stringToHex(String data) {
        return new String(Hex.encodeHex(ConversionUtils.stringToArray(data)));
    }

    public static String hexToString(String data) throws ConversionException {
        try {
            return ConversionUtils.arrayToString(Hex.decodeHex(data.toCharArray()));
        }
        catch (DecoderException e) {
            throw new ConversionException("Cannot convert given hex text into plain text", e);
        }
    }

    public static byte[] hexToArray(String data) throws ConversionException {
        try {
            return Hex.decodeHex(data.toCharArray());
        }
        catch (DecoderException e) {
            throw new ConversionException("Cannot convert given hex text into plain text", e);
        }
    }

    public static String arrayToHex(byte[] plainArray) {
        return Hex.encodeHexString(plainArray);
    }

    public static String arrayToString(byte[] data) {
        try {
            return new String(data, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new CriticalException("Cannot use UTF-8", e);
        }
    }

    public static byte[] stringToArray(String data) {
        try {
            return data.getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new CriticalException("Cannot use UTF-8", e);
        }
    }

    public static String hexToStringNoException(String data) {
        try {
            return ConversionUtils.arrayToString(Hex.decodeHex(data.toCharArray()));
        }
        catch (DecoderException e) {
            return "[invalid hex]";
        }
    }

    public static String base64ToString(String data) {
        return ConversionUtils.arrayToString(Base64.decodeBase64(data));
    }

    public static byte[] base64ToArray(String text) {
        return Base64.decodeBase64(text);
    }

    public static String stringToBase64(String data) {
        return Base64.encodeBase64String(ConversionUtils.stringToArray(data));
    }

    public static String arrayToBase64(byte[] payload) {
        return Base64.encodeBase64String(payload);
    }
}

