/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.utils;

import com.sun.javafx.scene.control.behavior.TabPaneBehavior;
import com.sun.javafx.scene.control.skin.TabPaneSkin;
import java.util.Collection;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.TabController;
import pl.baczkowicz.spy.ui.utils.DialogFactory;

public class TabUtils {
    public static void requestClose(Tab tab) {
        TabPaneBehavior behavior = TabUtils.getBehavior(tab);
        if (behavior.canCloseTab(tab)) {
            behavior.closeTab(tab);
        }
    }

    private static TabPaneBehavior getBehavior(Tab tab) {
        return (TabPaneBehavior)((TabPaneSkin)tab.getTabPane().getSkin()).getBehavior();
    }

    private static Tab copyTab(Tab tabToCopy, ContextMenu contextMenu, TabController controller, TabPane tabPane) {
        Tab newTab = new Tab();
        newTab.setContextMenu(contextMenu);
        newTab.setText(tabToCopy.getText());
        newTab.setGraphic(tabToCopy.getGraphic());
        newTab.setTooltip(tabToCopy.getTooltip());
        newTab.setContent(tabToCopy.getContent());
        newTab.setStyle(tabToCopy.getStyle());
        newTab.getStyleClass().addAll((Collection)tabToCopy.getStyleClass());
        controller.setTab(newTab);
        tabPane.getTabs().add((Object)newTab);
        controller.refreshStatus();
        return newTab;
    }

    public static EventHandler<ActionEvent> createTabDetachEvent(final MenuItem menuItem, final TabController controller, final String windowTitle, final double margin) {
        EventHandler<ActionEvent> detachEvent = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Tab tab = controller.getTab();
                final boolean closableWhenAttached = tab.isClosable();
                tab.getContextMenu().hide();
                ContextMenu existingContextMenu = tab.getContextMenu();
                tab.setContextMenu(null);
                final TabPane tabPane = new TabPane();
                controller.getTabStatus().getParentWhenAttached().getTabs().remove((Object)tab);
                TabUtils.copyTab(tab, existingContextMenu, controller, tabPane);
                controller.getTabStatus().setVisibility(PaneVisibilityStatus.DETACHED);
                controller.getTab().setClosable(false);
                menuItem.setDisable(true);
                final Stage stage = DialogFactory.createWindowWithPane((Node)tabPane, controller.getTabStatus().getParentWhenAttached().getScene(), windowTitle, margin);
                controller.getTab().setOnCloseRequest((EventHandler)new EventHandler<Event>(){

                    public void handle(Event event) {
                        stage.close();
                    }
                });
                stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        if (tabPane.getTabs().size() > 0) {
                            Tab tab = controller.getTab();
                            ContextMenu existingContextMenu = tab.getContextMenu();
                            tab.setContextMenu(null);
                            tabPane.getTabs().remove((Object)tab);
                            TabUtils.copyTab(tab, existingContextMenu, controller, controller.getTabStatus().getParentWhenAttached());
                            controller.getTabStatus().setVisibility(PaneVisibilityStatus.ATTACHED);
                            controller.getTab().setClosable(closableWhenAttached);
                            menuItem.setDisable(false);
                        }
                    }
                });
                stage.show();
            }
        };
        return detachEvent;
    }
}

