/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.utils;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Pair;
import pl.baczkowicz.spy.exceptions.ExceptionUtils;
import pl.baczkowicz.spy.ui.configuration.BaseConfigurationManager;
import pl.baczkowicz.spy.ui.controls.CommandLinksDialog;
import pl.baczkowicz.spy.ui.controls.DialogAction;
import pl.baczkowicz.spy.ui.controls.WorkerProgressPane;
import pl.baczkowicz.spy.ui.utils.ImageUtils;

public class DialogFactory {
    public static void createErrorDialog(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setContentText(message);
        alert.setHeaderText(null);
        alert.showAndWait();
    }

    public static void createExceptionDialog(String title, String contentText, String multilineText) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(contentText);
        TextArea textArea = new TextArea(multilineText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane content = new GridPane();
        content.setMaxWidth(Double.MAX_VALUE);
        content.add((Node)textArea, 0, 0);
        alert.getDialogPane().setExpandableContent((Node)content);
        alert.getDialogPane().setExpanded(true);
        alert.showAndWait();
    }

    public static void createExceptionDialog(String title, Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        DialogFactory.createExceptionDialog(title, e.getMessage() + " - " + ExceptionUtils.getRootCauseMessage(e), sw.toString());
    }

    public static void createWarningDialog(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle(title);
        alert.setContentText(message + ".");
        alert.setHeaderText(null);
        alert.showAndWait();
    }

    public static Optional<ButtonType> createQuestionDialog(String title, String message, boolean showNoButton) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(title);
        alert.setContentText(message);
        alert.setHeaderText(null);
        if (showNoButton) {
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.NO, ButtonType.YES});
        } else {
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.YES});
        }
        return alert.showAndWait();
    }

    public static Optional<String> createInputDialog(Window owner, String title, String label) {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle(title);
        dialog.setHeaderText(null);
        dialog.setContentText(label);
        dialog.initOwner(owner);
        return dialog.showAndWait();
    }

    public static Optional<ButtonType> createQuestionDialog(String title, String message) {
        return DialogFactory.createQuestionDialog(title, message, true);
    }

    public static Optional<Pair<String, String>> createUsernameAndPasswordDialog(String title, String header, Pair<String, String> userInfo) {
        Dialog dialog = new Dialog();
        dialog.setResizable(false);
        dialog.setTitle(title);
        dialog.setHeaderText(header);
        dialog.setGraphic((Node)ImageUtils.createIcon("preferences-desktop-user-password-large", 48));
        ButtonType loginButtonType = new ButtonType("Connect", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{loginButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(15.0);
        grid.setVgap(15.0);
        grid.setPadding(new Insets(15.0, 100.0, 15.0, 15.0));
        TextField username = new TextField();
        username.setPromptText("Username");
        username.setText((String)userInfo.getKey());
        PasswordField password = new PasswordField();
        password.setPromptText("Password");
        password.setText((String)userInfo.getValue());
        grid.add((Node)new Label("Username:"), 0, 0);
        grid.add((Node)username, 1, 0);
        grid.add((Node)new Label("Password:"), 0, 1);
        grid.add((Node)password, 1, 1);
        Node loginButton = dialog.getDialogPane().lookupButton(loginButtonType);
        loginButton.setDisable(username.getText().trim().isEmpty());
        username.textProperty().addListener((observable, oldValue, newValue) -> loginButton.setDisable(newValue.trim().isEmpty()));
        dialog.getDialogPane().setContent((Node)grid);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == loginButtonType) {
                return new Pair((Object)username.getText(), (Object)password.getText());
            }
            return null;
        });
        Platform.runLater(() -> username.requestFocus());
        return dialog.showAndWait();
    }

    public static Stage createWindowWithPane(Node pane, Scene parentScene, String title, double margin) {
        Stage stage = new Stage(StageStyle.UTILITY);
        AnchorPane content = new AnchorPane();
        content.getChildren().add((Object)pane);
        AnchorPane.setBottomAnchor((Node)pane, (Double)margin);
        AnchorPane.setLeftAnchor((Node)pane, (Double)margin);
        AnchorPane.setTopAnchor((Node)pane, (Double)margin);
        AnchorPane.setRightAnchor((Node)pane, (Double)margin);
        Scene scene = new Scene((Parent)content);
        scene.getStylesheets().addAll((Collection)parentScene.getStylesheets());
        stage.initOwner(parentScene.getWindow());
        stage.setTitle(title);
        stage.setScene(scene);
        return stage;
    }

    public static Color createColorChoiceDialog(Color color, String title, String label) {
        Dialog dialog = new Dialog();
        dialog.setResizable(false);
        dialog.setTitle(title);
        dialog.setHeaderText(null);
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(15.0);
        grid.setVgap(15.0);
        grid.setPadding(new Insets(15.0, 100.0, 15.0, 15.0));
        ColorPicker picker = new ColorPicker(color);
        grid.add((Node)new Label(label), 0, 0);
        grid.add((Node)picker, 1, 0);
        dialog.getDialogPane().setContent((Node)grid);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.APPLY) {
                return (Color)picker.getValue();
            }
            return null;
        });
        Platform.runLater(() -> picker.requestFocus());
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (Color)result.get();
        }
        return color;
    }

    public static void createWorkerDialog(Task<?> readAndProcess) {
        Alert dialog = new Alert(Alert.AlertType.INFORMATION);
        dialog.setTitle(readAndProcess.getTitle());
        dialog.setHeaderText(null);
        ButtonType bgButtonType = new ButtonType("Run in background", ButtonBar.ButtonData.APPLY);
        dialog.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, bgButtonType});
        Label progressMessage = new Label();
        progressMessage.textProperty().bind((ObservableValue)readAndProcess.messageProperty());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.CANCEL) {
                readAndProcess.cancel();
            }
            return null;
        });
        WorkerProgressPane content = new WorkerProgressPane(dialog);
        content.setMaxWidth(Double.MAX_VALUE);
        VBox vbox = new VBox(10.0, new Node[]{progressMessage, content});
        vbox.setMaxWidth(Double.MAX_VALUE);
        vbox.setPrefSize(400.0, 80.0);
        dialog.getDialogPane().setContent((Node)vbox);
        content.setWorker((Worker<?>)readAndProcess);
    }

    public static void setUpTextFieldFileOpenButton(final TextField field, Button button) {
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Select file to open");
                File selectedFile = fileChooser.showOpenDialog(field.getScene().getWindow());
                if (selectedFile != null) {
                    field.setText(selectedFile.getAbsolutePath());
                }
            }
        });
    }

    public static boolean showDefaultConfigurationFileMissingChoice(String title, Scene scene) {
        DialogAction createWithSample = new DialogAction("Create " + BaseConfigurationManager.APPLICATION_NAME + " configuration file with sample content", System.getProperty("line.separator") + "This creates a configuration file in \"" + BaseConfigurationManager.getDefaultHomeDirectory() + "\" called \"" + BaseConfigurationManager.getDefaultConfigurationFileName() + "\", which will include sample connections to localhost and iot.eclipse.org.");
        DialogAction createEmpty = new DialogAction("Create empty " + BaseConfigurationManager.APPLICATION_NAME + " configuration file", System.getProperty("line.separator") + "This creates a configuration file in \"" + BaseConfigurationManager.getDefaultHomeDirectory() + "\" called \"" + BaseConfigurationManager.getDefaultConfigurationFileName() + "\" with no sample connections.");
        DialogAction copyExisting = new DialogAction("Copy existing " + BaseConfigurationManager.APPLICATION_NAME + " configuration file", System.getProperty("line.separator") + "This copies an existing configuration file (selected in the next step) to \"" + BaseConfigurationManager.getDefaultHomeDirectory() + "\" and renames it to \"" + BaseConfigurationManager.getDefaultConfigurationFileName() + "\".");
        DialogAction dontDoAnything = new DialogAction("Don't do anything", System.getProperty("line.separator") + "You can still point " + BaseConfigurationManager.APPLICATION_NAME + " at your chosen configuration file by using the \"--configuration=my_custom_path\" command line parameter or open a configuration file from the main menu.");
        List<DialogAction> links = Arrays.asList(createWithSample, createEmpty, copyExisting, dontDoAnything);
        Optional<DialogAction> response = CommandLinksDialog.showCommandLinks(title, "Please select one of the following options with regards to the " + BaseConfigurationManager.APPLICATION_NAME + " configuration file:", links.get(0), links, 550.0, 650, 30, 110.0, (List<String>)scene.getStylesheets());
        boolean configurationFileCreated = false;
        if (response.isPresent()) {
            if (response.get().getHeading().toLowerCase().contains("sample")) {
                configurationFileCreated = BaseConfigurationManager.createDefaultConfigFromClassPath("sample");
            } else if (response.get().getHeading().toLowerCase().contains("empty")) {
                configurationFileCreated = BaseConfigurationManager.createDefaultConfigFromClassPath("empty");
            } else if (response.get().getHeading().toLowerCase().contains("copy")) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Select configuration file to copy");
                String extensions = "xml";
                fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("XML file", new String[]{extensions}));
                File selectedFile = fileChooser.showOpenDialog(scene.getWindow());
                if (selectedFile != null) {
                    configurationFileCreated = BaseConfigurationManager.createDefaultConfigFromFile(selectedFile);
                }
            }
        }
        return configurationFileCreated;
    }
}

