/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.storage.summary;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.properties.SubscriptionTopicSummaryProperties;
import pl.baczkowicz.spy.ui.storage.summary.TopicSummary;

public class ObservableTopicSummary<T extends FormattedMessage>
extends TopicSummary<T> {
    private final ObservableList<SubscriptionTopicSummaryProperties<T>> observableTopicSummaryList = FXCollections.observableArrayList();

    public ObservableTopicSummary(String name, int maxPayloadLength) {
        super(name, maxPayloadLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map map = this.topicToSummaryMapping;
        synchronized (map) {
            super.clear();
            this.observableTopicSummaryList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionTopicSummaryProperties<T> addMessage(T message) {
        Map map = this.topicToSummaryMapping;
        synchronized (map) {
            AtomicBoolean newAdded = new AtomicBoolean(false);
            SubscriptionTopicSummaryProperties<T> updatedElement = super.addMessage(message, newAdded);
            if (newAdded.get()) {
                this.observableTopicSummaryList.add(updatedElement);
            }
            return updatedElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleShowValues(Collection<String> topics) {
        Map map = this.topicToSummaryMapping;
        synchronized (map) {
            for (String topic : topics) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)this.topicToSummaryMapping.get(topic);
                if (item == null) continue;
                item.showProperty().set(!item.showProperty().get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowValue(String topic, boolean value) {
        Map map = this.topicToSummaryMapping;
        synchronized (map) {
            SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)this.topicToSummaryMapping.get(topic);
            if (item != null) {
                item.showProperty().set(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowValues(Collection<String> topics, boolean value) {
        Map map = this.topicToSummaryMapping;
        synchronized (map) {
            for (SubscriptionTopicSummaryProperties item : this.observableTopicSummaryList) {
                if (!topics.contains(item.topicProperty().getValue())) continue;
                item.showProperty().set(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllShowValues(boolean value) {
        Map map = this.topicToSummaryMapping;
        synchronized (map) {
            for (SubscriptionTopicSummaryProperties item : this.observableTopicSummaryList) {
                item.showProperty().set(value);
            }
        }
    }

    public ObservableList<SubscriptionTopicSummaryProperties<T>> getObservableMessagesPerTopic() {
        return this.observableTopicSummaryList;
    }

    public void setFormatter(FormatterDetails messageFormat, FormattingManager formattingManager) {
        super.setFormatter(messageFormat);
        for (SubscriptionTopicSummaryProperties item : this.observableTopicSummaryList) {
            formattingManager.formatMessage((FormattedMessage)item.getMqttContent(), messageFormat);
            item.updateReceivedPayload(((FormattedMessage)item.getMqttContent()).getFormattedPayload());
        }
    }
}

