/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.storage;

import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.messages.IBaseMessage;
import pl.baczkowicz.spy.storage.MessageList;
import pl.baczkowicz.spy.ui.storage.summary.ObservableTopicSummary;

public class MessageListWithObservableTopicSummary<T extends FormattedMessage>
extends MessageList<T> {
    private final ObservableTopicSummary<T> topicSummary;

    public MessageListWithObservableTopicSummary(int preferredSize, int maxSize, String name, FormatterDetails messageFormat, int maxPayloadLength) {
        super(preferredSize, maxSize, name);
        this.topicSummary = new ObservableTopicSummary(name, maxPayloadLength);
        this.topicSummary.setFormatter(messageFormat);
    }

    public ObservableTopicSummary<T> getTopicSummary() {
        return this.topicSummary;
    }

    @Override
    public T add(T message) {
        FormattedMessage removed = (FormattedMessage)super.add(message);
        if (removed != null) {
            this.topicSummary.decreaseCount(removed);
        }
        this.topicSummary.increaseCount((IBaseMessage)message);
        return (T)removed;
    }

    @Override
    public T remove(int index) {
        FormattedMessage removed = (FormattedMessage)super.remove(index);
        this.topicSummary.decreaseCount(removed);
        return (T)removed;
    }
}

