/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.storage;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.search.MessageFilter;
import pl.baczkowicz.spy.ui.storage.BasicMessageStoreWithSummary;
import pl.baczkowicz.spy.ui.storage.MessageListWithObservableTopicSummary;

public class FilteredMessageStore<T extends FormattedMessage>
extends BasicMessageStoreWithSummary<T> {
    static final Logger logger = LoggerFactory.getLogger(FilteredMessageStore.class);
    private final Set<String> browsedTopics = new HashSet<String>();
    private final MessageListWithObservableTopicSummary<T> allMessages;
    private final Set<MessageFilter<T>> messageFilters = new HashSet<MessageFilter<T>>();

    public FilteredMessageStore(MessageListWithObservableTopicSummary<T> allMessages, int preferredSize, int maxSize, String name, FormatterDetails messageFormat, FormattingManager formattingManager, int maxPayloadLength) {
        super("filtered-" + name, preferredSize, maxSize, maxPayloadLength, formattingManager);
        this.setFormatter(messageFormat);
        this.allMessages = allMessages;
    }

    public void addMessageFilter(MessageFilter<T> messageFilter) {
        this.messageFilters.add(messageFilter);
    }

    public void removeMessageFilter(MessageFilter<T> messageFilter) {
        this.messageFilters.remove(messageFilter);
    }

    public void runFilter(MessageFilter<T> messageFilter) {
        this.reinitialiseFilteredStore();
    }

    @Override
    public boolean messageFiltersEnabled() {
        for (MessageFilter<T> filter : this.messageFilters) {
            if (!filter.isActive()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitialiseFilteredStore() {
        this.getMessageList().clear();
        logger.trace("[{}] Store reinitialise = {}/{}", this.allMessages.getName(), this.allMessages.getMessages().size(), this.allMessages);
        List list = this.allMessages.getMessages();
        synchronized (list) {
            int size = this.allMessages.getMessages().size();
            for (int i = size - 1; i >= 0; --i) {
                FormattedMessage message = (FormattedMessage)this.allMessages.getMessages().get(i);
                if (!this.browsedTopics.contains(message.getTopic()) || this.filterMessage(message, false)) continue;
                ((MessageListWithObservableTopicSummary)this.getMessageList()).add(message);
            }
        }
    }

    public boolean filterMessage(T message, boolean updateUi) {
        for (MessageFilter<T> filter : this.messageFilters) {
            if (!filter.filter(message, this.getMessageList(), updateUi)) continue;
            return true;
        }
        return false;
    }

    public boolean updateTopicFilter(String topic, boolean show) {
        boolean updated = false;
        updated = show ? this.applyTopicFilter(topic, true) : this.removeTopicFilter(topic);
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllTopicFilters() {
        this.removeAllTopicFilters();
        List list = this.allMessages.getMessages();
        synchronized (list) {
            for (FormattedMessage message : this.allMessages.getMessages()) {
                this.browsedTopics.add(message.getTopic());
                if (this.filterMessage(message, false)) continue;
                ((MessageListWithObservableTopicSummary)this.getMessageList()).add(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTopicFilters() {
        Set<String> set = this.browsedTopics;
        synchronized (set) {
            this.browsedTopics.clear();
            this.getMessageList().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTopicFilters(Collection<String> topics, boolean recreateStore) {
        Set<String> set = this.browsedTopics;
        synchronized (set) {
            boolean updated = false;
            for (String topic : topics) {
                if (this.browsedTopics.contains(topic)) continue;
                logger.debug("Adding {} to active filters for {}; recreate = {}", topic, this.allMessages.getName(), recreateStore);
                this.browsedTopics.add(topic);
                updated = true;
            }
            if (updated && recreateStore) {
                logger.warn("Recreating store for topics in {}", (Object)this.allMessages.getName());
                this.reinitialiseFilteredStore();
            }
            return updated;
        }
    }

    public boolean applyTopicFilter(String topic, boolean recreateStore) {
        return this.applyTopicFilters(Arrays.asList(topic), recreateStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTopicFilters(Collection<String> topics) {
        Set<String> set = this.browsedTopics;
        synchronized (set) {
            boolean updated = false;
            for (String topic : topics) {
                if (!this.browsedTopics.contains(topic)) continue;
                logger.debug("Removing {} from active filters for {}", (Object)topic, (Object)this.allMessages.getName());
                this.browsedTopics.remove(topic);
                updated = true;
            }
            if (updated) {
                this.reinitialiseFilteredStore();
            }
            return updated;
        }
    }

    private boolean removeTopicFilter(String topic) {
        return this.removeTopicFilters(Arrays.asList(topic));
    }

    public MessageListWithObservableTopicSummary<T> getFilteredMessages() {
        return this.getMessageList();
    }

    public Set<String> getBrowsedTopics() {
        return Collections.unmodifiableSet(this.browsedTopics);
    }
}

