/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.storage;

import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.storage.BasicMessageStore;
import pl.baczkowicz.spy.ui.storage.MessageListWithObservableTopicSummary;
import pl.baczkowicz.spy.ui.storage.MessageStoreGarbageCollector;

public class BasicMessageStoreWithSummary<T extends FormattedMessage>
extends BasicMessageStore<T> {
    private MessageStoreGarbageCollector<T> messageStoreGarbageCollector;
    protected FormattingManager formattingManager;
    private MessageListWithObservableTopicSummary<T> messageListWithTopicSummary;

    public BasicMessageStoreWithSummary(String name, int preferredSize, int maxSize, int maxPayloadLength, FormattingManager formattingManager) {
        super(null);
        this.formattingManager = formattingManager;
        this.messageListWithTopicSummary = new MessageListWithObservableTopicSummary(preferredSize, maxSize, name, this.messageFormat, maxPayloadLength);
        this.setMessageList(this.messageListWithTopicSummary);
    }

    @Override
    public MessageListWithObservableTopicSummary<T> getMessageList() {
        return this.messageListWithTopicSummary;
    }

    @Override
    public void clear() {
        this.messageListWithTopicSummary.clear();
        this.messageListWithTopicSummary.getTopicSummary().clear();
    }

    @Override
    public void setFormatter(FormatterDetails messageFormat) {
        this.messageFormat = messageFormat;
        this.messageListWithTopicSummary.getTopicSummary().setFormatter(messageFormat, this.formattingManager);
    }

    public MessageStoreGarbageCollector<T> getMessageStoreGarbageCollector() {
        return this.messageStoreGarbageCollector;
    }

    public void setMessageStoreGarbageCollector(MessageStoreGarbageCollector<T> messageStoreGarbageCollector) {
        this.messageStoreGarbageCollector = messageStoreGarbageCollector;
    }
}

