/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.properties;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.scripts.ScriptChangeObserver;
import pl.baczkowicz.spy.scripts.ScriptRunningState;
import pl.baczkowicz.spy.ui.scripts.ScriptTypeEnum;
import pl.baczkowicz.spy.utils.TimeUtils;

public class PublicationScriptProperties
implements ScriptChangeObserver {
    private SimpleObjectProperty<ScriptRunningState> statusProperty;
    private SimpleObjectProperty<ScriptTypeEnum> typeProperty;
    private SimpleStringProperty lastPublishedProperty;
    private SimpleLongProperty countProperty;
    private SimpleBooleanProperty repeatProperty;
    private Script script;

    public PublicationScriptProperties(Script script) {
        this.script = script;
        this.statusProperty = new SimpleObjectProperty((Object)ScriptRunningState.NOT_STARTED);
        this.typeProperty = new SimpleObjectProperty((Object)ScriptTypeEnum.PUBLICATION);
        this.lastPublishedProperty = new SimpleStringProperty("");
        this.countProperty = new SimpleLongProperty(0L);
        this.repeatProperty = new SimpleBooleanProperty(false);
        this.repeatProperty.set(script.getScriptDetails() != null && Boolean.TRUE.equals(script.getScriptDetails().isRepeat()));
        this.update();
    }

    public void update() {
        this.countProperty.set(this.script.getMessagesPublished());
        this.statusProperty().set((Object)this.script.getStatus());
        if (this.script.getLastPublishedDate() != null) {
            this.lastPublishedProperty.set(TimeUtils.DATE_WITH_SECONDS_SDF.format(this.script.getLastPublishedDate()));
        }
    }

    public SimpleObjectProperty<ScriptRunningState> statusProperty() {
        return this.statusProperty;
    }

    public SimpleObjectProperty<ScriptTypeEnum> typeProperty() {
        return this.typeProperty;
    }

    public SimpleStringProperty lastPublishedProperty() {
        return this.lastPublishedProperty;
    }

    public SimpleLongProperty countProperty() {
        return this.countProperty;
    }

    public SimpleBooleanProperty repeatProperty() {
        return this.repeatProperty;
    }

    public String getName() {
        return this.script.getNameWithSubdirectory();
    }

    public boolean isRepeat() {
        return this.repeatProperty.getValue();
    }

    public void setRepeat(boolean value) {
        this.script.getScriptDetails().setRepeat(value);
        this.repeatProperty.set(this.script.getScriptDetails().isRepeat().booleanValue());
    }

    public Script getScript() {
        return this.script;
    }

    @Override
    public void onChange() {
        this.update();
    }
}

