/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.properties;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.messages.BaseMessage;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.properties.BaseTopicProperty;
import pl.baczkowicz.spy.utils.TimeUtils;

public class MessageContentProperties<T extends FormattedMessage>
extends BaseTopicProperty {
    static final Logger logger = LoggerFactory.getLogger(MessageContentProperties.class);
    private StringProperty lastReceivedTimestamp = new SimpleStringProperty();
    private StringProperty lastReceivedPayload = new SimpleStringProperty();
    private StringProperty lastReceivedPayloadShort = new SimpleStringProperty();
    private T mqttContent;
    private int maxPayloadLength;

    public MessageContentProperties(T message, int maxPayloadLength) {
        super(((BaseMessage)message).getTopic());
        this.maxPayloadLength = maxPayloadLength;
        this.setMessage(message);
    }

    public void updateReceivedPayload(String formattedText) {
        if (this.maxPayloadLength > 0) {
            int lengthToSet = Math.min(formattedText.length(), this.maxPayloadLength);
            this.lastReceivedPayloadShort.set((Object)formattedText.substring(0, lengthToSet));
        } else {
            this.lastReceivedPayloadShort.set((Object)formattedText);
        }
        this.lastReceivedPayload.set((Object)formattedText);
    }

    public T getMqttContent() {
        return this.mqttContent;
    }

    public String getSubscription() {
        return ((FormattedMessage)this.mqttContent).getSubscription();
    }

    public void setMessage(T message) {
        this.mqttContent = message;
        this.lastReceivedTimestamp.set((Object)TimeUtils.DATE_WITH_MILLISECONDS_SDF.format(((BaseMessage)this.mqttContent).getDate()));
        this.updateReceivedPayload(((FormattedMessage)this.mqttContent).getFormattedPayload());
    }

    public long getId() {
        return ((BaseMessage)this.mqttContent).getId();
    }

    public StringProperty lastReceivedTimestampProperty() {
        return this.lastReceivedTimestamp;
    }

    public StringProperty lastReceivedPayloadProperty() {
        return this.lastReceivedPayload;
    }

    public StringProperty lastReceivedPayloadShortProperty() {
        return this.lastReceivedPayloadShort;
    }
}

