/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.properties;

import java.util.ArrayList;
import java.util.List;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;

public class ConnectionTreeItemProperties {
    private ConnectionTreeItemProperties parent;
    private boolean grouping;
    private String name;
    private ModifiableConnection connectionGroup;
    private ModifiableConnection connection;
    private List<ConnectionTreeItemProperties> children = new ArrayList<ConnectionTreeItemProperties>();
    private int id;

    public ConnectionTreeItemProperties(int id) {
        this.id = id;
    }

    public boolean isGroup() {
        return this.grouping;
    }

    public void setGrouping(boolean grouping) {
        this.grouping = grouping;
    }

    public String getName() {
        if (!this.grouping && this.connection.isModified() || this.grouping && this.connectionGroup.isModified()) {
            return "* " + this.name;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModifiableConnection getGroup() {
        return this.connectionGroup;
    }

    public void setGroup(ModifiableConnection connectionGroup) {
        this.connectionGroup = connectionGroup;
        this.grouping = true;
        this.name = connectionGroup.getName();
    }

    public ModifiableConnection getConnection() {
        return this.connection;
    }

    public void setConnection(ModifiableConnection connection) {
        this.connection = connection;
        this.grouping = false;
        this.name = connection.getName();
    }

    public String toString() {
        return this.getName();
    }

    public ConnectionTreeItemProperties getParent() {
        return this.parent;
    }

    public void setParent(ConnectionTreeItemProperties parent) {
        this.parent = parent;
    }

    public void addChild(ConnectionTreeItemProperties group) {
        this.children.add(group);
    }

    public List<ConnectionTreeItemProperties> getChildren() {
        return this.children;
    }

    public String getId() {
        return String.valueOf(this.id);
    }
}

