/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controls;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.scene.control.Alert;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Region;

public class WorkerProgressPane
extends Region {
    private Worker<?> worker;
    private boolean dialogVisible = false;
    private boolean cancelDialogShow = false;
    private ChangeListener<Worker.State> stateListener = new ChangeListener<Worker.State>(){

        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State old, Worker.State value) {
            switch (value) {
                case CANCELLED: 
                case FAILED: 
                case SUCCEEDED: {
                    if (!WorkerProgressPane.this.dialogVisible) {
                        WorkerProgressPane.this.cancelDialogShow = true;
                        break;
                    }
                    if (old != Worker.State.SCHEDULED && old != Worker.State.RUNNING) break;
                    WorkerProgressPane.this.end();
                    break;
                }
                case SCHEDULED: {
                    WorkerProgressPane.this.begin();
                    break;
                }
            }
        }
    };
    private final Alert dialog;
    private final ProgressBar progressBar;

    public final void setWorker(Worker<?> newWorker) {
        if (newWorker != this.worker) {
            if (this.worker != null) {
                this.worker.stateProperty().removeListener(this.stateListener);
                this.end();
            }
            this.worker = newWorker;
            if (newWorker != null) {
                newWorker.stateProperty().addListener(this.stateListener);
                if (newWorker.getState() == Worker.State.RUNNING || newWorker.getState() == Worker.State.SCHEDULED) {
                    this.begin();
                }
            }
        }
    }

    public WorkerProgressPane(Alert dialog) {
        this.dialog = dialog;
        this.progressBar = new ProgressBar();
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().add((Object)this.progressBar);
        if (this.worker != null) {
            this.progressBar.progressProperty().bind((ObservableValue)this.worker.progressProperty());
        }
    }

    private void begin() {
        this.cancelDialogShow = false;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!WorkerProgressPane.this.cancelDialogShow) {
                    WorkerProgressPane.this.progressBar.progressProperty().bind((ObservableValue)WorkerProgressPane.this.worker.progressProperty());
                    WorkerProgressPane.this.dialogVisible = true;
                    WorkerProgressPane.this.dialog.show();
                }
            }
        });
    }

    private void end() {
        this.progressBar.progressProperty().unbind();
        this.dialogVisible = false;
        this.dialog.hide();
        this.dialog.close();
    }

    protected void layoutChildren() {
        if (this.progressBar != null) {
            Insets insets = this.getInsets();
            double w = this.getWidth() - insets.getLeft() - insets.getRight();
            double h = this.getHeight() - insets.getTop() - insets.getBottom();
            double prefH = this.progressBar.prefHeight(-1.0);
            double x = insets.getLeft() + (w - w) / 2.0;
            double y = insets.getTop() + (h - prefH) / 2.0;
            this.progressBar.resizeRelocate(x, y, w, prefH);
        }
    }
}

