/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controls;

import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.ui.utils.ImageUtils;

public class GettingInvolvedTooltip
extends Tooltip {
    private static final Logger logger = LoggerFactory.getLogger(GettingInvolvedTooltip.class);
    private boolean hideRequested;
    private MouseEvent mousePositionOnShown;
    private MouseEvent currentMousePosition;

    public GettingInvolvedTooltip(String textValue, String logo) {
        HBox tooltipContent = new HBox();
        Label text = new Label(textValue);
        text.getStyleClass().add((Object)"small-font");
        tooltipContent.getChildren().addAll((Object[])new Node[]{ImageUtils.createIcon(logo, 70), text});
        tooltipContent.setSpacing(20.0);
        tooltipContent.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        this.setGraphic((Node)tooltipContent);
        this.setAutoHide(false);
        this.setHideOnEscape(true);
        this.setOpacity(0.95);
    }

    protected void show() {
        this.getScene().setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ESCAPE)) {
                    logger.trace("Escape - closing tooltip");
                    GettingInvolvedTooltip.this.hideTooltip();
                }
            }
        });
        super.show();
        this.mousePositionOnShown = this.currentMousePosition;
    }

    public void hide() {
        logger.trace("Hiding tooltip request...");
        this.hideRequested = true;
        this.checkAndHide();
    }

    public void hideTooltip() {
        logger.trace("Hiding tooltip...");
        this.hideRequested = false;
        super.hide();
    }

    private boolean mouseFurtherThan(double delta) {
        if (this.getMousePositionOnShown() == null) {
            return false;
        }
        return Math.abs(this.getMousePositionOnShown().getSceneX() - this.getCurrentMousePosition().getSceneX()) > delta || Math.abs(this.getMousePositionOnShown().getSceneY() - this.getCurrentMousePosition().getSceneY()) > delta;
    }

    public void checkAndHide() {
        if (this.hideRequested() && this.mouseFurtherThan(5.0) || this.mouseFurtherThan(15.0)) {
            this.hideTooltip();
        }
    }

    public boolean hideRequested() {
        return this.hideRequested;
    }

    public MouseEvent getMousePositionOnShown() {
        return this.mousePositionOnShown;
    }

    public MouseEvent getCurrentMousePosition() {
        return this.currentMousePosition;
    }

    public void setCurrentMousePosition(MouseEvent currentMousePosition) {
        this.currentMousePosition = currentMousePosition;
    }
}

