/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controls;

import java.util.Iterator;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.ConnectionGroup;
import pl.baczkowicz.spy.common.generated.ConnectionGroupReference;
import pl.baczkowicz.spy.common.generated.ConnectionReference;
import pl.baczkowicz.spy.ui.configuration.ConfiguredConnectionGroupDetails;
import pl.baczkowicz.spy.ui.events.observers.ItemsReorderedObserver;
import pl.baczkowicz.spy.ui.properties.ConnectionTreeItemProperties;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;
import pl.baczkowicz.spy.ui.utils.ImageUtils;

public class DragAndDropTreeViewCell
extends TreeCell<ConnectionTreeItemProperties> {
    private static final Logger logger = LoggerFactory.getLogger(DragAndDropTreeViewCell.class);
    private ConnectionTreeItemProperties item;

    public DragAndDropTreeViewCell(final TreeView<ConnectionTreeItemProperties> treeView, final ItemsReorderedObserver controller) {
        DragAndDropTreeViewCell thisCell = this;
        this.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (DragAndDropTreeViewCell.this.item == null) {
                    return;
                }
                logger.debug("Drag detected on item = " + DragAndDropTreeViewCell.this.item);
                Dragboard dragBoard = DragAndDropTreeViewCell.this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                ClipboardContent content = new ClipboardContent();
                content.put((Object)DataFormat.PLAIN_TEXT, (Object)DragAndDropTreeViewCell.this.item.getId());
                dragBoard.setContent((Map)content);
                event.consume();
            }
        });
        this.setOnDragEntered(event -> {
            if (event.getGestureSource() != thisCell && event.getDragboard().hasString()) {
                this.setOpacity(0.3);
            }
        });
        this.setOnDragExited(event -> {
            if (event.getGestureSource() != thisCell && event.getDragboard().hasString()) {
                this.setOpacity(1.0);
            }
        });
        this.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                logger.debug("Drag done on item = " + DragAndDropTreeViewCell.this.item);
                dragEvent.consume();
            }
        });
        this.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                String idToMove;
                logger.debug("Drag over on item = " + DragAndDropTreeViewCell.this.item);
                if (dragEvent.getDragboard().hasString() && !(idToMove = dragEvent.getDragboard().getString()).equals(DragAndDropTreeViewCell.this.item.getId())) {
                    dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                }
                dragEvent.consume();
            }
        });
        this.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                logger.debug("Drag dropped on item = " + DragAndDropTreeViewCell.this.item);
                if (DragAndDropTreeViewCell.this.item == null) {
                    return;
                }
                String idToMove = dragEvent.getDragboard().getString();
                if (!idToMove.equals(DragAndDropTreeViewCell.this.item.getId())) {
                    TreeItem newParentTreeItem;
                    TreeItem treeItemToMove = DragAndDropTreeViewCell.this.findNode((TreeItem<ConnectionTreeItemProperties>)treeView.getRoot(), idToMove);
                    ConnectionTreeItemProperties treeItemPropertiesToMove = (ConnectionTreeItemProperties)treeItemToMove.getValue();
                    TreeItem requestedNewParentTreeItem = newParentTreeItem = DragAndDropTreeViewCell.this.findNode((TreeItem<ConnectionTreeItemProperties>)treeView.getRoot(), DragAndDropTreeViewCell.this.item.getId());
                    if (DragAndDropTreeViewCell.this.checkIfParentIsSubitem((TreeItem<ConnectionTreeItemProperties>)newParentTreeItem, (TreeItem<ConnectionTreeItemProperties>)treeItemToMove)) {
                        return;
                    }
                    treeItemToMove.getParent().getChildren().remove((Object)treeItemToMove);
                    treeItemPropertiesToMove.getParent().getChildren().remove(treeItemPropertiesToMove);
                    int insertIndex = newParentTreeItem.getChildren().size();
                    if (!DragAndDropTreeViewCell.this.item.isGroup()) {
                        newParentTreeItem = newParentTreeItem.getParent();
                        insertIndex = newParentTreeItem.getChildren().indexOf((Object)requestedNewParentTreeItem);
                    }
                    ConnectionTreeItemProperties newParentTreeItemProperties = (ConnectionTreeItemProperties)newParentTreeItem.getValue();
                    ConnectionTreeItemProperties oldParentTreeItemProperties = treeItemPropertiesToMove.getParent();
                    ConfiguredConnectionGroupDetails newParentGroup = (ConfiguredConnectionGroupDetails)newParentTreeItemProperties.getGroup();
                    ConfiguredConnectionGroupDetails oldParentGroup = (ConfiguredConnectionGroupDetails)oldParentTreeItemProperties.getGroup();
                    newParentTreeItem.getChildren().add(insertIndex, (Object)treeItemToMove);
                    newParentTreeItemProperties.getChildren().add(insertIndex, treeItemPropertiesToMove);
                    treeItemPropertiesToMove.setParent(newParentTreeItemProperties);
                    if (treeItemPropertiesToMove.isGroup()) {
                        ConfiguredConnectionGroupDetails groupToMove = (ConfiguredConnectionGroupDetails)treeItemPropertiesToMove.getGroup();
                        ConfiguredConnectionGroupDetails.removeFromGroup(groupToMove, (ConnectionGroup)oldParentGroup);
                        groupToMove.setGroup(new ConnectionGroupReference(newParentTreeItemProperties.getGroup()));
                        newParentGroup.getSubgroups().add(new ConnectionGroupReference(groupToMove));
                        groupToMove.setGroupingModified(true);
                        oldParentGroup.setGroupingModified(true);
                        newParentGroup.setGroupingModified(true);
                    } else {
                        ModifiableConnection connectionToMove = treeItemPropertiesToMove.getConnection();
                        ConfiguredConnectionGroupDetails.removeFromGroup(connectionToMove, (ConnectionGroup)oldParentGroup);
                        connectionToMove.setGroup(new ConnectionGroupReference(newParentTreeItemProperties.getGroup()));
                        newParentGroup.getConnections().add(insertIndex, new ConnectionReference(connectionToMove));
                        connectionToMove.setGroupingModified(true);
                        oldParentGroup.setGroupingModified(true);
                        newParentGroup.setGroupingModified(true);
                    }
                    newParentTreeItem.setExpanded(true);
                    DragAndDropTreeViewCell.this.getTreeView().getSelectionModel().select((Object)treeItemToMove);
                }
                dragEvent.consume();
                controller.onItemsReordered();
            }
        });
    }

    private boolean checkIfParentIsSubitem(TreeItem<ConnectionTreeItemProperties> newParent, TreeItem<ConnectionTreeItemProperties> treeItemToMove) {
        for (newParent = newParent.getParent(); newParent != null; newParent = newParent.getParent()) {
            if (!newParent.equals(treeItemToMove)) continue;
            logger.warn("Cannot move the object it its child!");
            return true;
        }
        return false;
    }

    private TreeItem<ConnectionTreeItemProperties> findNode(TreeItem<ConnectionTreeItemProperties> currentNode, String idToSearch) {
        TreeItem<ConnectionTreeItemProperties> result;
        block2: {
            TreeItem child;
            block1: {
                result = null;
                if (!((ConnectionTreeItemProperties)currentNode.getValue()).getId().equals(idToSearch)) break block1;
                result = currentNode;
                break block2;
            }
            if (currentNode.isLeaf()) break block2;
            Iterator iterator = currentNode.getChildren().iterator();
            while (iterator.hasNext() && (result = this.findNode((TreeItem<ConnectionTreeItemProperties>)(child = (TreeItem)iterator.next()), idToSearch)) == null) {
            }
        }
        return result;
    }

    protected void updateItem(ConnectionTreeItemProperties item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.item = item;
        if (item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            ImageView image;
            if (!item.isGroup()) {
                image = ImageUtils.createIcon("mqtt-icon", 18);
            } else {
                if (item.getGroup().getID().equals("default_group")) {
                    this.setDisclosureNode(null);
                }
                image = item.getChildren().isEmpty() ? ImageUtils.createIcon("folder-grey", 18) : ImageUtils.createIcon("folder-yellow", 18);
            }
            this.setText(item.getName());
            this.setGraphic((Node)image);
        }
    }
}

