/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controlpanel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.formatting.FormattingUtils;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.controllers.ControlPanelItemController;
import pl.baczkowicz.spy.ui.controlpanel.ItemStatus;
import pl.baczkowicz.spy.ui.events.ShowExternalWebPageEvent;
import pl.baczkowicz.spy.ui.stats.StatisticsManager;
import pl.baczkowicz.spy.utils.ThreadingUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public class ControlPanelStatsUpdater
implements Runnable {
    private static final long MILLISECONDS = new Date().getTime() - StatisticsManager.stats.getStartDate().getTime();
    private static final long DAYS = MILLISECONDS / 86400000L;
    private static final String IN_DAYS_PHRASE = DAYS > 1L ? " in " + DAYS + " days" : "";
    private static final String SINCE_PHRASE = " since " + TimeUtils.DATE_SDF.format(StatisticsManager.stats.getStartDate());
    private static final int STATS_MESSAGES = 6;
    private static final int GO_NEXT_AFTER_INTERVALS = 10;
    private static final int ONE_SECOND_INTERVAL = 1000;
    private boolean statsPlaying;
    private final List<String> gettingInvolvedDetails;
    private final ControlPanelItemController controlPanelItemController;
    private IKBus eventBus;
    private final Button bigButton;
    private int secondCounter;
    private int statMessageIndex;
    private IConfigurationManager configurationManager;

    public ControlPanelStatsUpdater(ControlPanelItemController controlPanelItemController, Button bigButton, IKBus eventBus, IConfigurationManager configurationManager) {
        this.controlPanelItemController = controlPanelItemController;
        this.bigButton = bigButton;
        this.eventBus = eventBus;
        this.configurationManager = configurationManager;
        String appName = configurationManager.getDefaultPropertyFile().getApplicationName();
        this.gettingInvolvedDetails = new ArrayList<String>(Arrays.asList("Finding " + appName + " useful? See how you can make " + appName + " even better", "Like your " + appName + "? See how you can help at", "Using " + appName + " on a regular basis? See how you can help at"));
    }

    public void show() {
        this.controlPanelItemController.setTitle("Connect to a server to start seeing processing statistics...");
        this.controlPanelItemController.setDetails("");
        this.controlPanelItemController.setStatus(ItemStatus.STATS);
        this.bigButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ControlPanelStatsUpdater.this.moveToNextStatMessage();
            }
        });
        ArrayList<Object> items = new ArrayList<Object>();
        Random r = new Random();
        items.add(new Label(this.gettingInvolvedDetails.get(r.nextInt(this.gettingInvolvedDetails.size()))));
        Hyperlink getInvolved = new Hyperlink();
        getInvolved.setText(this.configurationManager.getDefaultPropertyFile().getApplicationWikiUrl() + "Getting-involved");
        getInvolved.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ControlPanelStatsUpdater.this.eventBus.publish(new ShowExternalWebPageEvent(ControlPanelStatsUpdater.this.configurationManager.getDefaultPropertyFile().getApplicationWikiUrl() + "Getting-involved"));
            }
        });
        items.add(getInvolved);
        items.add(new Label(":)"));
        this.controlPanelItemController.getDetails().getChildren().addAll(items);
        this.statsPlaying = true;
        ControlPanelItemController.setButtonProperties(this.controlPanelItemController.getButton1(), "pause", true, new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (ControlPanelStatsUpdater.this.statsPlaying) {
                    ControlPanelItemController.setButtonProperties(ControlPanelStatsUpdater.this.controlPanelItemController.getButton1(), "play", true);
                    ControlPanelStatsUpdater.this.statsPlaying = false;
                } else {
                    ControlPanelItemController.setButtonProperties(ControlPanelStatsUpdater.this.controlPanelItemController.getButton1(), "pause", true);
                    ControlPanelStatsUpdater.this.statsPlaying = true;
                }
                event.consume();
            }
        });
        this.controlPanelItemController.refresh();
        new Thread(this).start();
    }

    private void moveToNextStatMessage() {
        this.secondCounter = 0;
        ++this.statMessageIndex;
        if (this.statMessageIndex == 6) {
            this.statMessageIndex = 0;
        }
        for (int retries = 0; !this.refreshStatsMessage(false) && retries < 6; ++retries) {
            ++this.statMessageIndex;
            if (this.statMessageIndex != 6) continue;
            this.statMessageIndex = 0;
        }
    }

    private boolean refreshStatsMessage(boolean updateOnly) {
        String appName = this.configurationManager.getDefaultPropertyFile().getApplicationName();
        if (this.statMessageIndex == 0 && StatisticsManager.stats.getConnections() > 0L) {
            this.controlPanelItemController.setTitle(String.format("Your %s made %s connection" + (StatisticsManager.stats.getConnections() > 1L ? "s" : "") + " to MQTT brokers%s.", appName, FormattingUtils.formatNumber(StatisticsManager.stats.getConnections()), IN_DAYS_PHRASE));
            return true;
        }
        if (this.statMessageIndex == 1 && StatisticsManager.stats.getMessagesPublished() > 1L) {
            this.controlPanelItemController.setTitle(String.format("Your %s published %s messages to MQTT brokers.", appName, FormattingUtils.formatNumber(StatisticsManager.stats.getMessagesPublished()), IN_DAYS_PHRASE));
            return true;
        }
        if (this.statMessageIndex == 2 && StatisticsManager.stats.getSubscriptions() > 1L) {
            this.controlPanelItemController.setTitle(String.format("Your %s made %s subscriptions to MQTT brokers%s.", appName, FormattingUtils.formatNumber(StatisticsManager.stats.getSubscriptions()), IN_DAYS_PHRASE));
            return true;
        }
        if (this.statMessageIndex == 3 && StatisticsManager.stats.getMessagesReceived() > 1L) {
            this.controlPanelItemController.setTitle(String.format("Your %s received %s messages%s.", appName, FormattingUtils.formatNumber(StatisticsManager.stats.getMessagesReceived()), SINCE_PHRASE));
            return true;
        }
        if (this.statMessageIndex == 4 && (updateOnly || StatisticsManager.getMessagesPublished() > 1L)) {
            this.controlPanelItemController.setTitle(String.format("Right now your %s is publishing %s msgs/s.", appName, StatisticsManager.getMessagesPublished()));
            return true;
        }
        if (this.statMessageIndex == 5 && (updateOnly || StatisticsManager.getMessagesReceived() > 1L)) {
            this.controlPanelItemController.setTitle(String.format("Right now your %s is munching through %d msgs/s.", appName, StatisticsManager.getMessagesReceived()));
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("Control Panel Stats Updater");
        this.secondCounter = 0;
        do {
            ++this.secondCounter;
            this.oneCycleRefresh();
            this.oneCycleMoveToNext();
        } while (!ThreadingUtils.sleep(1000L));
        ThreadingUtils.logThreadEnding();
    }

    private void oneCycleRefresh() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ControlPanelStatsUpdater.this.refreshStatsMessage(true);
            }
        });
    }

    private void oneCycleMoveToNext() {
        if (this.statsPlaying) {
            if (this.secondCounter == 10) {
                this.secondCounter = 0;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ControlPanelStatsUpdater.this.moveToNextStatMessage();
                    }
                });
            }
        } else {
            this.secondCounter = 0;
        }
    }
}

