/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.scripts.ScriptRunningState;
import pl.baczkowicz.spy.testcases.TestCaseStatus;
import pl.baczkowicz.spy.ui.properties.TestCaseProperties;
import pl.baczkowicz.spy.ui.properties.TestCaseStepProperties;
import pl.baczkowicz.spy.ui.testcases.InteractiveTestCaseManager;
import pl.baczkowicz.spy.ui.utils.ImageUtils;

public class TestCaseExecutionController
extends AnchorPane
implements Initializable {
    static final Logger logger = LoggerFactory.getLogger(TestCaseExecutionController.class);
    @FXML
    private CheckMenuItem autoExport;
    @FXML
    private Button startButton;
    @FXML
    private Button stopButton;
    @FXML
    private TableView<TestCaseStepProperties> stepsView;
    @FXML
    private TableColumn<TestCaseStepProperties, String> stepNumberColumn;
    @FXML
    private TableColumn<TestCaseStepProperties, String> descriptionColumn;
    @FXML
    private TableColumn<TestCaseStepProperties, TestCaseStatus> statusColumn;
    @FXML
    private TableColumn<TestCaseStepProperties, String> infoColumn;
    private TestCaseProperties testCaseProperties;
    private InteractiveTestCaseManager testCaseManager;

    public void initialize(URL location, ResourceBundle resources) {
        this.stepNumberColumn.setCellValueFactory((Callback)new PropertyValueFactory("stepNumber"));
        this.stepNumberColumn.setCellFactory((Callback)new Callback<TableColumn<TestCaseStepProperties, String>, TableCell<TestCaseStepProperties, String>>(){

            public TableCell<TestCaseStepProperties, String> call(TableColumn<TestCaseStepProperties, String> param) {
                TableCell<TestCaseStepProperties, String> cell = new TableCell<TestCaseStepProperties, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(item);
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.statusColumn.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.statusColumn.setCellFactory((Callback)new Callback<TableColumn<TestCaseStepProperties, TestCaseStatus>, TableCell<TestCaseStepProperties, TestCaseStatus>>(){

            public TableCell<TestCaseStepProperties, TestCaseStatus> call(TableColumn<TestCaseStepProperties, TestCaseStatus> param) {
                TableCell<TestCaseStepProperties, TestCaseStatus> cell = new TableCell<TestCaseStepProperties, TestCaseStatus>(){

                    public void updateItem(TestCaseStatus item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setGraphic(TestCaseExecutionController.this.getIconForStatus(item));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                cell.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
                return cell;
            }
        });
        this.infoColumn.setCellValueFactory((Callback)new PropertyValueFactory("executionInfo"));
        this.stepsView.setFixedCellSize(24.0);
        this.stepsView.setTableMenuButtonVisible(true);
        this.stepsView.setPlaceholder((Node)new Label("No test steps available - select a test case..."));
    }

    public void init() {
    }

    public boolean isAutoExportEnabled() {
        return this.autoExport.isSelected();
    }

    @FXML
    private void exportResult() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select location for the result file");
        File selectedFile = fileChooser.showSaveDialog(this.stepsView.getScene().getWindow());
        if (selectedFile != null) {
            this.testCaseManager.exportTestCaseResultAsCSV(this.testCaseProperties.getScript(), selectedFile);
        }
    }

    public void display(TestCaseProperties testCaseProperties, ObservableList<TestCaseStepProperties> items) {
        this.testCaseProperties = testCaseProperties;
        this.refreshState();
        this.stepsView.getItems().clear();
        logger.info("Item to display = " + items.size());
        this.stepsView.getItems().addAll(items);
    }

    public void refreshState() {
        if (ScriptRunningState.RUNNING.equals((Object)this.testCaseProperties.getScript().getStatus())) {
            this.startButton.setDisable(true);
            this.stopButton.setDisable(false);
        } else {
            this.startButton.setDisable(false);
            this.stopButton.setDisable(true);
        }
    }

    @FXML
    private void startTestCase() {
        this.testCaseManager.runTestCase(this.testCaseProperties);
        this.refreshState();
    }

    @FXML
    private void stopTestCase() {
        this.testCaseManager.stopTestCase(this.testCaseProperties);
        this.refreshState();
    }

    public Node getIconForStatus(TestCaseStatus status) {
        String iconName = null;
        switch (status) {
            case ACTIONED: {
                iconName = "testcase_actioned";
                break;
            }
            case ERROR: {
                iconName = "testcase_error";
                break;
            }
            case FAILED: {
                iconName = "testcase_fail";
                break;
            }
            case IN_PROGRESS: {
                ProgressIndicator progressIndicator = new ProgressIndicator();
                progressIndicator.setMaxSize(18.0, 18.0);
                progressIndicator.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
                return progressIndicator;
            }
            case NOT_RUN: {
                break;
            }
            case PASSED: {
                iconName = "testcase_pass";
                break;
            }
            case SKIPPED: {
                iconName = "testcase_skipped";
                break;
            }
        }
        if (iconName != null) {
            return ImageUtils.createIcon(iconName);
        }
        return null;
    }

    public void setTestCaseManager(InteractiveTestCaseManager testCaseManager) {
        this.testCaseManager = testCaseManager;
    }
}

