/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.properties.SubscriptionTopicSummaryProperties;

public class PieChartPaneController<T extends FormattedMessage>
implements Initializable,
ListChangeListener<SubscriptionTopicSummaryProperties<T>> {
    private static final Logger logger = LoggerFactory.getLogger(PieChartPaneController.class);
    private static boolean lastAutoRefresh = true;
    @FXML
    private AnchorPane chartPane;
    @FXML
    private Label showRangeLabel;
    @FXML
    private Button refreshButton;
    @FXML
    private CheckBox autoRefreshCheckBox;
    private PieChart pieChart;
    private ObservableList<PieChart.Data> pieChartData = FXCollections.observableArrayList();
    private Map<String, PieChart.Data> pieChartDataMapping = new HashMap<String, PieChart.Data>();
    private ObservableList<SubscriptionTopicSummaryProperties<T>> observableList;

    public void initialize(URL location, ResourceBundle resources) {
        this.autoRefreshCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                lastAutoRefresh = PieChartPaneController.this.autoRefreshCheckBox.isSelected();
                if (lastAutoRefresh) {
                    PieChartPaneController.this.refresh();
                }
            }
        });
    }

    public void init() {
        this.pieChart = new PieChart(this.pieChartData);
        this.chartPane.getChildren().add((Object)this.pieChart);
        AnchorPane.setBottomAnchor((Node)this.pieChart, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.pieChart, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.pieChart, (Double)45.0);
        AnchorPane.setRightAnchor((Node)this.pieChart, (Double)0.0);
        this.autoRefreshCheckBox.setSelected(lastAutoRefresh);
        this.observableList.addListener((ListChangeListener)this);
    }

    public void cleanup() {
        this.observableList.removeListener((ListChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChanged(ListChangeListener.Change<? extends SubscriptionTopicSummaryProperties<T>> c) {
        logger.info("New data available");
        if (this.autoRefreshCheckBox.isSelected()) {
            ObservableList<PieChart.Data> observableList = this.pieChartData;
            synchronized (observableList) {
                logger.info("New data available");
                this.refreshFromList((Collection<SubscriptionTopicSummaryProperties<T>>)this.observableList);
            }
        }
    }

    @FXML
    private void refresh() {
        this.refreshFromList((Collection<SubscriptionTopicSummaryProperties<T>>)this.observableList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFromList(Collection<SubscriptionTopicSummaryProperties<T>> list) {
        HashSet<String> currentTopics = new HashSet<String>();
        currentTopics.addAll(this.pieChartDataMapping.keySet());
        ObservableList<PieChart.Data> observableList = this.pieChartData;
        synchronized (observableList) {
            for (SubscriptionTopicSummaryProperties<T> newValue : list) {
                String topic = newValue.topicProperty().getValue();
                PieChart.Data lastValue = this.pieChartDataMapping.get(topic);
                if (lastValue == null) {
                    PieChart.Data data = new PieChart.Data(topic, (double)newValue.countProperty().getValue().intValue());
                    this.pieChartDataMapping.put(topic, data);
                    this.pieChartData.add((Object)data);
                } else {
                    lastValue.setPieValue((double)newValue.countProperty().getValue().intValue());
                }
                currentTopics.remove(topic);
            }
            for (String topic : currentTopics) {
                this.pieChartData.remove((Object)this.pieChartDataMapping.get(topic));
            }
        }
    }

    public void setObservableList(ObservableList<SubscriptionTopicSummaryProperties<T>> observableList) {
        this.observableList = observableList;
    }
}

