/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.imageio.ImageIO;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.gillius.jfxutils.chart.ChartPanManager;
import org.gillius.jfxutils.chart.JFXChartUtil;
import org.gillius.jfxutils.chart.StableTicksAxis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.charts.ChartMode;
import pl.baczkowicz.spy.ui.charts.ChartSeriesStatusEnum;
import pl.baczkowicz.spy.ui.charts.ChartSeriesTypeEnum;
import pl.baczkowicz.spy.ui.events.MessageAddedEvent;
import pl.baczkowicz.spy.ui.events.SaveChartSeriesEvent;
import pl.baczkowicz.spy.ui.events.ShowEditChartSeriesWindowEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseReceivedMessageEvent;
import pl.baczkowicz.spy.ui.properties.ChartSeriesProperties;
import pl.baczkowicz.spy.ui.properties.MessageLimitProperties;
import pl.baczkowicz.spy.ui.storage.BasicMessageStoreWithSummary;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.utils.TimeUtils;

public class LineChartPaneController<T extends FormattedMessage>
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(LineChartPaneController.class);
    private static boolean lastAutoRefresh = true;
    private static boolean lastDisplaySymbols = true;
    private int lastSeriesId = 0;
    private static MessageLimitProperties lastMessageLimit = new MessageLimitProperties("50 messages", 50, 0L);
    @FXML
    private AnchorPane chartPane;
    @FXML
    private Label showRangeLabel;
    @FXML
    private ComboBox<MessageLimitProperties> showRangeBox;
    @FXML
    private Button refreshButton;
    @FXML
    private CheckBox autoRefreshCheckBox;
    @FXML
    private CheckMenuItem displaySymbolsCheckBox;
    @FXML
    private MenuButton optionsButton;
    @FXML
    private CheckMenuItem saveImageOnMessage;
    @FXML
    private CheckMenuItem saveImageAtInterval;
    @FXML
    private CheckMenuItem addTimestampOnExport;
    @FXML
    private Menu autoImageExport;
    @FXML
    private Button addSeriesButton;
    @FXML
    private Button duplicateSeriesButton;
    @FXML
    private Button removeSeriesButton;
    @FXML
    private TableView<ChartSeriesProperties> seriesTable;
    @FXML
    private TableColumn<ChartSeriesProperties, String> nameColumn;
    @FXML
    private TableColumn<ChartSeriesProperties, String> topicColumn;
    @FXML
    private TableColumn<ChartSeriesProperties, ChartSeriesTypeEnum> typeColumn;
    @FXML
    private TableColumn<ChartSeriesProperties, String> statusColumn;
    @FXML
    private TableColumn<ChartSeriesProperties, String> expressionColumn;
    @FXML
    private TableColumn<ChartSeriesProperties, Boolean> visibleColumn;
    private BasicMessageStoreWithSummary<T> store;
    private IKBus eventBus;
    private Collection<String> topics;
    private Map<String, List<FormattedMessage>> chartData = new HashMap<String, List<FormattedMessage>>();
    private Map<Integer, XYChart.Series<Number, Number>> seriesIdToSeriesData = new LinkedHashMap<Integer, XYChart.Series<Number, Number>>();
    private LineChart<Number, Number> lineChart;
    private boolean warningLogged;
    private String seriesTypeName;
    private ChartMode chartMode;
    private String seriesValueName;
    private String seriesUnit;
    private File selectedImageFile;
    private boolean saveOnMessage;
    private Integer exportInterval;
    private boolean addTimestampOnAutoExport;
    private Map<String, List<ChartSeriesProperties>> topicToSeries = new HashMap<String, List<ChartSeriesProperties>>();
    private List<ChartSeriesProperties> allSeries = new ArrayList<ChartSeriesProperties>();

    public void setSeriesValueName(String seriesValueName) {
        this.seriesValueName = seriesValueName;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.duplicateSeriesButton.setDisable(true);
        this.removeSeriesButton.setDisable(true);
        this.autoRefreshCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                lastAutoRefresh = LineChartPaneController.this.autoRefreshCheckBox.isSelected();
                if (lastAutoRefresh) {
                    LineChartPaneController.this.refresh();
                }
            }
        });
        this.displaySymbolsCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                lastDisplaySymbols = LineChartPaneController.this.displaySymbolsCheckBox.isSelected();
                LineChartPaneController.this.refresh();
            }
        });
        this.showRangeBox.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                lastMessageLimit = (MessageLimitProperties)LineChartPaneController.this.showRangeBox.getValue();
                LineChartPaneController.this.refresh();
            }
        });
        NumberAxis xAxis = new NumberAxis();
        StableTicksAxis yAxis = new StableTicksAxis();
        xAxis.setForceZeroInRange(false);
        xAxis.setTickLabelFormatter((StringConverter)new StringConverter<Number>(){

            public String toString(Number object) {
                Date date = new Date(object.longValue());
                return TimeUtils.TIME_SDF.format(date);
            }

            public Number fromString(String string) {
                return null;
            }
        });
        yAxis.setForceZeroInRange(false);
        this.lineChart = new LineChart((Axis)xAxis, (Axis)yAxis);
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.nameColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.nameColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ChartSeriesProperties, String>>(){

            public void handle(TableColumn.CellEditEvent<ChartSeriesProperties, String> event) {
                ChartSeriesProperties item = (ChartSeriesProperties)event.getRowValue();
                String newValue = (String)event.getNewValue();
                item.nameProperty().set(newValue);
                LineChartPaneController.this.refresh();
            }
        });
        this.topicColumn.setCellValueFactory((Callback)new PropertyValueFactory("topic"));
        this.topicColumn.setCellFactory((Callback)new Callback<TableColumn<ChartSeriesProperties, String>, TableCell<ChartSeriesProperties, String>>(){

            public TableCell<ChartSeriesProperties, String> call(TableColumn<ChartSeriesProperties, String> p) {
                TableCell<ChartSeriesProperties, String> cell = new TableCell<ChartSeriesProperties, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.toString());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
        this.typeColumn.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.typeColumn.setCellFactory((Callback)new Callback<TableColumn<ChartSeriesProperties, ChartSeriesTypeEnum>, TableCell<ChartSeriesProperties, ChartSeriesTypeEnum>>(){

            public TableCell<ChartSeriesProperties, ChartSeriesTypeEnum> call(TableColumn<ChartSeriesProperties, ChartSeriesTypeEnum> p) {
                TableCell<ChartSeriesProperties, ChartSeriesTypeEnum> cell = new TableCell<ChartSeriesProperties, ChartSeriesTypeEnum>(){

                    public void updateItem(ChartSeriesTypeEnum item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.value());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.statusColumn.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.statusColumn.setCellFactory((Callback)new Callback<TableColumn<ChartSeriesProperties, String>, TableCell<ChartSeriesProperties, String>>(){

            public TableCell<ChartSeriesProperties, String> call(TableColumn<ChartSeriesProperties, String> p) {
                TableCell<ChartSeriesProperties, String> cell = new TableCell<ChartSeriesProperties, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        TableRow currentRow = this.getTableRow();
                        ChartSeriesProperties properties = (ChartSeriesProperties)currentRow.getItem();
                        if (!this.isEmpty() && properties != null) {
                            currentRow.getStyleClass().removeAll((Object[])new String[]{"seriesNoMessages", "seriesOK", "seriesError"});
                            currentRow.setTooltip(null);
                            if (ChartSeriesStatusEnum.NO_MESSAGES.equals((Object)properties.getSeriesStatus())) {
                                currentRow.getStyleClass().add((Object)"seriesNoMessages");
                                this.setText(null);
                            } else if (ChartSeriesStatusEnum.OK.equals((Object)properties.getSeriesStatus())) {
                                currentRow.getStyleClass().add((Object)"seriesOK");
                                this.setText(item);
                            } else {
                                currentRow.getStyleClass().add((Object)"seriesError");
                                currentRow.setTooltip(new Tooltip(properties.getErrorMessage()));
                                this.setText(item);
                            }
                        } else {
                            currentRow.getStyleClass().removeAll((Object[])new String[]{"seriesNoMessages", "seriesOK", "seriesError"});
                            currentRow.setTooltip(null);
                            this.setText(null);
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.expressionColumn.setCellValueFactory((Callback)new PropertyValueFactory("valueExpression"));
        this.expressionColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.visibleColumn.setCellValueFactory((Callback)new PropertyValueFactory("visible"));
        this.visibleColumn.setCellFactory((Callback)new Callback<TableColumn<ChartSeriesProperties, Boolean>, TableCell<ChartSeriesProperties, Boolean>>(){

            public TableCell<ChartSeriesProperties, Boolean> call(TableColumn<ChartSeriesProperties, Boolean> param) {
                CheckBoxTableCell<ChartSeriesProperties, Boolean> cell = new CheckBoxTableCell<ChartSeriesProperties, Boolean>(){

                    public void updateItem(Boolean checked, boolean empty) {
                        super.updateItem((Object)checked, empty);
                        if (!this.isEmpty() && checked != null && this.getTableRow() != null && this.getTableRow().getItem() != null && LineChartPaneController.this.store != null) {
                            ChartSeriesProperties item = (ChartSeriesProperties)this.getTableRow().getItem();
                            item.visibleProperty().set(checked.booleanValue());
                            LineChartPaneController.this.refresh();
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.seriesTable.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ChartSeriesProperties>(){

            public void changed(ObservableValue<? extends ChartSeriesProperties> observable, ChartSeriesProperties oldValue, ChartSeriesProperties newValue) {
                if (newValue != null) {
                    LineChartPaneController.this.duplicateSeriesButton.setDisable(false);
                    LineChartPaneController.this.removeSeriesButton.setDisable(false);
                } else {
                    LineChartPaneController.this.duplicateSeriesButton.setDisable(true);
                    LineChartPaneController.this.removeSeriesButton.setDisable(true);
                }
            }
        });
        this.seriesTable.setRowFactory((Callback)new Callback<TableView<ChartSeriesProperties>, TableRow<ChartSeriesProperties>>(){

            public TableRow<ChartSeriesProperties> call(TableView<ChartSeriesProperties> tableView) {
                TableRow<ChartSeriesProperties> row = new TableRow<ChartSeriesProperties>(){

                    protected void updateItem(final ChartSeriesProperties item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            MenuItem editMenu = new MenuItem("Edit...");
                            editMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                public void handle(ActionEvent event) {
                                    LineChartPaneController.this.eventBus.publish(new ShowEditChartSeriesWindowEvent(LineChartPaneController.this.chartPane.getScene().getWindow(), item));
                                }
                            });
                            ContextMenu menu = new ContextMenu(new MenuItem[]{editMenu});
                            if (ChartSeriesStatusEnum.ERROR.equals((Object)item.getSeriesStatus()) && item.getErrorMessage() != null) {
                                MenuItem errorMenu = new MenuItem("Show error...");
                                errorMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                    public void handle(ActionEvent event) {
                                        DialogFactory.createErrorDialog("Series error", item.getErrorMessage());
                                    }
                                });
                                menu.getItems().add((Object)new SeparatorMenuItem());
                                menu.getItems().add((Object)errorMenu);
                            }
                            this.setContextMenu(menu);
                        }
                    }
                };
                row.setOnMouseClicked(arg_0 -> this.lambda$call$0((TableRow)row, arg_0));
                return row;
            }

            private /* synthetic */ void lambda$call$0(TableRow row, MouseEvent event) {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    LineChartPaneController.this.eventBus.publish(new ShowEditChartSeriesWindowEvent(LineChartPaneController.this.chartPane.getScene().getWindow(), (ChartSeriesProperties)row.getItem()));
                }
            }
        });
    }

    public void init() {
        this.showRangeBox.setCellFactory((Callback)new Callback<ListView<MessageLimitProperties>, ListCell<MessageLimitProperties>>(){

            public ListCell<MessageLimitProperties> call(ListView<MessageLimitProperties> l) {
                return new ListCell<MessageLimitProperties>(){

                    protected void updateItem(MessageLimitProperties item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null || empty) {
                            this.setText(null);
                        } else {
                            this.setText(item.getName());
                        }
                    }
                };
            }
        });
        this.showRangeBox.setConverter((StringConverter)new StringConverter<MessageLimitProperties>(){

            public String toString(MessageLimitProperties item) {
                if (item == null) {
                    return null;
                }
                return item.getName();
            }

            public MessageLimitProperties fromString(String id) {
                return null;
            }
        });
        this.showRangeBox.getItems().clear();
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("All", 0, 0L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("10 messages", 10, 0L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("50 messages", 50, 0L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("100 messages", 100, 0L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("1k messages", 1000, 0L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("10k messages", 10000, 0L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("1 minute", 0, 60000L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("5 minutes", 0, 300000L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("30 minutes", 0, 1800000L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("1 hour", 0, 3600000L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("24 hours", 0, 86400000L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("48 hours", 0, 172800000L));
        this.showRangeBox.getItems().add((Object)new MessageLimitProperties("1 week", 0, 604800000L));
        this.chartPane.getChildren().add(this.lineChart);
        AnchorPane.setBottomAnchor(this.lineChart, (Double)0.0);
        AnchorPane.setLeftAnchor(this.lineChart, (Double)0.0);
        AnchorPane.setTopAnchor(this.lineChart, (Double)45.0);
        AnchorPane.setRightAnchor(this.lineChart, (Double)0.0);
        if (ChartMode.USER_DRIVEN_MSG_PAYLOAD.equals((Object)this.chartMode) || ChartMode.USER_DRIVEN_MSG_SIZE.equals((Object)this.chartMode)) {
            for (MessageLimitProperties limit : this.showRangeBox.getItems()) {
                if (limit.getMessageLimit() != lastMessageLimit.getMessageLimit() || limit.getTimeLimit() != lastMessageLimit.getTimeLimit()) continue;
                this.showRangeBox.setValue((Object)limit);
            }
            this.autoRefreshCheckBox.setSelected(lastAutoRefresh);
            this.displaySymbolsCheckBox.setSelected(lastDisplaySymbols);
        }
        this.eventBus.subscribeWithFilterOnly(this, this::onMessageAdded, MessageAddedEvent.class, this.store.getMessageList());
        this.setupPanAndZoom();
        this.eventBus.subscribe(this, this::onSeriesEdited, SaveChartSeriesEvent.class);
    }

    private void onSeriesEdited(SaveChartSeriesEvent event) {
        if (event.isNew()) {
            event.getEditedProperties().setId(this.lastSeriesId++);
            logger.debug("Adding new series = {}", (Object)event.getEditedProperties().getName());
            this.addNewSeries(event.getEditedProperties());
        }
        this.warningLogged = false;
        this.refresh();
    }

    private void setupPanAndZoom() {
        ChartPanManager panner = new ChartPanManager((XYChart<?, ?>)this.lineChart);
        panner.setMouseFilter((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (!(mouseEvent.getButton() == MouseButton.SECONDARY || mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.isShortcutDown())) {
                    mouseEvent.consume();
                }
            }
        });
        panner.start();
        JFXChartUtil.setupZooming(this.lineChart, (EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != MouseButton.PRIMARY || mouseEvent.isShortcutDown()) {
                    mouseEvent.consume();
                }
            }
        });
        this.lineChart.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    LineChartPaneController.this.reset();
                }
            }
        });
    }

    public void cleanup() {
        this.eventBus.unsubscribeConsumer((Object)this, MessageAddedEvent.class);
        this.exportInterval = null;
    }

    private void divideMessagesByTopic(Collection<String> topics) {
        this.chartData.clear();
        for (FormattedMessage message : this.store.getMessages()) {
            String topic = message.getTopic();
            if (!topics.contains(topic)) continue;
            this.createTopicIfDoesNotExist(topic);
            this.chartData.get(topic).add(message);
        }
    }

    private void createTopicIfDoesNotExist(String topic) {
        if (this.chartData.get(topic) == null) {
            this.chartData.put(topic, new ArrayList());
        }
    }

    @FXML
    private void reset() {
        this.lineChart.getXAxis().setAutoRanging(true);
        this.lineChart.getYAxis().setAutoRanging(true);
        ObservableList data = this.lineChart.getData();
        this.lineChart.setData(FXCollections.emptyObservableList());
        this.lineChart.setData(data);
        this.lineChart.setData(FXCollections.emptyObservableList());
        this.lineChart.setData(data);
        this.lineChart.setAnimated(true);
    }

    @FXML
    private void removeSeries() {
        ChartSeriesProperties itemToDelete = (ChartSeriesProperties)this.seriesTable.getSelectionModel().getSelectedItem();
        if (itemToDelete != null) {
            this.seriesTable.getItems().remove((Object)itemToDelete);
        }
    }

    @FXML
    private void duplicateSeries() {
        ChartSeriesProperties itemToCopy = (ChartSeriesProperties)this.seriesTable.getSelectionModel().getSelectedItem();
        if (itemToCopy != null) {
            ChartSeriesProperties duplicate = new ChartSeriesProperties(this.lastSeriesId++, itemToCopy.getName() + "_copy", itemToCopy.getTopic(), (ChartSeriesTypeEnum)((Object)itemToCopy.typeProperty().get()), itemToCopy.valueExpressionProperty().get());
            this.eventBus.publish(new SaveChartSeriesEvent(duplicate, true));
        }
    }

    @FXML
    private void addSeries() {
        this.eventBus.publish(new ShowEditChartSeriesWindowEvent(this.chartPane.getScene().getWindow(), null));
    }

    private XYChart.Data<Number, Number> createDataObject(ChartSeriesProperties seriesProperties, FormattedMessage message) throws XPathExpressionException, PathNotFoundException, IllegalArgumentException, IOException {
        if (ChartSeriesTypeEnum.PAYLOAD_PLAIN.equals(seriesProperties.typeProperty().get())) {
            Double value = Double.valueOf(message.getFormattedPayload());
            return new XYChart.Data((Object)message.getDate().getTime(), (Object)value);
        }
        if (ChartSeriesTypeEnum.PAYLOAD_JSON.equals(seriesProperties.typeProperty().get())) {
            String jsonValue = String.valueOf((char[])JsonPath.read(message.getFormattedPayload(), seriesProperties.valueExpressionProperty().get(), new Predicate[0]));
            Double value = Double.valueOf(jsonValue);
            return new XYChart.Data((Object)message.getDate().getTime(), (Object)value);
        }
        if (ChartSeriesTypeEnum.PAYLOAD_XML.equals(seriesProperties.typeProperty().get())) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression exp = xpath.compile(seriesProperties.valueExpressionProperty().get());
            double value = (Double)exp.evaluate(new InputSource(new StringReader(message.getFormattedPayload())), XPathConstants.NUMBER);
            logger.debug("XPath value = {}", (Object)value);
            return new XYChart.Data((Object)message.getDate().getTime(), (Object)value);
        }
        if (ChartSeriesTypeEnum.SIZE.equals(seriesProperties.typeProperty().get())) {
            Integer value = message.getPayload().length();
            return new XYChart.Data((Object)message.getDate().getTime(), (Object)value);
        }
        return null;
    }

    private void addMessageToSeries(ChartSeriesProperties seriesProperties, FormattedMessage message) {
        block3: {
            XYChart.Series<Number, Number> series = this.seriesIdToSeriesData.get(seriesProperties.getId());
            if (series != null) {
                try {
                    seriesProperties.setLastUpdated(new Date());
                    XYChart.Data<Number, Number> data = this.createDataObject(seriesProperties, message);
                    logger.debug("Series {}, data = {}", (Object)seriesProperties.getName(), (Object)data);
                    series.getData().add(data);
                    seriesProperties.setSeriesStatus(ChartSeriesStatusEnum.OK);
                }
                catch (Exception e) {
                    if (this.warningLogged || !ChartMode.USER_DRIVEN_MSG_PAYLOAD.equals((Object)this.chartMode)) break block3;
                    seriesProperties.setErrorMessage(e.toString());
                    seriesProperties.setSeriesStatus(ChartSeriesStatusEnum.ERROR);
                    logger.error("Invalid payload", e);
                    this.warningLogged = true;
                }
            }
        }
    }

    @FXML
    private void exportAsImage() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select PNG file to save as...");
        this.selectedImageFile = fileChooser.showSaveDialog(this.lineChart.getScene().getWindow());
        if (this.selectedImageFile != null) {
            this.exportAsImage(this.selectedImageFile);
        }
    }

    private void exportAsImage(File selectedFile) {
        WritableImage image = this.lineChart.snapshot(new SnapshotParameters(), null);
        try {
            if (this.addTimestampOnAutoExport) {
                String newName = selectedFile.getAbsolutePath().replace(selectedFile.getName(), TimeUtils.DATE_WITH_SECONDS_FILENAME_SDF.format(new Date()) + "_" + selectedFile.getName());
                File withTimestamp = new File(newName);
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", withTimestamp);
            } else {
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", selectedFile);
            }
            this.autoImageExport.setDisable(false);
        }
        catch (IOException e) {
            logger.error("Cannot export to file {}", (Object)selectedFile.getAbsoluteFile(), (Object)e);
            DialogFactory.createErrorDialog("Cannot export to file", "Chart cannot be exported to file: " + e.getLocalizedMessage());
        }
    }

    @FXML
    private void updateSaveOnMessage() {
        this.saveOnMessage = this.saveImageOnMessage.isSelected();
    }

    @FXML
    private void updateSaveOnInterval() {
        block6: {
            if (this.saveImageAtInterval.isSelected()) {
                TextInputDialog dialog = new TextInputDialog("60");
                dialog.setTitle("Export interval");
                dialog.setHeaderText(null);
                dialog.setContentText("Please enter export interval (in seconds):");
                Optional result = dialog.showAndWait();
                if (result.isPresent()) {
                    try {
                        this.exportInterval = Integer.valueOf((String)result.get());
                        if (this.exportInterval > 0) {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    while (LineChartPaneController.this.exportInterval != null && LineChartPaneController.this.exportInterval > 0) {
                                        Platform.runLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                LineChartPaneController.this.exportAsImage(LineChartPaneController.this.selectedImageFile);
                                            }
                                        });
                                        try {
                                            Thread.sleep(LineChartPaneController.this.exportInterval * 1000);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }).start();
                            break block6;
                        }
                        DialogFactory.createErrorDialog("Invalid number format", "The provided value is not a correct number (>0).");
                        this.exportInterval = null;
                    }
                    catch (NumberFormatException e) {
                        DialogFactory.createErrorDialog("Invalid number format", "The provided value is not a correct number (>0).");
                    }
                }
            } else {
                this.exportInterval = null;
            }
        }
    }

    @FXML
    private void addTimestampOnAutoExport() {
        this.addTimestampOnAutoExport = this.addTimestampOnExport.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    private void refresh() {
        Map<String, List<FormattedMessage>> map = this.chartData;
        synchronized (map) {
            this.topics.clear();
            this.topicToSeries.clear();
            for (ChartSeriesProperties seriesProperties : this.allSeries) {
                this.topics.add(seriesProperties.getTopic());
                this.populateTopicToSeries(seriesProperties);
            }
            this.divideMessagesByTopic(this.topics);
            this.lineChart.getData().clear();
            this.lineChart.setCreateSymbols(lastDisplaySymbols);
            this.seriesIdToSeriesData.clear();
            for (ChartSeriesProperties seriesProperties : this.allSeries) {
                if (!seriesProperties.visibleProperty().get()) continue;
                ArrayList<FormattedMessage> extractedMessages = new ArrayList<FormattedMessage>();
                XYChart.Series series = new XYChart.Series();
                this.seriesIdToSeriesData.put(seriesProperties.getId(), (XYChart.Series<Number, Number>)series);
                series.setName(seriesProperties.getName());
                MessageLimitProperties limit = (MessageLimitProperties)this.showRangeBox.getValue();
                List<FormattedMessage> messageList = this.chartData.get(seriesProperties.getTopic());
                int itemsAvailable = messageList == null ? 0 : messageList.size();
                int startIndex = 0;
                if (limit.getMessageLimit() > 0 && limit.getMessageLimit() < itemsAvailable) {
                    startIndex = itemsAvailable - limit.getMessageLimit();
                }
                Date now = new Date();
                for (int i = startIndex; i < itemsAvailable; ++i) {
                    FormattedMessage message = this.chartData.get(seriesProperties.getTopic()).get(this.chartData.get(seriesProperties.getTopic()).size() - i - 1);
                    if (limit.getTimeLimit() > 0L && message.getDate().getTime() + limit.getTimeLimit() < now.getTime()) continue;
                    extractedMessages.add(message);
                    this.addMessageToSeries(seriesProperties, message);
                }
                this.chartData.put(seriesProperties.getTopic(), extractedMessages);
                this.lineChart.getData().add((Object)series);
                this.populateTooltips(this.lineChart);
            }
        }
    }

    private void populateTooltip(XYChart.Series<Number, Number> series, XYChart.Data<Number, Number> data) {
        Date date = new Date();
        date.setTime(((Number)data.getXValue()).longValue());
        Tooltip tooltip = new Tooltip(this.seriesTypeName + " = " + series.getName() + System.lineSeparator() + this.seriesValueName + " = " + data.getYValue() + " " + this.seriesUnit + System.lineSeparator() + "Time = " + TimeUtils.TIME_SDF.format(date));
        Tooltip.install((Node)data.getNode(), (Tooltip)tooltip);
    }

    private void populateTooltips(LineChart<Number, Number> lineChart) {
        for (XYChart.Series series : lineChart.getData()) {
            for (XYChart.Data data : series.getData()) {
                this.populateTooltip((XYChart.Series<Number, Number>)series, (XYChart.Data<Number, Number>)data);
            }
        }
    }

    public void onMessageAdded(MessageAddedEvent<FormattedMessage> event) {
        for (BrowseReceivedMessageEvent<FormattedMessage> message : event.getMessages()) {
            this.onMessageAdded(message.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageAdded(FormattedMessage message) {
        Map<String, List<FormattedMessage>> map = this.chartData;
        synchronized (map) {
            String topic = message.getTopic();
            this.createTopicIfDoesNotExist(topic);
            List<ChartSeriesProperties> topicSeries = this.topicToSeries.get(topic);
            if (topicSeries != null) {
                for (ChartSeriesProperties properties : topicSeries) {
                    XYChart.Series<Number, Number> seriesData = this.seriesIdToSeriesData.get(properties.getId());
                    if (seriesData == null) continue;
                    this.updateSeries(topic, seriesData, message, properties);
                }
            }
        }
    }

    private void updateSeries(String topic, XYChart.Series<Number, Number> seriesData, FormattedMessage message, ChartSeriesProperties properties) {
        MessageLimitProperties limit = (MessageLimitProperties)this.showRangeBox.getValue();
        if (this.autoRefreshCheckBox.isSelected() && this.topics.contains(topic)) {
            while (limit.getMessageLimit() > 0 && this.chartData.get(topic).size() >= limit.getMessageLimit()) {
                this.chartData.get(topic).remove(0);
                if (seriesData.getData().size() <= 0) continue;
                seriesData.getData().remove(0);
            }
            Date now = new Date();
            if (limit.getTimeLimit() > 0L) {
                FormattedMessage oldestMessage = this.chartData.get(topic).get(0);
                while (oldestMessage.getDate().getTime() + limit.getTimeLimit() < now.getTime()) {
                    this.chartData.get(topic).remove(0);
                    seriesData.getData().remove(0);
                    if (this.chartData.get(topic).size() == 0) break;
                    oldestMessage = this.chartData.get(topic).get(0);
                }
            }
            this.chartData.get(topic).add(message);
            this.addMessageToSeries(properties, message);
            if (seriesData.getData().size() > 0) {
                this.populateTooltip(seriesData, (XYChart.Data<Number, Number>)((XYChart.Data)seriesData.getData().get(seriesData.getData().size() - 1)));
            }
            this.saveOnMessage();
        }
    }

    private void saveOnMessage() {
        if (this.saveOnMessage) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LineChartPaneController.this.exportAsImage(LineChartPaneController.this.selectedImageFile);
                        }
                    });
                }
            }).start();
        }
    }

    public void setChartMode(ChartMode mode) {
        this.chartMode = mode;
    }

    public void initialiseSeries(Collection<String> topics) {
        this.topics = topics;
        for (String topic : topics) {
            ChartSeriesProperties series = ChartMode.USER_DRIVEN_MSG_PAYLOAD.equals((Object)this.chartMode) ? new ChartSeriesProperties(this.lastSeriesId++, topic, topic, ChartSeriesTypeEnum.PAYLOAD_PLAIN, "") : new ChartSeriesProperties(this.lastSeriesId++, topic, topic, ChartSeriesTypeEnum.SIZE, "");
            this.addNewSeries(series);
        }
    }

    private void addNewSeries(ChartSeriesProperties series) {
        this.seriesTable.getItems().add((Object)series);
        this.allSeries.add(series);
        this.populateTopicToSeries(series);
    }

    private void populateTopicToSeries(ChartSeriesProperties series) {
        if (this.topicToSeries.get(series.getTopic()) == null) {
            this.topicToSeries.put(series.getTopic(), new ArrayList());
        }
        this.topicToSeries.get(series.getTopic()).add(series);
    }

    public void setStore(BasicMessageStoreWithSummary<T> store) {
        this.store = store;
    }

    public void setSeriesTypeName(String seriesTypeName) {
        this.seriesTypeName = seriesTypeName;
    }

    public void setSeriesUnit(String seriesUnit) {
        this.seriesUnit = seriesUnit;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

