/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.ui.controlpanel.ItemStatus;
import pl.baczkowicz.spy.ui.utils.ImageUtils;

public class ControlPanelItemController
extends AnchorPane
implements Initializable {
    static final Logger logger = LoggerFactory.getLogger(ControlPanelItemController.class);
    @FXML
    private ImageView statusIcon;
    @FXML
    private VBox itemsBox;
    @FXML
    private Label titleText;
    @FXML
    private Label detailsText;
    @FXML
    private Button smallButton1;
    @FXML
    private FlowPane details;
    @FXML
    private Button smallButton2;
    @FXML
    private ProgressIndicator progressIndicator;
    private ItemStatus status = ItemStatus.ERROR;
    private boolean showProgress;

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void init() {
    }

    public static void setButtonProperties(Button button, String imageName, boolean visibility, EventHandler<ActionEvent> action) {
        button.setVisible(true);
        button.setGraphic((Node)ImageUtils.createIcon(imageName));
        button.setOnAction(action);
    }

    public static void setButtonProperties(Button button, String imageLocation, boolean visibility) {
        button.setVisible(true);
        button.setGraphic((Node)new ImageView(new Image(ControlPanelItemController.class.getResource(imageLocation).toString())));
    }

    public Button getButton1() {
        return this.smallButton1;
    }

    public Button getButton2() {
        return this.smallButton2;
    }

    public static String getStatusIconName(ItemStatus status) {
        String imageLocation;
        switch (status) {
            case OK: {
                imageLocation = "dialog-ok-apply-large";
                break;
            }
            case INFO: {
                imageLocation = "dialog-information-large";
                break;
            }
            case WARN: {
                imageLocation = "dialog-warning-large";
                break;
            }
            case ERROR: {
                imageLocation = "dialog-error-large";
                break;
            }
            case STATS: {
                imageLocation = "rating-large";
                break;
            }
            default: {
                imageLocation = "dialog-error-large";
            }
        }
        return imageLocation;
    }

    public void refresh() {
        String imageName = ControlPanelItemController.getStatusIconName(this.status);
        if (this.showProgress) {
            this.progressIndicator.setVisible(true);
            this.statusIcon.setVisible(false);
        } else {
            this.progressIndicator.setVisible(false);
            this.statusIcon.setVisible(true);
            this.statusIcon.setImage(ImageUtils.createIcon(imageName).getImage());
            if (this.status == ItemStatus.OK) {
                this.statusIcon.setLayoutY(5.0);
                this.statusIcon.setLayoutX(5.0);
                this.statusIcon.setFitHeight(64.0);
                this.statusIcon.setFitWidth(64.0);
            } else {
                this.statusIcon.setLayoutY(10.0);
                this.statusIcon.setLayoutX(10.0);
                this.statusIcon.setFitHeight(64.0);
                this.statusIcon.setFitWidth(64.0);
            }
        }
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public void setValues(ItemStatus status, String title, String details) {
        this.status = status;
        this.titleText.setText(title);
        this.detailsText.setText(details);
    }

    public void setStatus(ItemStatus status) {
        this.status = status;
    }

    public void setTitle(String title) {
        this.titleText.setText(title);
    }

    public void setDetails(String details) {
        this.detailsText.setText(details);
    }

    public VBox getCustomItems() {
        return this.itemsBox;
    }

    public FlowPane getDetails() {
        return this.details;
    }
}

