/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.layout.AnchorPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.controllers.ControlPanelItemController;
import pl.baczkowicz.spy.ui.controlpanel.IControlPanelItem;
import pl.baczkowicz.spy.ui.controlpanel.ItemStatus;
import pl.baczkowicz.spy.ui.events.ConfigurationLoadedEvent;
import pl.baczkowicz.spy.ui.events.ConnectionStatusChangeEvent;
import pl.baczkowicz.spy.ui.events.ConnectionsChangedEvent;
import pl.baczkowicz.spy.ui.events.ShowExternalWebPageEvent;
import pl.baczkowicz.spy.ui.events.VersionInfoErrorEvent;
import pl.baczkowicz.spy.ui.events.VersionInfoReceivedEvent;
import pl.baczkowicz.spy.ui.generated.versions.SpyVersions;
import pl.baczkowicz.spy.ui.properties.VersionInfoProperties;
import pl.baczkowicz.spy.ui.threading.SimpleRunLaterExecutor;
import pl.baczkowicz.spy.ui.versions.VersionManager;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class ControlPanelController
extends AnchorPane
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(ControlPanelController.class);
    @FXML
    private ControlPanelItemController controlPanelItem1Controller;
    @FXML
    private ControlPanelItemController controlPanelItem2Controller;
    @FXML
    private ControlPanelItemController controlPanelItem3Controller;
    @FXML
    private ControlPanelItemController controlPanelItem4Controller;
    @FXML
    private Button button1;
    @FXML
    private Button button2;
    @FXML
    private Button button3;
    @FXML
    private Button button4;
    private VersionManager versionManager;
    private IConfigurationManager configurationManager;
    private IKBus eventBus;
    public static Map<ConnectionStatus, String> nextActionTitle = new HashMap<ConnectionStatus, String>();
    private IControlPanelItem userAndConfigItem;
    private IControlPanelItem connectionsItem;
    private IControlPanelItem statsItem;

    public void initialize(URL location, ResourceBundle resources) {
        nextActionTitle.put(ConnectionStatus.NOT_CONNECTED, "Connect to");
        nextActionTitle.put(ConnectionStatus.CONNECTING, "Connecting to");
        nextActionTitle.put(ConnectionStatus.CONNECTED, "Disconnect from");
        nextActionTitle.put(ConnectionStatus.DISCONNECTED, "Connect to");
        nextActionTitle.put(ConnectionStatus.DISCONNECTING, "Disconnecting from");
    }

    public void init() {
        this.eventBus.subscribe((Object)this, this::onVersionInfoReceived, VersionInfoReceivedEvent.class, new SimpleRunLaterExecutor());
        this.eventBus.subscribe((Object)this, this::onVersionInfoError, VersionInfoErrorEvent.class, new SimpleRunLaterExecutor());
        this.eventBus.subscribe((Object)this, this::onConnectionStatusChanged, ConnectionStatusChangeEvent.class, new SimpleRunLaterExecutor());
        this.eventBus.subscribe((Object)this, this::onConnectionsChanged, ConnectionsChangedEvent.class);
        this.eventBus.subscribe((Object)this, this::onConfigurationFileStatusChange, ConfigurationLoadedEvent.class);
        this.userAndConfigItem.update(this.controlPanelItem1Controller, this.button1);
        this.connectionsItem.update(this.controlPanelItem2Controller, this.button2);
        this.checkForUpdates(this.controlPanelItem3Controller, this.button3);
        this.statsItem.update(this.controlPanelItem4Controller, this.button4);
    }

    public void onConnectionStatusChanged(ConnectionStatusChangeEvent event) {
        this.refreshConnectionsStatus();
    }

    public void onConnectionsChanged(ConnectionsChangedEvent event) {
        this.refreshConnectionsStatus();
    }

    public void refreshConnectionsStatus() {
        logger.trace("Refreshing connection status...");
        this.connectionsItem.update(this.controlPanelItem2Controller, this.button2);
    }

    public void onConfigurationFileStatusChange(ConfigurationLoadedEvent event) {
        this.userAndConfigItem.update(this.controlPanelItem1Controller, this.button1);
    }

    public void checkForUpdates(ControlPanelItemController controller, Button button) {
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ControlPanelController.this.eventBus.publish(new ShowExternalWebPageEvent(ControlPanelController.this.configurationManager.getDefaultPropertyFile().getProperty("application.download.url")));
            }
        });
        controller.setStatus(ItemStatus.INFO);
        controller.setTitle("Connecting to the " + this.configurationManager.getDefaultPropertyFile().getApplicationName() + " update server...");
        controller.setShowProgress(true);
        controller.setDetails("Please wait while " + this.configurationManager.getDefaultPropertyFile().getApplicationName() + " retrieves information about available updates.");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ControlPanelController.this.versionManager.setLoading(true);
                    ThreadingUtils.sleep(5000L);
                    SpyVersions versions = ControlPanelController.this.versionManager.loadVersions();
                    logger.debug("Retrieved version info = " + versions.toString());
                    ControlPanelController.this.eventBus.publish(new VersionInfoReceivedEvent(versions));
                }
                catch (XMLException e) {
                    ControlPanelController.this.eventBus.publish(new VersionInfoErrorEvent(e));
                }
            }
        }).start();
        controller.refresh();
    }

    public void showUpdateInfo(ControlPanelItemController controller, Button button) {
        controller.setShowProgress(false);
        VersionInfoProperties properties = this.versionManager.getVersionInfoProperties(this.configurationManager.getDefaultPropertyFile());
        controller.setStatus(properties.getStatus());
        controller.setTitle(properties.getTitle());
        controller.setDetails(properties.getDetails());
        controller.refresh();
    }

    public void setConfigurationMananger(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void onVersionInfoReceived(VersionInfoReceivedEvent event) {
        this.showUpdateInfo(this.controlPanelItem3Controller, this.button3);
    }

    public void onVersionInfoError(VersionInfoErrorEvent event) {
        this.controlPanelItem3Controller.setStatus(ItemStatus.ERROR);
        this.controlPanelItem3Controller.setShowProgress(false);
        this.controlPanelItem3Controller.setTitle("Error occurred while getting version info. Please perform manual update.");
        logger.error("Cannot retrieve version info", event.getException());
        this.controlPanelItem3Controller.refresh();
    }

    public void setVersionManager(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setUserAndConfigItem(IControlPanelItem userAndConfigItem) {
        this.userAndConfigItem = userAndConfigItem;
    }

    public void setConnectionsItem(IControlPanelItem connectionsItem) {
        this.connectionsItem = connectionsItem;
    }

    public void setStatsItem(IControlPanelItem statsItem) {
        this.statsItem = statsItem;
    }
}

