/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.configuration;

import java.util.ArrayList;
import java.util.List;
import pl.baczkowicz.spy.common.generated.ConnectionGroup;
import pl.baczkowicz.spy.common.generated.ConnectionGroupReference;
import pl.baczkowicz.spy.common.generated.ConnectionReference;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;

public class ConfiguredConnectionGroupDetails
extends ConnectionGroup
implements ModifiableConnection {
    private static final long serialVersionUID = 7400105091442371397L;
    private boolean modified;
    private boolean newGroup;
    private ConfiguredConnectionGroupDetails lastSavedValues;
    private ConnectionGroupReference group;
    private boolean groupingModified;

    public ConfiguredConnectionGroupDetails(String id, String name, ConnectionGroupReference group, List<ConnectionGroupReference> subgroups, List<ConnectionReference> connections) {
        this.id = id;
        this.name = name;
        this.subgroups = subgroups;
        this.connections = connections;
        this.group = group;
    }

    public ConfiguredConnectionGroupDetails(ConnectionGroup group, boolean newConnection) {
        this.modified = newConnection;
        this.newGroup = newConnection;
        ConfiguredConnectionGroupDetails groupDetails = new ConfiguredConnectionGroupDetails(group.getID(), group.getName(), null, group.getSubgroups(), group.getConnections());
        this.setGroupDetails(groupDetails);
        this.setLastSavedValues(groupDetails);
    }

    private void setGroupDetails(ConfiguredConnectionGroupDetails groupDetails) {
        ConnectionGroup group = groupDetails.getGroup() != null ? (ConnectionGroup)groupDetails.getGroup().getReference() : null;
        groupDetails.setGroup(null);
        ArrayList<ConnectionReference> connections = new ArrayList<ConnectionReference>(groupDetails.getConnections());
        groupDetails.getConnections().clear();
        ArrayList<ConnectionGroupReference> subgroups = new ArrayList<ConnectionGroupReference>(groupDetails.getSubgroups());
        groupDetails.getSubgroups().clear();
        if (groupDetails != null) {
            groupDetails.copyTo(this);
        }
        groupDetails.setGroup(new ConnectionGroupReference(group));
        this.setGroup(new ConnectionGroupReference(group));
        groupDetails.getConnections().addAll(connections);
        this.getConnections().addAll(connections);
        groupDetails.getSubgroups().addAll(subgroups);
        this.getSubgroups().addAll(subgroups);
    }

    public String getFullName() {
        String fullName = this.getName();
        ConfiguredConnectionGroupDetails parentGroup = ConfiguredConnectionGroupDetails.getGroup(this.getGroup());
        while (parentGroup != null && ConfiguredConnectionGroupDetails.getGroup(parentGroup.getGroup()) != null) {
            fullName = parentGroup.getName() + " / " + fullName;
            parentGroup = ConfiguredConnectionGroupDetails.getGroup(parentGroup.getGroup());
        }
        return fullName;
    }

    public static ConfiguredConnectionGroupDetails getGroup(ConnectionGroupReference group) {
        if (group == null) {
            return null;
        }
        return (ConfiguredConnectionGroupDetails)group.getReference();
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public ConnectionGroup getLastSavedValues() {
        return this.lastSavedValues;
    }

    private void setLastSavedValues(ConfiguredConnectionGroupDetails lastSavedValues) {
        this.lastSavedValues = lastSavedValues;
    }

    public void undo() {
        this.setID(this.lastSavedValues.getID());
        this.setName(this.lastSavedValues.getName());
        this.modified = this.newGroup;
    }

    @Override
    public void undoAll() {
        this.undo();
        this.setGroup(this.lastSavedValues.getGroup());
        this.getConnections().clear();
        this.getConnections().addAll(this.lastSavedValues.getConnections());
        this.getSubgroups().clear();
        this.getSubgroups().addAll(this.lastSavedValues.getSubgroups());
        this.groupingModified = false;
    }

    @Override
    public void apply() {
        ConfiguredConnectionGroupDetails valuesToSave = new ConfiguredConnectionGroupDetails(this.getID(), this.getName(), this.getGroup(), new ArrayList<ConnectionGroupReference>(this.getSubgroups()), new ArrayList<ConnectionReference>(this.getConnections()));
        this.setLastSavedValues(valuesToSave);
        this.modified = false;
        this.newGroup = false;
        this.groupingModified = false;
    }

    @Override
    public boolean isNew() {
        return this.newGroup;
    }

    @Override
    public void removeFromGroup() {
        ConfiguredConnectionGroupDetails.removeFromGroup(this, (ConnectionGroup)this.getGroup().getReference());
    }

    public static void removeFromGroup(ConnectionGroup groupToRemove, ConnectionGroup groupToRemoveFrom) {
        ConnectionGroupReference refToDelete = null;
        List<ConnectionGroupReference> subgroups = groupToRemoveFrom.getSubgroups();
        for (ConnectionGroupReference subgroupRef : subgroups) {
            if (!subgroupRef.getReference().equals(groupToRemove)) continue;
            refToDelete = subgroupRef;
            break;
        }
        subgroups.remove(refToDelete);
    }

    @Override
    public void setGroupingModified(boolean modified) {
        this.groupingModified = modified;
    }

    @Override
    public boolean isGroupingModified() {
        return this.groupingModified;
    }

    @Override
    public ConnectionGroupReference getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(ConnectionGroupReference group) {
        this.group = group;
    }

    public static void removeFromGroup(Object connectionToRemove, ConnectionGroup groupToRemoveFrom) {
        ConnectionReference refToDelete = null;
        List<ConnectionReference> connections = groupToRemoveFrom.getConnections();
        for (ConnectionReference connectionRef : connections) {
            if (!connectionRef.getReference().equals(connectionToRemove)) continue;
            refToDelete = connectionRef;
            break;
        }
        connections.remove(refToDelete);
    }

    @Override
    public void setDeleted(boolean value) {
    }

    @Override
    public boolean isBeingCreated() {
        return false;
    }
}

