/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.charts;

import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.charts.ChartMode;
import pl.baczkowicz.spy.ui.controllers.LineChartPaneController;
import pl.baczkowicz.spy.ui.controllers.PieChartPaneController;
import pl.baczkowicz.spy.ui.properties.SubscriptionTopicSummaryProperties;
import pl.baczkowicz.spy.ui.storage.BasicMessageStoreWithSummary;
import pl.baczkowicz.spy.ui.utils.FxmlUtils;

public class ChartFactory<T extends FormattedMessage> {
    public void createMessageBasedLineChart(Collection<String> topics, BasicMessageStoreWithSummary<T> store, ChartMode mode, String seriesType, String seriesValueName, String seriesUnit, String title, Scene parentScene, IKBus eventBus) {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("LineChartPane.fxml");
        AnchorPane statsWindow = FxmlUtils.loadAnchorPane(loader);
        final LineChartPaneController statsPaneController = (LineChartPaneController)loader.getController();
        statsPaneController.setEventBus(eventBus);
        statsPaneController.setStore(store);
        statsPaneController.setSeriesTypeName(seriesType);
        statsPaneController.setChartMode(mode);
        statsPaneController.initialiseSeries(new ArrayList<String>(topics));
        statsPaneController.setSeriesValueName(seriesValueName);
        statsPaneController.setSeriesUnit(seriesUnit);
        statsPaneController.init();
        Scene scene = new Scene((Parent)statsWindow);
        scene.getStylesheets().addAll((Collection)parentScene.getStylesheets());
        Stage statsPaneStage = new Stage();
        statsPaneStage.setWidth(800.0);
        statsPaneStage.setHeight(600.0);
        statsPaneStage.setScene(scene);
        statsPaneStage.setTitle(title);
        statsPaneStage.show();
        statsPaneStage.setHeight(610.0);
        statsPaneStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                statsPaneController.cleanup();
            }
        });
    }

    public void createMessageBasedPieChart(String title, Scene parentScene, ObservableList<SubscriptionTopicSummaryProperties<T>> observableList) {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("PieChartPane.fxml");
        AnchorPane chartWindow = FxmlUtils.loadAnchorPane(loader);
        final PieChartPaneController chartPaneController = (PieChartPaneController)loader.getController();
        chartPaneController.setObservableList(observableList);
        chartPaneController.init();
        Scene scene = new Scene((Parent)chartWindow);
        scene.getStylesheets().addAll((Collection)parentScene.getStylesheets());
        Stage statsPaneStage = new Stage();
        statsPaneStage.setWidth(800.0);
        statsPaneStage.setHeight(600.0);
        statsPaneStage.setScene(scene);
        statsPaneStage.setTitle(title);
        statsPaneStage.show();
        statsPaneStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                chartPaneController.cleanup();
            }
        });
    }
}

