/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.testcases;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.ScriptDetails;
import pl.baczkowicz.spy.files.FileUtils;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;
import pl.baczkowicz.spy.scripts.ScriptRunningState;
import pl.baczkowicz.spy.testcases.TestCase;
import pl.baczkowicz.spy.testcases.TestCaseInfo;
import pl.baczkowicz.spy.testcases.TestCaseOptions;
import pl.baczkowicz.spy.testcases.TestCaseResult;
import pl.baczkowicz.spy.testcases.TestCaseStatus;
import pl.baczkowicz.spy.testcases.TestCaseStep;
import pl.baczkowicz.spy.testcases.TestCaseStepResult;
import pl.baczkowicz.spy.utils.ThreadingUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public class TestCaseManager {
    public static String GET_INFO_METHOD = "getInfo";
    public static SimpleDateFormat testCaseFileSdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
    public static SimpleDateFormat testCasesFileSdf = new SimpleDateFormat("yyyyMMdd");
    private static final Logger logger = LoggerFactory.getLogger(TestCaseManager.class);
    protected final BaseScriptManagerInterface scriptManager;
    protected Map<String, TestCase> testCases = new HashMap<String, TestCase>();
    protected int running = 0;
    private TestCaseOptions options = new TestCaseOptions();

    public TestCaseManager(BaseScriptManagerInterface scriptManager) {
        this.scriptManager = scriptManager;
    }

    public TestCase addTestCase(File scriptFile) {
        if (!scriptFile.exists()) {
            logger.error("Script file " + scriptFile.getPath() + " does not exist");
            return null;
        }
        logger.info("Adding " + scriptFile.getName() + " with parent " + scriptFile.getParent());
        ScriptDetails scriptDetails = new ScriptDetails();
        scriptDetails.setFile(scriptFile.getAbsolutePath());
        scriptDetails.setRepeat(false);
        TestCase testCase = new TestCase();
        this.scriptManager.createFileBasedScript(testCase, scriptFile, scriptDetails);
        try {
            this.scriptManager.runScript(testCase, false);
            testCase.setInfo((TestCaseInfo)this.scriptManager.invokeFunction(testCase, GET_INFO_METHOD, new Object[0]));
            int stepNumber = 1;
            for (String step : testCase.getInfo().getSteps()) {
                testCase.getSteps().add(new TestCaseStep(String.valueOf(stepNumber), step, TestCaseStatus.NOT_RUN, ""));
                ++stepNumber;
            }
            logger.info(testCase.getInfo().getName() + " " + Arrays.asList(testCase.getInfo().getSteps()));
        }
        catch (NoSuchMethodException | ScriptException e) {
            logger.error("Cannot read test case", e);
        }
        if (testCase.getInfo() != null && testCase.getInfo().getName() != null) {
            testCase.setName(testCase.getInfo().getName());
        } else {
            testCase.setName(scriptFile.getParentFile().getName());
        }
        this.testCases.put(testCase.getScriptId(), testCase);
        return testCase;
    }

    public void loadTestCases(String testCaseLocation) {
        List<File> scripts = FileUtils.getDirectoriesWithFile(testCaseLocation, "tc.*.js");
        for (File scriptFile : scripts) {
            this.addTestCase(scriptFile);
        }
    }

    private TestCaseStepResult runTestCaseSteps(TestCase testCase) {
        TestCaseStepResult lastResult = null;
        while (testCase.getCurrentStep() < testCase.getSteps().size() && testCase.getStatus().equals((Object)ScriptRunningState.RUNNING)) {
            TestCaseStep step = testCase.getSteps().get(testCase.getCurrentStep());
            testCase.setLastUpdated(TimeUtils.DATE_WITH_SECONDS_SDF.format(new Date()));
            step.setStatus(TestCaseStatus.IN_PROGRESS);
            try {
                TestCaseStepResult result;
                lastResult = result = (TestCaseStepResult)this.scriptManager.invokeFunction(testCase, "step" + step.getStepNumber(), new Object[0]);
                if (result == null) continue;
                step.setStatus(result.getStatus());
                step.setExecutionInfo(result.getInfo());
                if (TestCaseStatus.IN_PROGRESS.equals((Object)result.getStatus())) {
                    testCase.getTestCaseResult().getStepResults().add(new TestCaseStep(step));
                    try {
                        Thread.sleep(this.options.getStepInterval());
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                testCase.getTestCaseResult().getStepResults().add(step);
                testCase.setCurrentStep(testCase.getCurrentStep() + 1);
            }
            catch (NoSuchMethodException e) {
                step.setStatus(TestCaseStatus.ERROR);
                logger.error("Step execution error for step " + step.getStepNumber(), e);
            }
            catch (ScriptException e) {
                step.setStatus(TestCaseStatus.FAILED);
                logger.error("Step execution failure for step " + step.getStepNumber(), e);
            }
        }
        return lastResult;
    }

    public void runAllTestCaseMethods(TestCase testCase) {
        ++this.running;
        testCase.setCurrentStep(0);
        if (!this.scriptManager.invokeBefore(testCase)) {
            testCase.setStatusAndNotify(ScriptRunningState.FAILED);
        }
        TestCaseStepResult lastResult = this.runTestCaseSteps(testCase);
        if (!this.scriptManager.invokeAfter(testCase)) {
            testCase.setStatusAndNotify(ScriptRunningState.FAILED);
        }
        TestCaseStepResult testCaseStatus = lastResult;
        if (testCase.getStatus().equals((Object)ScriptRunningState.STOPPED)) {
            testCase.setTestCaseStatus(TestCaseStatus.SKIPPED);
        } else {
            testCase.setTestCaseStatus(testCaseStatus.getStatus());
            testCase.setStatusAndNotify(ScriptRunningState.FINISHED);
        }
        testCase.getTestCaseResult().setInfo(testCase.getInfo());
        testCase.getTestCaseResult().setResult(testCase.getTestCaseStatus());
        testCase.setLastUpdated(TimeUtils.DATE_WITH_SECONDS_SDF.format(new Date()));
        --this.running;
        logger.info("Test case \"{}\" ended with result: {}", (Object)testCase.getName(), (Object)testCaseStatus.getStatus());
        if (this.options.isAutoExport()) {
            String parentDir = testCase.getScriptFile().getParent() + System.getProperty("file.separator");
            this.exportTestCaseResultAsCSV(testCase, new File(parentDir + "result_" + testCaseFileSdf.format(new Date()) + "_" + (Object)((Object)testCaseStatus.getStatus()) + ".csv"));
        }
    }

    public void runTestCase(TestCase testCase, Map<String, Object> args) {
        testCase.setStatusAndNotify(ScriptRunningState.RUNNING);
        testCase.setTestCaseStatus(TestCaseStatus.IN_PROGRESS);
        if (args != null) {
            this.scriptManager.setVariable(testCase, "args", args);
        }
        for (TestCaseStep step : testCase.getSteps()) {
            step.setStatus(TestCaseStatus.NOT_RUN);
            step.setExecutionInfo("");
        }
        this.runAllTestCaseMethods(testCase);
    }

    public TestCaseResult addAndRunTestCase(String testCaseLocation, Map<String, Object> args) {
        TestCase testCase = this.addTestCase(new File(testCaseLocation));
        this.runTestCase(testCase, args);
        return testCase.getTestCaseResult();
    }

    public void runAllTestCases() {
        this.running = this.testCases.size();
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadingUtils.logThreadStarting("runAllTestCases");
                for (TestCase testCase : TestCaseManager.this.testCases.values()) {
                    TestCaseManager.this.runTestCase(testCase, null);
                    --TestCaseManager.this.running;
                }
                ThreadingUtils.logThreadEnding();
            }
        }).start();
    }

    public void stopTestCase(TestCase testCase) {
        testCase.setStatusAndNotify(ScriptRunningState.STOPPED);
        TestCaseStep step = testCase.getSteps().get(testCase.getCurrentStep());
        step.setStatus(TestCaseStatus.SKIPPED);
    }

    public int getTotalCount() {
        return this.testCases.size();
    }

    public Collection<TestCase> getTestCases() {
        return this.testCases.values();
    }

    public void exportTestCaseResultAsCSV(TestCase testCase, File selectedFile) {
        logger.info("Saving test case results to " + selectedFile.getAbsolutePath());
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(selectedFile));
            out.write("Step, \"Description\", Status, \"Info\"");
            out.newLine();
            for (TestCaseStep step : testCase.getSteps()) {
                out.write(step.getStepNumber() + ", \"" + step.getDescription() + "\", " + (Object)((Object)step.getStatus()) + ", \"" + step.getExecutionInfo() + "\"");
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            logger.error("Cannot write to file", e);
        }
    }

    public void exportTestCasesResultsAsCSV(File selectedFile) {
        logger.info("Saving test cases results to " + selectedFile.getAbsolutePath());
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(selectedFile));
            out.write("\"Test case\", \"Last updated\", \"Status");
            out.newLine();
            for (TestCase testCase : this.getTestCases()) {
                out.write("\"" + testCase.getName() + "\", \"" + testCase.getLastUpdated() + "\", \"" + (Object)((Object)testCase.getTestCaseStatus()) + "\"");
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            logger.error("Cannot write to file", e);
        }
    }

    public boolean areTestCasesStillRunning() {
        return this.running > 0;
    }

    public void setOptions(TestCaseOptions options) {
        this.options = options;
    }

    public TestCaseOptions getOptions() {
        return this.options;
    }
}

