/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.security;

import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.KeyStoreTypeEnum;
import pl.baczkowicz.spy.files.FileUtils;

public class SecureSocketUtils {
    private static final Logger logger = LoggerFactory.getLogger(SecureSocketUtils.class);
    private static final String ALGORITHM = "RSA";

    public static byte[] loadPemFileAsBytes(String file) throws IOException {
        PemReader pemReader = new PemReader(new FileReader(file));
        PemObject pemObject = pemReader.readPemObject();
        byte[] content = pemObject.getContent();
        logger.debug("Reading PEM file {}, type = {}", (Object)file, (Object)pemObject.getType());
        pemReader.close();
        return content;
    }

    public static byte[] loadBinaryFileAsBytes(String file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        byte[] data = new byte[inputStream.available()];
        inputStream.read(data);
        inputStream.close();
        return data;
    }

    public static PrivateKey loadPrivateKeyFromPemFile(String keyFile) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(SecureSocketUtils.loadPemFileAsBytes(keyFile));
        PrivateKey privateKey = KeyFactory.getInstance(ALGORITHM).generatePrivate(privateKeySpec);
        return privateKey;
    }

    public static PrivateKey loadPrivateKeyFromBinaryFile(String keyFile) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(SecureSocketUtils.loadBinaryFileAsBytes(keyFile));
        PrivateKey privateKey = KeyFactory.getInstance(ALGORITHM).generatePrivate(privateKeySpec);
        return privateKey;
    }

    public static X509Certificate loadX509Certificate(String certificateFile) throws IOException, CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        InputStream inputStream = FileUtils.loadFileByName(certificateFile);
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(inputStream);
        inputStream.close();
        return certificate;
    }

    public static TrustManagerFactory getTrustManagerFactory(String caCertificateFile) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        X509Certificate caCertificate = SecureSocketUtils.loadX509Certificate(caCertificateFile);
        KeyStore keyStore = SecureSocketUtils.getKeyStoreInstance(KeyStoreTypeEnum.DEFAULT);
        keyStore.load(null, null);
        keyStore.setCertificateEntry("ca-certificate", caCertificate);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        return tmf;
    }

    public static TrustManagerFactory getTrustManagerFactory(String keyStoreFile, String keyStorePassword, KeyStoreTypeEnum keyStoreType) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = SecureSocketUtils.loadKeystore(keyStoreFile, keyStorePassword, keyStoreType);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        return tmf;
    }

    public static KeyManagerFactory getKeyManagerFactory(String keyStoreFile, String keyStorePassword, String keyPassword, KeyStoreTypeEnum keyStoreType) throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, UnrecoverableKeyException, InvalidKeySpecException {
        KeyStore keyStore = SecureSocketUtils.loadKeystore(keyStoreFile, keyStorePassword, keyStoreType);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, keyPassword.toCharArray());
        return kmf;
    }

    public static KeyManagerFactory getKeyManagerFactory(String clientCertificateFile, String clientKeyFile, String clientKeyPassword, boolean pemFormat) throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, UnrecoverableKeyException, InvalidKeySpecException {
        X509Certificate clientCertificate = SecureSocketUtils.loadX509Certificate(clientCertificateFile);
        PrivateKey privateKey = pemFormat ? SecureSocketUtils.loadPrivateKeyFromPemFile(clientKeyFile) : SecureSocketUtils.loadPrivateKeyFromBinaryFile(clientKeyFile);
        KeyStore keyStore = SecureSocketUtils.getKeyStoreInstance(KeyStoreTypeEnum.DEFAULT);
        keyStore.load(null, null);
        keyStore.setCertificateEntry("certificate", clientCertificate);
        keyStore.setKeyEntry("private-key", privateKey, clientKeyPassword.toCharArray(), new Certificate[]{clientCertificate});
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, clientKeyPassword.toCharArray());
        return kmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeystore(String keyStoreFile, String keyStorePassword, KeyStoreTypeEnum keyStoreType) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore;
        try (FileInputStream inputStream = new FileInputStream(keyStoreFile);){
            keyStore = SecureSocketUtils.getKeyStoreInstance(keyStoreType);
            keyStore.load(inputStream, keyStorePassword.toCharArray());
        }
        return keyStore;
    }

    public static KeyStore getKeyStoreInstance(KeyStoreTypeEnum type) throws KeyStoreException {
        if (type == null || KeyStoreTypeEnum.DEFAULT.equals((Object)type)) {
            return KeyStore.getInstance(KeyStore.getDefaultType());
        }
        return KeyStore.getInstance(type.value());
    }

    public static KeyStore getKeyStoreInstance(KeyStoreTypeEnum type, Provider provider) throws KeyStoreException {
        if (type == null || KeyStoreTypeEnum.DEFAULT.equals((Object)type)) {
            return KeyStore.getInstance(KeyStore.getDefaultType());
        }
        return KeyStore.getInstance(type.value(), provider);
    }

    public static KeyStoreTypeEnum getTypeFromFilename(String filename) {
        if (filename == null || filename.isEmpty()) {
            return KeyStoreTypeEnum.DEFAULT;
        }
        if (filename.toLowerCase().endsWith("jks")) {
            return KeyStoreTypeEnum.JKS;
        }
        if (filename.toLowerCase().endsWith("jceks")) {
            return KeyStoreTypeEnum.JCEKS;
        }
        if (filename.toLowerCase().endsWith("p12")) {
            return KeyStoreTypeEnum.PKCS_12;
        }
        if (filename.toLowerCase().endsWith("pfx")) {
            return KeyStoreTypeEnum.PKCS_12;
        }
        if (filename.toLowerCase().endsWith("bks")) {
            return KeyStoreTypeEnum.BKS;
        }
        return KeyStoreTypeEnum.DEFAULT;
    }
}

