/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.scripts;

import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.scripts.ScriptRunner;
import pl.baczkowicz.spy.scripts.ScriptRunningState;
import pl.baczkowicz.spy.utils.ThreadingUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public class ScriptHealthDetector
implements Runnable {
    public static final int DEFAULT_THREAD_TIMEOUT = 5000;
    private static final Logger logger = LoggerFactory.getLogger(ScriptHealthDetector.class);
    private final Script script;
    private IKBus eventBus;
    private Executor executor;

    public ScriptHealthDetector(IKBus eventBus, Script script, Executor executor) {
        this.script = script;
        this.eventBus = eventBus;
        this.executor = executor;
    }

    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("Script Health Detector");
        while (this.script.getStatus().equals((Object)ScriptRunningState.RUNNING)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Checking script {} for responsiveness, last touch = {}, timeout = {}, current time = {}", this.script.getName(), this.script.getLastTouch(), this.script.getScriptTimeout(), TimeUtils.getMonotonicTime());
            }
            if (this.script.getLastTouch() + this.script.getScriptTimeout() < TimeUtils.getMonotonicTime()) {
                logger.warn("Script {} detected as frozen, last touch = {}, current time = {}", this.script.getName(), this.script.getLastTouch(), TimeUtils.getMonotonicTime());
                ScriptRunner.changeState(this.eventBus, this.script.getName(), ScriptRunningState.FROZEN, this.script, this.executor);
            }
            if (!ThreadingUtils.sleep(1000L)) continue;
        }
        ThreadingUtils.logThreadEnding();
    }
}

