/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.scripts;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.ScriptDetails;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.CriticalException;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.files.FileUtils;
import pl.baczkowicz.spy.messages.IBaseMessage;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.scripts.ScriptRunningState;

public abstract class BaseScriptManager
implements BaseScriptManagerInterface {
    public static final String RECEIVED_MESSAGE_PARAMETER = "receivedMessage";
    public static final String MESSAGE_PARAMETER = "message";
    public static final String SCRIPT_EXTENSION = ".js";
    public static final String BEFORE_METHOD = "before";
    public static final String AFTER_METHOD = "after";
    public static final String ON_MESSAGE_METHOD = "onMessage";
    private static final Logger logger = LoggerFactory.getLogger(BaseScriptManager.class);
    private Map<String, Script> scripts = new HashMap<String, Script>();
    protected IKBus eventBus;
    protected Executor executor;
    private Map<String, Object> customParameters;

    public BaseScriptManager(IKBus eventBus, Executor executor) {
        this.eventBus = eventBus;
        this.executor = executor;
    }

    public static String getScriptName(File file) {
        return file.getName().replace(SCRIPT_EXTENSION, "");
    }

    public static String getScriptNameWithSubdirectory(File file, String rootDirectory) {
        String filePathSeparator = System.getProperty("file.separator");
        String valueToReplace = rootDirectory.endsWith(filePathSeparator) ? rootDirectory : rootDirectory + filePathSeparator;
        return file.getAbsolutePath().replace(valueToReplace, "").replace(file.getName(), BaseScriptManager.getScriptName(file));
    }

    @Override
    public Script addScript(ScriptDetails scriptDetails) {
        File scriptFile = new File(scriptDetails.getFile());
        Script script = new Script();
        this.createFileBasedScript(script, scriptFile, scriptDetails);
        logger.info("Adding script {} at {}", (Object)script.getName(), (Object)scriptFile.getAbsolutePath());
        this.scripts.put(scriptFile.getAbsolutePath(), script);
        return script;
    }

    @Override
    public Script addScript(String scriptLocation) {
        return this.addScript(new ScriptDetails(false, false, scriptLocation));
    }

    @Override
    public Script addInlineScript(String scriptName, String content) {
        Script script = new Script();
        script.setScriptContent(content);
        script.setScriptDetails(new ScriptDetails(true, false, null));
        this.createScript(script, scriptName);
        logger.debug("Adding in-line script {}", (Object)scriptName);
        this.scripts.put(scriptName, script);
        return script;
    }

    @Override
    public List<Script> addScripts(List<ScriptDetails> scriptDetails) {
        ArrayList<Script> addedScripts = new ArrayList<Script>();
        for (ScriptDetails script : scriptDetails) {
            addedScripts.add(this.addScript(script));
        }
        return addedScripts;
    }

    @Override
    public void addScripts(String directory) {
        ArrayList<File> files = new ArrayList<File>();
        if (directory != null && !directory.isEmpty()) {
            files.addAll(FileUtils.getFileNamesForDirectory(directory, SCRIPT_EXTENSION));
        } else {
            logger.error("Given directory is empty");
        }
        this.populateScriptsFromFileList(files);
    }

    @Override
    public List<Script> populateScriptsFromFileList(List<File> files) {
        ArrayList<Script> addedScripts = new ArrayList<Script>();
        for (File scriptFile : files) {
            Script script = this.scripts.get(Script.getScriptIdFromFile(scriptFile));
            if (script != null) continue;
            script = new Script();
            this.createFileBasedScript(script, scriptFile, new ScriptDetails(true, false, scriptFile.getName()));
            addedScripts.add(script);
            this.addScript(script);
        }
        return addedScripts;
    }

    @Override
    public List<Script> populateScripts(List<ScriptDetails> scriptDetails) {
        ArrayList<Script> addedScripts = new ArrayList<Script>();
        for (ScriptDetails details : scriptDetails) {
            File scriptFile = new File(details.getFile());
            if (!scriptFile.exists()) {
                logger.warn("Script {} does not exist!", (Object)details.getFile());
                continue;
            }
            logger.info("Adding script {}", (Object)details.getFile());
            Script script = this.scripts.get(Script.getScriptIdFromFile(scriptFile));
            if (script != null) continue;
            script = new Script();
            this.createFileBasedScript(script, scriptFile, details);
            addedScripts.add(script);
            this.addScript(script);
        }
        return addedScripts;
    }

    @Override
    public void createFileBasedScript(Script script, File scriptFile, ScriptDetails scriptDetails) {
        String scriptName = BaseScriptManager.getScriptName(scriptFile);
        this.createScript(script, scriptName);
        script.setScriptFile(scriptFile);
        script.setScriptDetails(scriptDetails);
    }

    @Override
    public void setVariable(Script script, String name, Object value) {
        script.getScriptEngine().put(name, value);
    }

    @Override
    public void createScript(Script script, String scriptName) {
        try {
            ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("nashorn");
            if (scriptEngine == null) {
                throw new CriticalException("Cannot instantiate the nashorn javascript engine - most likely you don't have Java 8 installed. Please either disable scripts in your configuration file or install the appropriate JRE/JDK.");
            }
            script.setName(scriptName);
            script.setStatusAndNotify(ScriptRunningState.NOT_STARTED);
            script.setScriptEngine(scriptEngine);
            this.populateEngineVariables(script);
        }
        catch (SpyException e) {
            throw new CriticalException("Cannot initialise the script objects");
        }
    }

    @Override
    public abstract void populateEngineVariables(Script var1) throws SpyException;

    public static void putJavaVariablesIntoEngine(ScriptEngine engine, Map<String, Object> variables) {
        SimpleBindings bindings = new SimpleBindings();
        for (String key : variables.keySet()) {
            bindings.put(key, variables.get(key));
        }
        engine.setBindings(bindings, 100);
    }

    @Override
    public void runScript(Script script, boolean asynchronous) {
        this.runScript(script, asynchronous, null);
    }

    @Override
    public void runScript(Script script, boolean asynchronous, Map<String, Object> args) {
        if (!ScriptRunningState.RUNNING.equals((Object)script.getStatus())) {
            script.createScriptRunner(this.eventBus, this.executor);
            script.setAsynchronous(asynchronous);
            HashMap<String, Object> scriptArgs = new HashMap<String, Object>();
            if (args != null) {
                scriptArgs.putAll(args);
            }
            if (this.customParameters != null) {
                scriptArgs.putAll(this.customParameters);
            }
            this.setVariable(script, "args", scriptArgs);
            if (asynchronous) {
                new Thread(script.getScriptRunner()).start();
            } else {
                script.getScriptRunner().run();
            }
        }
    }

    @Override
    public Script addAndRunScript(String scriptLocation, boolean async, Map<String, Object> args) {
        Script script = this.addScript(scriptLocation);
        this.runScript(script, async, args);
        return script;
    }

    @Override
    public void runScriptFileWithReceivedMessage(String scriptFile, IBaseMessage receivedMessage) {
        Script script = this.getScriptObjectFromName(scriptFile);
        if (script != null) {
            this.runScriptFileParameter(script, RECEIVED_MESSAGE_PARAMETER, receivedMessage, false);
        } else {
            logger.warn("No script file found at {}. Please check if this location is correct.", (Object)scriptFile);
        }
    }

    @Override
    public boolean runScriptWithReceivedMessage(Script script, IBaseMessage receivedMessage) {
        this.setVariable(script, RECEIVED_MESSAGE_PARAMETER, receivedMessage);
        try {
            this.invokeFunction(script, ON_MESSAGE_METHOD, new Object[0]);
            return true;
        }
        catch (NoSuchMethodException | ScriptException e) {
            return false;
        }
    }

    @Override
    public void runScriptFileWithMessage(Script script, IBaseMessage message) {
        this.runScriptFileParameter(script, MESSAGE_PARAMETER, message, true);
    }

    @Override
    public void runScriptFileParameter(Script script, String parameterName, Object parameter, boolean asynchronous) {
        this.setVariable(script, parameterName, parameter);
        this.runScript(script, asynchronous);
    }

    @Override
    public boolean invokeBefore(Script script) {
        try {
            this.invokeFunction(script, BEFORE_METHOD, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.info("No setup function present");
        }
        catch (ScriptException e) {
            logger.error("Function execution failure", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean invokeAfter(Script script) {
        try {
            this.invokeFunction(script, AFTER_METHOD, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.info("No after function present");
        }
        catch (ScriptException e) {
            logger.error("Function execution failure", e);
            return false;
        }
        return true;
    }

    @Override
    public Object invokeFunction(Script script, String function, Object ... args) throws NoSuchMethodException, ScriptException {
        Invocable invocable = (Invocable)((Object)script.getScriptEngine());
        Object result = null;
        try {
            result = invocable.invokeFunction(function, args);
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return result;
    }

    @Override
    public void stopScript(Script script) {
        Thread scriptThread;
        logger.debug("Stopping script " + script.getName());
        if (script.getScriptRunner() != null && (scriptThread = script.getScriptRunner().getThread()) != null) {
            scriptThread.interrupt();
        }
    }

    @Override
    public void stopScripts() {
        for (Script script : this.getScripts()) {
            if (script.getScriptFile() == null) continue;
            this.stopScript(script);
        }
    }

    @Override
    public Script getScriptObjectFromName(String scriptFile) {
        return this.scripts.get(scriptFile);
    }

    @Override
    public boolean areScriptsRunning() {
        for (Script script : this.scripts.values()) {
            if (!ScriptRunningState.RUNNING.equals((Object)script.getStatus())) continue;
            logger.debug("Script {} is still running", (Object)script.getName());
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Script> getScriptsMap() {
        return this.scripts;
    }

    @Override
    public Collection<Script> getScripts() {
        return this.scripts.values();
    }

    @Override
    public void addScript(Script script) {
        this.scripts.put(script.getScriptId(), script);
    }

    @Override
    public boolean containsScript(Script script) {
        return this.scripts.containsKey(script.getScriptId());
    }

    @Override
    public void addCustomParameters(Map<String, Object> parameters) {
        this.customParameters = parameters;
    }
}

