/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.formatting;

import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.formatting.FormattingUtils;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.utils.ConversionUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public class ScriptBasedFormatter {
    public static final String FORMAT_FUNCTION_NAME = "format";
    public static final String PRETTY_FUNCTION_NAME = "pretty";
    static final Logger logger = LoggerFactory.getLogger(ScriptBasedFormatter.class);
    private BaseScriptManagerInterface scriptManager;
    private Map<FormatterDetails, Script> formattingScripts = new HashMap<FormatterDetails, Script>();
    private Map<FormatterDetails, Boolean> prettyFormattingAvailable = new HashMap<FormatterDetails, Boolean>();

    public ScriptBasedFormatter(BaseScriptManagerInterface scriptManager) {
        this.scriptManager = scriptManager;
    }

    public Script getScript(FormatterDetails formatter) throws ScriptException {
        Script script = this.formattingScripts.get(formatter);
        if (script == null) {
            this.addFormatter(formatter);
            script = this.formattingScripts.get(formatter);
        }
        return script;
    }

    public void evaluate(Script script) {
        this.scriptManager.runScript(script, false);
        try {
            this.scriptManager.invokeFunction(script, "before", new Object[0]);
        }
        catch (NoSuchMethodException | ScriptException e) {
            logger.info("No setup method present");
        }
    }

    public void addFormatter(FormatterDetails formatter) throws ScriptException {
        long start = TimeUtils.getMonotonicTime();
        if (FormattingUtils.isScriptBased(formatter)) {
            Script script = this.scriptManager.addInlineScript(formatter.getID(), ConversionUtils.base64ToString(formatter.getFunction().get(0).getScriptExecution().getInlineScript()));
            this.formattingScripts.put(formatter, script);
            this.evaluate(script);
        }
        long end = TimeUtils.getMonotonicTime();
        logger.debug("Adding formatter {} took {} ms", (Object)formatter.getName(), (Object)(end - start));
    }

    private String formatMessageWithFunction(FormatterDetails formatter, FormattedMessage message, String functionName) throws ScriptException, NoSuchMethodException {
        Script script = this.formattingScripts.get(formatter);
        if (script == null) {
            logger.debug("Formatting script not found");
            this.addFormatter(formatter);
            script = this.formattingScripts.get(formatter);
        }
        logger.trace("Setting variable {} on {} with {}", "receivedMessage", script, message);
        this.scriptManager.setVariable(script, "receivedMessage", message);
        return (String)this.scriptManager.invokeFunction(script, functionName, new Object[0]);
    }

    public String formatMessage(FormatterDetails formatter, FormattedMessage message) {
        try {
            return this.formatMessageWithFunction(formatter, message, FORMAT_FUNCTION_NAME);
        }
        catch (NoSuchMethodException | ScriptException e) {
            logger.trace("Cannot parse the message", e);
            return message.getPayload();
        }
    }

    public String formatMessage(FormatterDetails formatter, FormattedMessage message, boolean pretty) {
        if (pretty && !Boolean.FALSE.equals(this.prettyFormattingAvailable.get(formatter))) {
            logger.debug("Pretty formatting...");
            try {
                return this.formatMessageWithFunction(formatter, message, PRETTY_FUNCTION_NAME);
            }
            catch (NoSuchMethodException e) {
                this.prettyFormattingAvailable.put(formatter, Boolean.FALSE);
                return this.formatMessage(formatter, message);
            }
            catch (ScriptException e) {
                logger.trace("Cannot parse the message", e);
                return message.getPayload();
            }
        }
        return this.formatMessage(formatter, message);
    }
}

