/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.formatting;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import pl.baczkowicz.spy.common.generated.ConversionFormatterDetails;
import pl.baczkowicz.spy.common.generated.ConversionMethod;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.common.generated.FormatterFunction;
import pl.baczkowicz.spy.common.generated.SubstringConversionFormatterDetails;
import pl.baczkowicz.spy.common.generated.SubstringExtractFormatterDetails;
import pl.baczkowicz.spy.common.generated.SubstringFormatterDetails;
import pl.baczkowicz.spy.common.generated.SubstringReplaceFormatterDetails;
import pl.baczkowicz.spy.exceptions.ConversionException;
import pl.baczkowicz.spy.utils.ConversionUtils;

public class FormattingUtils {
    public static final String DEFAULT_PREFIX = "default";
    public static final String SCRIPT_PREFIX = "script";
    private static final Logger logger = LoggerFactory.getLogger(FormattingUtils.class);

    public static String formatNumber(long number) {
        long rest;
        long divided;
        StringBuffer sb = new StringBuffer();
        for (divided = number; divided > 1000L; divided /= 1000L) {
            rest = divided % 1000L;
            sb.insert(0, " " + String.format("%03d", rest));
        }
        rest = divided % 1000L;
        sb.insert(0, rest);
        return sb.toString();
    }

    public static String formatText(FormatterDetails customFormatter, String text, byte[] rawText) {
        logger.trace("Formatting '" + text + "' with " + customFormatter.getName());
        String formattedText = text;
        for (FormatterFunction function : customFormatter.getFunction()) {
            if (function.getSubstringReplace() != null) {
                formattedText = FormattingUtils.doSubstringReplacement(function.getSubstringReplace(), formattedText);
            } else if (function.getSubstringExtract() != null) {
                formattedText = FormattingUtils.doSubstringExtract(function.getSubstringExtract(), formattedText);
            } else if (function.getSubstringConversion() != null) {
                formattedText = FormattingUtils.doSubstringConversion(function.getSubstringConversion(), formattedText);
            } else if (function.getConversion() != null) {
                formattedText = customFormatter.getFunction().size() == 1 && rawText != null ? FormattingUtils.convertText(function.getConversion().getFormat(), rawText) : FormattingUtils.convertText(function.getConversion().getFormat(), formattedText);
            } else if (function.getCharacterReplace() != null) {
                formattedText = FormattingUtils.replaceCharacters(function.getCharacterReplace().getFormat(), formattedText, function.getCharacterReplace().getCharacterRangeFrom(), function.getCharacterReplace().getCharacterRangeTo(), function.getCharacterReplace().getWrapCharacter());
            }
            logger.trace("After function transformation = '" + formattedText + "'");
        }
        return formattedText;
    }

    public static String replaceCharacters(ConversionMethod conversionMethod, String input, int fromCharacter, int toCharacter, String wrap) {
        String convertedText = input;
        for (int i = fromCharacter; i <= toCharacter; ++i) {
            String characterToReplace = new String(Character.toChars(i));
            convertedText = wrap != null ? convertedText.replace(characterToReplace, wrap + FormattingUtils.convertText(conversionMethod, characterToReplace) + wrap) : convertedText.replace(characterToReplace, FormattingUtils.convertText(conversionMethod, characterToReplace));
        }
        return convertedText;
    }

    private static String extractValueForConversion(SubstringFormatterDetails details, String text) throws ConversionException {
        int endTagIndex;
        int startTagIndex = text.indexOf(details.getStartTag());
        if (startTagIndex != -1 && (endTagIndex = text.indexOf(details.getEndTag(), startTagIndex)) != -1) {
            return text.substring(startTagIndex + details.getStartTag().length(), endTagIndex);
        }
        throw new ConversionException("Cannot find tags");
    }

    private static String replaceTextAndTags(SubstringFormatterDetails details, String text, String input, String output) {
        String convertedText = text;
        convertedText = details.isKeepTags() ? convertedText.replace(input, output) : convertedText.replace(details.getStartTag() + input + details.getEndTag(), output);
        return convertedText;
    }

    private static String doSubstringConversion(SubstringConversionFormatterDetails details, String text) {
        String convertedText = text;
        try {
            String input = FormattingUtils.extractValueForConversion(details, convertedText);
            String output = FormattingUtils.convertText(details.getFormat(), input);
            convertedText = FormattingUtils.replaceTextAndTags(details, convertedText, input, output);
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        return convertedText;
    }

    private static String doSubstringReplacement(SubstringReplaceFormatterDetails details, String text) {
        String convertedText = text;
        try {
            String input = FormattingUtils.extractValueForConversion(details, convertedText);
            String output = details.getReplaceWith();
            convertedText = FormattingUtils.replaceTextAndTags(details, convertedText, input, output);
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        return convertedText;
    }

    private static String doSubstringExtract(SubstringExtractFormatterDetails details, String text) {
        String convertedText = text;
        try {
            String input = FormattingUtils.extractValueForConversion(details, convertedText);
            convertedText = details.isKeepTags() ? details.getStartTag() + input + details.getEndTag() : input;
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        return convertedText;
    }

    public static String convertText(ConversionMethod method, String text) {
        switch (method) {
            case PLAIN: {
                return text;
            }
            case HEX_ENCODE: {
                return ConversionUtils.stringToHex(text);
            }
            case HEX_DECODE: {
                return ConversionUtils.hexToStringNoException(text);
            }
            case BASE_64_ENCODE: {
                return ConversionUtils.stringToBase64(text);
            }
            case BASE_64_DECODE: {
                return ConversionUtils.base64ToString(text);
            }
        }
        return text;
    }

    public static String convertText(ConversionMethod method, byte[] text) {
        switch (method) {
            case HEX_ENCODE: {
                return new String(Hex.encodeHex(text));
            }
            case HEX_DECODE: {
                return ConversionUtils.hexToStringNoException(ConversionUtils.arrayToString(text));
            }
            case BASE_64_ENCODE: {
                return Base64.encodeBase64String(text);
            }
            case BASE_64_DECODE: {
                return new String(Base64.decodeBase64(text));
            }
        }
        return ConversionUtils.arrayToString(text);
    }

    public static String checkAndFormatText(FormatterDetails format, String text) {
        if (format != null) {
            return FormattingUtils.formatText(format, text, null);
        }
        return text;
    }

    public static String checkAndFormatText(FormatterDetails format, byte[] text) {
        if (format != null) {
            return FormattingUtils.formatText(format, ConversionUtils.arrayToString(text), text);
        }
        return ConversionUtils.arrayToString(text);
    }

    private static FormatterFunction createBasicFormatterFunction(ConversionMethod conversionMethod) {
        FormatterFunction function = new FormatterFunction();
        ConversionFormatterDetails conversionFormatterDetails = new ConversionFormatterDetails();
        conversionFormatterDetails.setFormat(conversionMethod);
        function.setConversion(conversionFormatterDetails);
        return function;
    }

    public static FormatterDetails createBasicFormatter(String id, String name, String description, ConversionMethod conversionMethod) {
        FormatterDetails formatter = new FormatterDetails();
        formatter.setID(id);
        formatter.setName(name);
        formatter.setDescription(description);
        formatter.getFunction().add(FormattingUtils.createBasicFormatterFunction(conversionMethod));
        return formatter;
    }

    public static boolean isScriptBased(FormatterDetails formatter) {
        return formatter.getID().startsWith(SCRIPT_PREFIX) || formatter.getID().startsWith("defaultscript");
    }

    public static List<FormatterDetails> createBaseFormatters() {
        ArrayList<FormatterDetails> baseFormatters = new ArrayList<FormatterDetails>();
        baseFormatters.add(FormattingUtils.createBasicFormatter(DEFAULT_PREFIX, "Plain", "No formatting - as received.", ConversionMethod.PLAIN));
        baseFormatters.add(FormattingUtils.createBasicFormatter("default-hexDecoder", "HEX decoder", "Decodes from a HEX string.", ConversionMethod.HEX_DECODE));
        baseFormatters.add(FormattingUtils.createBasicFormatter("default-hexEncoder", "HEX encoder", "Encodes the given value as a HEX string.", ConversionMethod.HEX_ENCODE));
        baseFormatters.add(FormattingUtils.createBasicFormatter("default-base64Decoder", "Base64 decoder", "Decodes a Base64 string.", ConversionMethod.BASE_64_DECODE));
        baseFormatters.add(FormattingUtils.createBasicFormatter("default-base64Encoder", "Base64 encoder", "Encodes the given value to Base64.", ConversionMethod.BASE_64_ENCODE));
        return baseFormatters;
    }

    public static boolean isDefault(FormatterDetails formatter) {
        return formatter.getID().startsWith(DEFAULT_PREFIX);
    }

    public static String prettyXml(Document document, int indent) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        return writer.getBuffer().toString();
    }

    public static String prettyXml(String xml, int indent) throws SAXException, IOException, TransformerException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(xml)));
        return FormattingUtils.prettyXml(document, indent);
    }
}

