/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.daemon;

import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.RunningMode;
import pl.baczkowicz.spy.common.generated.ScriptDetails;
import pl.baczkowicz.spy.common.generated.TestCasesSettings;
import pl.baczkowicz.spy.daemon.IDaemon;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.testcases.TestCaseManager;
import pl.baczkowicz.spy.testcases.TestCaseOptions;
import pl.baczkowicz.spy.testcases.TestCaseResult;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public abstract class BaseDaemon
implements IDaemon {
    private static final Logger logger = LoggerFactory.getLogger(BaseDaemon.class);
    protected BaseScriptManagerInterface scriptManager;
    protected TestCaseManager testCaseManager;

    @Override
    public TestCaseResult runTestCase(String testCaseLocation) {
        return this.runTestCase(testCaseLocation, null, null);
    }

    @Override
    public TestCaseResult runTestCase(String testCaseLocation, Map<String, Object> args) {
        return this.runTestCase(testCaseLocation, args, null);
    }

    @Override
    public TestCaseResult runTestCase(String testCaseLocation, Map<String, Object> args, TestCaseOptions options) {
        if (options != null) {
            this.testCaseManager.setOptions(options);
        }
        return this.testCaseManager.addAndRunTestCase(testCaseLocation, args);
    }

    @Override
    public Script runScript(String scriptLocation) {
        return this.runScript(scriptLocation, false, null);
    }

    @Override
    public Script runScript(String scriptLocation, boolean async, Map<String, Object> args) {
        return this.scriptManager.addAndRunScript(scriptLocation, async, args);
    }

    @Override
    public Object runScriptFunction(String scriptLocation, String functionName, Map<String, Object> args) {
        try {
            Script script = this.scriptManager.getScriptObjectFromName(scriptLocation);
            if (script == null) {
                script = this.runScript(scriptLocation);
            }
            this.scriptManager.setVariable(script, "args", args);
            return this.scriptManager.invokeFunction(script, functionName, new Object[0]);
        }
        catch (NoSuchMethodException | ScriptException e) {
            logger.error("Coundn't run function {} for script {}", functionName, scriptLocation, e);
            return null;
        }
    }

    @Override
    public void stopScript(Script script) {
        this.scriptManager.stopScript(script);
    }

    @Override
    public void stopScript(String scriptName) {
        Script script = this.scriptManager.getScriptObjectFromName(scriptName);
        if (script != null) {
            this.scriptManager.stopScript(script);
        } else {
            logger.warn("Script {} doesn't exist, so can't stop it", (Object)scriptName);
        }
    }

    protected void stopScripts() {
        this.scriptManager.stopScripts();
    }

    @Override
    public boolean start(String configurationFile) {
        try {
            this.initialise();
            this.loadAndRun(configurationFile);
            return true;
        }
        catch (XMLException e) {
            logger.error("Cannot load the daemon's configuration", e);
        }
        catch (SpyException e) {
            logger.error("Error occurred while connecting to server", e);
        }
        return false;
    }

    @Override
    public void stop() {
        this.stopScripts();
        this.waitAndStop();
    }

    protected void runScripts(List<ScriptDetails> scriptSettings, TestCasesSettings testCasesSettings, RunningMode runningMode) throws SpyException {
        this.runScripts(scriptSettings, testCasesSettings, runningMode, null);
    }

    protected void runScripts(List<ScriptDetails> scriptSettings, TestCasesSettings testCasesSettings, RunningMode runningMode, Map<String, Object> parameters) throws SpyException {
        this.scriptManager.addCustomParameters(parameters);
        List<Script> backgroundScripts = this.scriptManager.addScripts(scriptSettings);
        for (Script script : backgroundScripts) {
            logger.info("About to start background script " + script.getName());
            this.scriptManager.runScript(script, true);
        }
        if (testCasesSettings != null) {
            this.testCaseManager.getOptions().setAutoExport(testCasesSettings.isExportResults());
            if (testCasesSettings.isRecordRepeatedSteps() != null) {
                this.testCaseManager.getOptions().setRecordRepeatedSteps(testCasesSettings.isRecordRepeatedSteps());
            }
            if (testCasesSettings.getStepInterval() != null) {
                this.testCaseManager.getOptions().setStepInterval(testCasesSettings.getStepInterval());
            }
            this.testCaseManager.loadTestCases(testCasesSettings.getLocation());
            while (!this.canPublish()) {
                logger.debug("Client not connected yet - can't start test cases... [waiting another 1000ms]");
                ThreadingUtils.sleep(1000L);
            }
            this.testCaseManager.runAllTestCases();
        }
        if (RunningMode.SCRIPTS_ONLY.equals((Object)runningMode)) {
            this.waitAndStop();
        }
    }

    protected void waitForScripts() {
        ThreadingUtils.sleep(1000L);
        while (this.scriptManager.areScriptsRunning()) {
            logger.debug("Scripts are still running... [waiting another 1000ms]");
            ThreadingUtils.sleep(1000L);
        }
        while (this.testCaseManager.areTestCasesStillRunning()) {
            logger.debug("Test cases are still running... [waiting another 1000ms]");
            ThreadingUtils.sleep(1000L);
        }
    }

    protected void displayGoodbyeMessage() {
        ThreadingUtils.sleep(1000L);
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            logger.trace("Thread {} is still running", (Object)thread.getName());
        }
        logger.info("All tasks completed - bye bye...");
    }

    protected abstract void waitAndStop();

    public abstract void initialise() throws XMLException;

    public abstract void loadAndRun(String var1) throws SpyException;

    @Override
    public abstract boolean canPublish();
}

