/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.connectivity;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.ReconnectionSettings;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.connectivity.IConnectionWithReconnect;
import pl.baczkowicz.spy.utils.ThreadingUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public class ReconnectionManager
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ReconnectionManager.class);
    private final Map<IConnectionWithReconnect, Runnable> connections = new HashMap<IConnectionWithReconnect, Runnable>();
    private static final int SLEEP = 100;
    private boolean running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(IConnectionWithReconnect connection, Runnable connector) {
        Map<IConnectionWithReconnect, Runnable> map = this.connections;
        synchronized (map) {
            this.connections.put(connection, connector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(IConnectionWithReconnect connection) {
        Map<IConnectionWithReconnect, Runnable> map = this.connections;
        synchronized (map) {
            this.connections.remove(connection);
        }
    }

    public void oneCycle() {
        for (IConnectionWithReconnect connection : this.connections.keySet()) {
            if (connection.getConnectionStatus().equals((Object)ConnectionStatus.CONNECTING)) continue;
            ReconnectionSettings reconnectionSettings = connection.getReconnectionSettings();
            if (connection.getLastConnectionAttemptTimestamp() + (long)reconnectionSettings.getRetryInterval() > TimeUtils.getMonotonicTime() || !connection.getConnectionStatus().equals((Object)ConnectionStatus.DISCONNECTED) && !connection.getConnectionStatus().equals((Object)ConnectionStatus.NOT_CONNECTED)) continue;
            logger.info("Starting connection {}", (Object)connection.getName());
            new Thread(this.connections.get(connection)).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("Reconnection Manager");
        this.running = true;
        while (this.running) {
            Map<IConnectionWithReconnect, Runnable> map = this.connections;
            synchronized (map) {
                this.oneCycle();
            }
            if (!ThreadingUtils.sleep(100L)) continue;
        }
        ThreadingUtils.logThreadEnding();
    }

    public void stop() {
        this.running = false;
    }
}

