/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import pl.baczkowicz.spy.exceptions.ConfigurationException;

public class PropertyFileLoader {
    private Properties properties;

    public void readFromClassPath(String propertyFileLocation) throws ConfigurationException {
        this.properties = PropertyFileLoader.readPropertyFileFromClassPath(propertyFileLocation);
    }

    public void readFromFileSystem(File propertyFileLocation) throws ConfigurationException {
        this.properties = PropertyFileLoader.readPropertyFileFromFileSystem(propertyFileLocation);
    }

    public static Properties readPropertyFileFromClassPath(String propertyFileLocation) throws ConfigurationException {
        Properties fileProperties = new Properties();
        try {
            InputStream inputStream = PropertyFileLoader.class.getResourceAsStream(propertyFileLocation);
            fileProperties.load(inputStream);
            if (inputStream == null) {
                throw new FileNotFoundException("Property file '" + propertyFileLocation + "' not found in the classpath");
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot load the properties file", e);
        }
        return fileProperties;
    }

    public static Properties readPropertyFileFromFileSystem(File propertyFileLocation) throws ConfigurationException {
        Properties fileProperties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(propertyFileLocation);
            fileProperties.load(inputStream);
            ((InputStream)inputStream).close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot load the properties file", e);
        }
        return fileProperties;
    }

    public void saveToFileSystem(String appName, File propertyFileLocation) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(propertyFileLocation);
        this.properties.store(outputStream, "=== " + appName + " properties ===");
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName, "");
    }

    public boolean getBooleanProperty(String propertyName) {
        return new Boolean(this.properties.getProperty(propertyName, "false"));
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.setProperty(propertyName, propertyValue);
    }

    public String getBuildNumber() {
        return this.getProperty("application.build");
    }

    public String getFullVersionNumber() {
        return this.getProperty("application.version") + "-" + this.getBuildNumber();
    }

    public String getFullVersionName() {
        return this.getProperty("application.version").replace("-", " ") + " (build " + this.getBuildNumber() + ")";
    }

    public String getApplicationLogo() {
        return this.getProperty("application.logo");
    }

    public String getApplicationName() {
        return this.getProperty("application.name");
    }

    public String getApplicationWikiUrl() {
        return this.getProperty("application.wiki.url");
    }
}

