/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.configuration.PropertyFileLoader;
import pl.baczkowicz.spy.utils.ConversionUtils;

public class BaseConfigurationUtils {
    public static final String DEFAULT_GROUP = "default_group";
    public static final int DEFAULT_RECONNECTION_INTERVAL = 5000;
    private static final Logger logger = LoggerFactory.getLogger(BaseConfigurationUtils.class);

    public static void streamToFile(InputStream input, File output) throws IOException {
        try (FileOutputStream out = new FileOutputStream(output);){
            IOUtils.copy(input, (OutputStream)out);
        }
    }

    public static boolean getBooleanProperty(String propertyName, boolean defaultValue, PropertyFileLoader fileLoader) {
        String value = fileLoader.getProperty(propertyName);
        Boolean returnValue = defaultValue;
        if (value == null || value.isEmpty()) {
            returnValue = defaultValue;
        } else {
            try {
                returnValue = Boolean.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid format " + value);
            }
        }
        fileLoader.setProperty(propertyName, String.valueOf(returnValue));
        return returnValue;
    }

    public static double getDoubleProperty(String propertyName, double defaultValue, PropertyFileLoader fileLoader) {
        String value = fileLoader.getProperty(propertyName);
        Double returnValue = defaultValue;
        try {
            returnValue = Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid number format " + value);
        }
        fileLoader.setProperty(propertyName, String.valueOf(returnValue));
        return returnValue;
    }

    public static int getIntegerProperty(String propertyName, int defaultValue, PropertyFileLoader fileLoader) {
        String value = fileLoader.getProperty(propertyName);
        Integer returnValue = defaultValue;
        try {
            returnValue = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid number format " + value);
        }
        fileLoader.setProperty(propertyName, String.valueOf(returnValue));
        return returnValue;
    }

    public static String encodePassword(String value) {
        return ConversionUtils.stringToBase64(value);
    }

    public static String decodePassword(String value) {
        return ConversionUtils.base64ToString(value);
    }
}

