/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.audit;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.audit.IAuditReplayIO;
import pl.baczkowicz.spy.audit.StreamedAuditReader;
import pl.baczkowicz.spy.messages.BaseMessage;
import pl.baczkowicz.spy.utils.ThreadingUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public abstract class AuditReplay
implements IAuditReplayIO,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AuditReplay.class);
    protected StreamedAuditReader auditReader;
    private long replayTime;
    private long lastUpdated;
    private boolean running = false;
    private double speed = 1.0;

    @Override
    public long readFromFile(String logLocation) {
        this.auditReader = new StreamedAuditReader();
        try {
            this.auditReader.openAuditFile(new File(logLocation));
            logger.info("Found {} messages in {}", (Object)this.auditReader.getCount(), (Object)logLocation);
            return this.auditReader.getCount();
        }
        catch (Exception e) {
            logger.error("Cannot read message audit log at " + logLocation, e);
            return 0L;
        }
    }

    @Override
    public long getMessageCount() {
        if (this.auditReader == null) {
            return 0L;
        }
        return this.auditReader.getCount();
    }

    @Override
    public void start() {
        if (this.auditReader.getCount() > 0L) {
            this.replayTime = this.getMessageTime();
            this.lastUpdated = TimeUtils.getMonotonicTime();
            this.running = true;
            new Thread(this).start();
        }
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public void setSpeed(double newSpeed) {
        if (newSpeed > 1.0) {
            if (this.speed <= 1.0) {
                logger.info("Warp enabled. Changing replay speed from {} to {}", (Object)this.speed, (Object)newSpeed);
            } else {
                logger.info("Warp still on. Changing replay speed from {} to {}", (Object)this.speed, (Object)newSpeed);
            }
        } else if (newSpeed == 1.0) {
            logger.info("Back to normal. Changing replay speed from {} to {}", (Object)this.speed, (Object)newSpeed);
        } else {
            logger.info("Tea time! Changing replay speed from {} to {}", (Object)this.speed, (Object)newSpeed);
        }
        this.speed = newSpeed;
    }

    @Override
    public boolean isReadyToPublish() {
        return this.replayTime > this.getMessageTime();
    }

    @Override
    public BaseMessage getNextMessage() {
        return this.getMessage();
    }

    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("Audit Replay IO");
        while (this.running) {
            long now = TimeUtils.getMonotonicTime();
            if (now > this.lastUpdated) {
                long sinceLastUpdated = now - this.lastUpdated;
                double increase = (double)sinceLastUpdated * this.speed;
                this.replayTime += (long)increase;
                this.lastUpdated = now;
            }
            if (!ThreadingUtils.sleep(10L)) continue;
            break;
        }
        this.stop();
        ThreadingUtils.logThreadEnding();
    }

    protected abstract long getMessageTime();

    protected abstract BaseMessage getMessage();
}

