/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import pl.baczkowicz.mqttspy.common.generated.ProtocolVersionEnum;
import pl.baczkowicz.spy.exceptions.SpyException;

public class MqttUtils {
    public static final String TCP_PREFIX = "tcp://";
    public static final String SSL_PREFIX = "ssl://";
    public static final String WS_PREFIX = "ws://";
    public static final String SWS_PREFIX = "wss://";
    public static final String MULTI_LEVEL_WILDCARD = "#";
    public static final String SINGLE_LEVEL_WILDCARD = "+";
    public static final String TOPIC_DELIMITER = "/";
    public static final int MAX_CLIENT_LENGTH_FOR_3_1 = 23;
    private static final String CLIENT_ID_TIMESTAMP_FORMAT = "HHmmssSSS";
    private static final SimpleDateFormat CLIENT_ID_SDF = new SimpleDateFormat("HHmmssSSS");

    public static String removeLastDelimiter(String topic) {
        if (topic.endsWith(TOPIC_DELIMITER)) {
            topic = topic.substring(0, topic.length() - TOPIC_DELIMITER.length());
        }
        return topic;
    }

    public static String generateClientIdWithTimestamp(String prefix, ProtocolVersionEnum protocol) {
        int addedLength = CLIENT_ID_TIMESTAMP_FORMAT.length();
        String newClientId = prefix;
        if (MqttUtils.limitClientId(protocol) && newClientId.length() + addedLength > 23) {
            newClientId = newClientId.substring(0, 23 - addedLength);
        }
        newClientId = newClientId + CLIENT_ID_SDF.format(new Date());
        return newClientId;
    }

    public static boolean limitClientId(ProtocolVersionEnum protocol) {
        return ProtocolVersionEnum.MQTT_3_1.equals((Object)protocol) || ProtocolVersionEnum.MQTT_DEFAULT.equals((Object)protocol);
    }

    public static String getCompleteServerURI(String brokerAddress, boolean sslEnabled, boolean websocket) {
        String serverURI = brokerAddress.replaceAll(TCP_PREFIX, "").replaceAll(SSL_PREFIX, "").replaceAll(WS_PREFIX, "").replaceAll(SWS_PREFIX, "");
        serverURI = sslEnabled && websocket ? SWS_PREFIX + serverURI : (sslEnabled && !websocket ? SSL_PREFIX + serverURI : (!sslEnabled && websocket ? WS_PREFIX + serverURI : TCP_PREFIX + serverURI));
        return serverURI;
    }

    public static boolean recordTopic(String newTopic, List<String> topics) {
        boolean contains = topics.contains(newTopic);
        if (!contains) {
            topics.add(newTopic);
            return true;
        }
        return false;
    }

    public static void validateTopic(String topic) throws SpyException {
        try {
            MqttTopic.validate(topic, true);
        }
        catch (Exception e) {
            throw new SpyException(e.getMessage(), e);
        }
    }
}

