/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.stats;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.configuration.MqttConfigurationManager;
import pl.baczkowicz.mqttspy.stats.generated.MqttSpyStats;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.ui.stats.SpyStats;
import pl.baczkowicz.spy.ui.stats.StatsIO;
import pl.baczkowicz.spy.xml.XMLParser;

public class MqttStatsFileIO
implements StatsIO {
    private static final Logger logger = LoggerFactory.getLogger(MqttStatsFileIO.class);
    public static final String PACKAGE = "pl.baczkowicz.mqttspy.stats.generated";
    public static final String SCHEMA = "/mqtt-spy-stats.xsd";
    private static final String STATS_FILENAME = "mqtt-spy-stats.xml";
    private final XMLParser parser = new XMLParser("pl.baczkowicz.mqttspy.stats.generated", "/mqtt-spy-stats.xsd");
    private File statsFile = new File(MqttConfigurationManager.getDefaultHomeDirectory() + "mqtt-spy-stats.xml");
    public MqttSpyStats stats;

    @Override
    public SpyStats loadStats() {
        try {
            this.stats = (MqttSpyStats)this.parser.loadFromFile(this.statsFile);
            return MqttStatsFileIO.getStats(this.stats);
        }
        catch (XMLException e) {
            logger.error("Cannot process the statistics file at " + this.statsFile.getAbsolutePath(), e);
        }
        catch (FileNotFoundException e) {
            logger.error("Cannot read the statistics file from " + this.statsFile.getAbsolutePath(), e);
        }
        Random random = new Random();
        this.stats = new MqttSpyStats();
        this.stats.setID(random.nextLong());
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date());
        try {
            this.stats.setStartDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(gc));
        }
        catch (DatatypeConfigurationException e) {
            logger.error("Cannot create date for stats", e);
        }
        return MqttStatsFileIO.getStats(this.stats);
    }

    public static SpyStats getStats(MqttSpyStats stats) {
        return new SpyStats(stats.getID(), stats.getStartDate().toGregorianCalendar().getTime(), stats.getConnections(), stats.getSubscriptions(), stats.getMessagesPublished(), stats.getMessagesReceived());
    }

    @Override
    public boolean saveStats(SpyStats stats) {
        try {
            new File(MqttConfigurationManager.getDefaultHomeDirectory()).mkdirs();
            if (!this.statsFile.exists()) {
                this.statsFile.createNewFile();
            } else if (this.statsFile.isDirectory()) {
                this.statsFile.delete();
                this.statsFile.createNewFile();
            }
            MqttSpyStats mqttSpyStats = new MqttSpyStats();
            mqttSpyStats.setConnections(stats.getConnections());
            mqttSpyStats.setID(stats.getId());
            mqttSpyStats.setMessagesPublished(stats.getMessagesPublished());
            mqttSpyStats.setMessagesReceived(stats.getMessagesReceived());
            mqttSpyStats.setSubscriptions(stats.getSubscriptions());
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(stats.getStartDate());
            try {
                mqttSpyStats.setStartDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(gc));
            }
            catch (DatatypeConfigurationException e) {
                logger.error("Cannot create date for stats", e);
            }
            this.parser.saveToFile(this.statsFile, new JAXBElement(new QName("http://baczkowicz.pl/mqtt-spy-stats", "MqttSpyStats"), MqttSpyStats.class, (Object)mqttSpyStats));
            return true;
        }
        catch (IOException | XMLException e) {
            logger.error("Cannot save the statistics file - " + this.statsFile.getAbsolutePath(), e);
            return false;
        }
    }
}

