/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.events.queuable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.storage.MessageList;
import pl.baczkowicz.spy.ui.events.MessageAddedEvent;
import pl.baczkowicz.spy.ui.events.MessageRemovedEvent;
import pl.baczkowicz.spy.ui.events.queuable.EventQueueManager;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseReceivedMessageEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseRemovedMessageEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.SpyUIEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.TopicSummaryNewMessageEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.TopicSummaryRemovedMessageEvent;
import pl.baczkowicz.spy.ui.storage.MessageListWithObservableTopicSummary;
import pl.baczkowicz.spy.utils.ThreadingUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public class UIEventHandler
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(UIEventHandler.class);
    private final EventQueueManager<FormattedMqttMessage> uiEventQueue;
    private IKBus eventBus;

    public UIEventHandler(EventQueueManager<FormattedMqttMessage> uiEventQueue, IKBus eventBus) {
        this.uiEventQueue = uiEventQueue;
        this.eventBus = eventBus;
    }

    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("UI event handler");
        do {
            if (this.uiEventQueue.getEventCount() <= 0L) continue;
            this.showUpdates();
        } while (!ThreadingUtils.sleep(100L));
        ThreadingUtils.logThreadEnding();
    }

    private void showUpdates() {
        long start = TimeUtils.getMonotonicTime();
        long processed = 0L;
        while (this.uiEventQueue.getEventCount() > 0L) {
            Map<String, List<SpyUIEvent<FormattedMqttMessage>>> events = this.uiEventQueue.getEvents();
            for (String type : events.keySet()) {
                List<SpyUIEvent<FormattedMqttMessage>> eventQueue = this.uiEventQueue.getAndRemoveEvents(type);
                if (eventQueue.isEmpty()) continue;
                processed += (long)eventQueue.size();
                this.processEventType(eventQueue);
            }
        }
        long end = TimeUtils.getMonotonicTime();
        if (logger.isTraceEnabled()) {
            logger.trace("UI event handling of {} items took {} ms", (Object)processed, (Object)(end - start));
        }
    }

    private void processEventType(List<SpyUIEvent<FormattedMqttMessage>> eventQueue) {
        final HashMap parentToEvent = new HashMap();
        for (SpyUIEvent<FormattedMqttMessage> event : eventQueue) {
            ArrayList parentQueue = (ArrayList)parentToEvent.get(event.getList());
            if (parentQueue == null) {
                parentQueue = new ArrayList();
                parentToEvent.put(event.getList(), parentQueue);
            }
            ((List)parentToEvent.get(event.getList())).add(event);
        }
        for (final MessageList parent : parentToEvent.keySet()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UIEventHandler.this.handleEvents((List)parentToEvent.get(parent));
                }
            });
        }
    }

    private void handleEvents(List<SpyUIEvent<FormattedMqttMessage>> eventQueue) {
        block3: {
            SpyUIEvent<FormattedMqttMessage> event;
            block5: {
                block4: {
                    block2: {
                        event = eventQueue.get(0);
                        if (!(event instanceof BrowseReceivedMessageEvent)) break block2;
                        this.eventBus.publish(new MessageAddedEvent<FormattedMqttMessage>(eventQueue, ((BrowseReceivedMessageEvent)event).getList()));
                        break block3;
                    }
                    if (!(event instanceof BrowseRemovedMessageEvent)) break block4;
                    this.eventBus.publish(new MessageRemovedEvent<FormattedMqttMessage>(eventQueue, event.getList()));
                    break block3;
                }
                if (!(event instanceof TopicSummaryNewMessageEvent)) break block5;
                for (SpyUIEvent<FormattedMqttMessage> item : eventQueue) {
                    this.handleTopicSummaryNewMessageEvent((TopicSummaryNewMessageEvent)item);
                }
                break block3;
            }
            if (!(event instanceof TopicSummaryRemovedMessageEvent)) break block3;
            for (SpyUIEvent<FormattedMqttMessage> item : eventQueue) {
                this.handleTopicSummaryRemovedMessageEvent((TopicSummaryRemovedMessageEvent)item);
            }
        }
    }

    private void handleTopicSummaryNewMessageEvent(TopicSummaryNewMessageEvent<FormattedMqttMessage> updateEvent) {
        ((MessageListWithObservableTopicSummary)updateEvent.getList()).getTopicSummary().addMessage(updateEvent.getAdded());
        if (updateEvent.isShowTopic()) {
            ((MessageListWithObservableTopicSummary)updateEvent.getList()).getTopicSummary().setShowValue(updateEvent.getAdded().getTopic(), true);
        }
    }

    private void handleTopicSummaryRemovedMessageEvent(TopicSummaryRemovedMessageEvent<FormattedMqttMessage> removeEvent) {
        if (removeEvent.getRemoved() != null) {
            ((MessageListWithObservableTopicSummary)removeEvent.getList()).getTopicSummary().removeMessage(removeEvent.getRemoved());
        }
    }
}

