/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controlpanel;

import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.controllers.ControlPanelItemController;
import pl.baczkowicz.spy.ui.controlpanel.ControlPanelStatsUpdater;
import pl.baczkowicz.spy.ui.controlpanel.IControlPanelItem;
import pl.baczkowicz.spy.ui.controls.GettingInvolvedTooltip;

public class MqttStatsControlPanelItem
implements IControlPanelItem {
    private IKBus eventBus;
    private IConfigurationManager configurationManager;

    public MqttStatsControlPanelItem(IConfigurationManager configurationManager, IKBus eventBus) {
        this.eventBus = eventBus;
        this.configurationManager = configurationManager;
    }

    @Override
    public void update(ControlPanelItemController controlPanelItemController, Button button) {
        this.showStats(controlPanelItemController, button, this.eventBus);
    }

    public void showStats(ControlPanelItemController controller, Button button, IKBus eventBus) {
        controller.refresh();
        ControlPanelStatsUpdater statsUpdater = new ControlPanelStatsUpdater(controller, button, eventBus, this.configurationManager);
        statsUpdater.show();
        String text = this.configurationManager.getDefaultPropertyFile().getApplicationName() + " needs you! Please support the project" + System.lineSeparator() + "by raising bugs, helping out with testing" + System.lineSeparator() + "or making a charity donation. " + System.lineSeparator() + "See " + this.configurationManager.getDefaultPropertyFile().getApplicationWikiUrl() + "Getting-involved" + System.lineSeparator() + "for more information on how to get involved." + System.lineSeparator();
        final GettingInvolvedTooltip gettingInvolvedTooltip = new GettingInvolvedTooltip(text, this.configurationManager.getDefaultPropertyFile().getApplicationLogo());
        button.setTooltip((Tooltip)gettingInvolvedTooltip);
        button.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                gettingInvolvedTooltip.setCurrentMousePosition(event);
                if (gettingInvolvedTooltip.isShowing()) {
                    gettingInvolvedTooltip.checkAndHide();
                }
            }
        });
    }
}

