/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers.edit;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import pl.baczkowicz.mqttspy.common.generated.SecureSocketSettings;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.spy.common.generated.Property;
import pl.baczkowicz.spy.common.generated.SecureSocketModeEnum;
import pl.baczkowicz.spy.ui.properties.KeyValueProperty;

public class EditConnectionSecurityTlsPropertiesController
extends AnchorPane
implements Initializable {
    private EditMqttConnectionController parent;
    @FXML
    private AnchorPane propertiesPane;
    @FXML
    private TableView<KeyValueProperty> sslPropertiesTable;
    @FXML
    private TableColumn<KeyValueProperty, String> propertyNameColumn;
    @FXML
    private TableColumn<KeyValueProperty, String> propertyValueColumn;
    @FXML
    private Button removePropertyButton;

    public void initialize(URL location, ResourceBundle resources) {
        this.propertyNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("key"));
        this.propertyNameColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.propertyNameColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<KeyValueProperty, String>>(){

            public void handle(TableColumn.CellEditEvent<KeyValueProperty, String> event) {
                KeyValueProperty p = (KeyValueProperty)event.getRowValue();
                String newValue = (String)event.getNewValue();
                p.keyProperty().set(newValue);
                EditConnectionSecurityTlsPropertiesController.this.onChange();
            }
        });
        this.propertyValueColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.propertyValueColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.propertyValueColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<KeyValueProperty, String>>(){

            public void handle(TableColumn.CellEditEvent<KeyValueProperty, String> event) {
                KeyValueProperty p = (KeyValueProperty)event.getRowValue();
                String newValue = (String)event.getNewValue();
                p.valueProperty().set(newValue);
                EditConnectionSecurityTlsPropertiesController.this.onChange();
            }
        });
    }

    public void init() {
    }

    public void onChange() {
        this.parent.onChange();
    }

    public void readAndSetValues(SecureSocketModeEnum mode, UserInterfaceMqttConnectionDetails connection) {
        if (mode == null || SecureSocketModeEnum.DISABLED.equals((Object)mode)) {
            connection.setSSL(null);
        } else {
            SecureSocketSettings sslSettings = connection.getSSL();
            if (SecureSocketModeEnum.PROPERTIES.equals((Object)mode)) {
                for (KeyValueProperty property : this.sslPropertiesTable.getItems()) {
                    sslSettings.getProperty().add(new Property(property.keyProperty().getValue(), property.valueProperty().getValue()));
                }
            }
            connection.setSSL(sslSettings);
        }
    }

    public void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        if (connection.getSSL() != null) {
            this.removePropertyButton.setDisable(true);
            this.sslPropertiesTable.getItems().clear();
            this.sslPropertiesTable.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                    EditConnectionSecurityTlsPropertiesController.this.removePropertyButton.setDisable(false);
                }
            });
            for (Property property : connection.getSSL().getProperty()) {
                this.sslPropertiesTable.getItems().add((Object)new KeyValueProperty(property.getName(), property.getValue()));
            }
        }
    }

    @FXML
    private void addProperty() {
        KeyValueProperty item = new KeyValueProperty("sample.property", "sampleValue");
        this.sslPropertiesTable.getItems().add((Object)item);
        this.onChange();
    }

    @FXML
    private void removeProperty() {
        KeyValueProperty item = (KeyValueProperty)this.sslPropertiesTable.getSelectionModel().getSelectedItem();
        if (item != null) {
            this.sslPropertiesTable.getItems().remove((Object)item);
            this.onChange();
        }
    }

    public void setParent(EditMqttConnectionController controller) {
        this.parent = controller;
    }

    public AnchorPane getPropertiesPane() {
        return this.propertiesPane;
    }

    public void setPropertiesPane(AnchorPane propertiesPane) {
        this.propertiesPane = propertiesPane;
    }
}

