/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers.edit;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.PublicationDetails;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.IEditConnectionSubController;
import pl.baczkowicz.spy.common.generated.ScriptDetails;
import pl.baczkowicz.spy.ui.properties.BackgroundScriptProperties;
import pl.baczkowicz.spy.ui.properties.BaseTopicProperty;
import pl.baczkowicz.spy.ui.utils.DialogFactory;

public class EditConnectionPublicationsController
extends AnchorPane
implements Initializable,
IEditConnectionSubController {
    private static final Logger logger = LoggerFactory.getLogger(EditConnectionPublicationsController.class);
    private EditMqttConnectionController parent;
    @FXML
    private Button removePublicationButton;
    @FXML
    private Button removeScriptButton;
    @FXML
    private TextField publicationScriptsText;
    @FXML
    private TableView<BaseTopicProperty> publicationsTable;
    @FXML
    private TableView<BackgroundScriptProperties> backgroundPublicationScriptsTable;
    @FXML
    private TableColumn<BaseTopicProperty, String> publicationTopicColumn;
    @FXML
    private TableColumn<BackgroundScriptProperties, String> publicationScriptColumn;
    @FXML
    private TableColumn<BackgroundScriptProperties, Boolean> publicationAutoStartColumn;
    @FXML
    private TableColumn<BackgroundScriptProperties, Boolean> publicationRepeatColumn;
    private final ChangeListener basicOnChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            EditConnectionPublicationsController.this.onChange();
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
        this.publicationTopicColumn.setCellValueFactory((Callback)new PropertyValueFactory("topic"));
        this.publicationTopicColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.publicationTopicColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<BaseTopicProperty, String>>(){

            public void handle(TableColumn.CellEditEvent<BaseTopicProperty, String> event) {
                BaseTopicProperty p = (BaseTopicProperty)event.getRowValue();
                String newValue = (String)event.getNewValue();
                p.topicProperty().set(newValue);
                logger.debug("New value = {}", (Object)((BaseTopicProperty)EditConnectionPublicationsController.this.publicationsTable.getSelectionModel().getSelectedItem()).topicProperty().getValue());
                EditConnectionPublicationsController.this.onChange();
            }
        });
        this.publicationScriptsText.textProperty().addListener(this.basicOnChangeListener);
        this.publicationAutoStartColumn.setCellValueFactory((Callback)new PropertyValueFactory("autoStart"));
        this.publicationAutoStartColumn.setCellFactory((Callback)new Callback<TableColumn<BackgroundScriptProperties, Boolean>, TableCell<BackgroundScriptProperties, Boolean>>(){

            public TableCell<BackgroundScriptProperties, Boolean> call(TableColumn<BackgroundScriptProperties, Boolean> p) {
                TableCell<BackgroundScriptProperties, Boolean> cell = new TableCell<BackgroundScriptProperties, Boolean>(){

                    public void updateItem(Boolean item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            final BackgroundScriptProperties shownItem = (BackgroundScriptProperties)this.getTableView().getItems().get(this.getIndex());
                            CheckBox box = new CheckBox();
                            box.selectedProperty().bindBidirectional((Property)shownItem.autoStartProperty());
                            box.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                public void handle(ActionEvent event) {
                                    logger.info("New value = {} {}", (Object)shownItem.scriptProperty().getValue(), (Object)shownItem.autoStartProperty().getValue());
                                    EditConnectionPublicationsController.this.onChange();
                                }
                            });
                            this.setGraphic((Node)box);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.publicationRepeatColumn.setCellValueFactory((Callback)new PropertyValueFactory("repeat"));
        this.publicationRepeatColumn.setCellFactory((Callback)new Callback<TableColumn<BackgroundScriptProperties, Boolean>, TableCell<BackgroundScriptProperties, Boolean>>(){

            public TableCell<BackgroundScriptProperties, Boolean> call(TableColumn<BackgroundScriptProperties, Boolean> p) {
                TableCell<BackgroundScriptProperties, Boolean> cell = new TableCell<BackgroundScriptProperties, Boolean>(){

                    public void updateItem(Boolean item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            final BackgroundScriptProperties shownItem = (BackgroundScriptProperties)this.getTableView().getItems().get(this.getIndex());
                            CheckBox box = new CheckBox();
                            box.selectedProperty().bindBidirectional((Property)shownItem.repeatProperty());
                            box.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                public void handle(ActionEvent event) {
                                    logger.info("New value = {} {}", (Object)shownItem.scriptProperty().getValue(), (Object)shownItem.repeatProperty().getValue());
                                    EditConnectionPublicationsController.this.onChange();
                                }
                            });
                            this.setGraphic((Node)box);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.publicationScriptColumn.setCellValueFactory((Callback)new PropertyValueFactory("script"));
        this.publicationScriptColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.publicationScriptColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<BackgroundScriptProperties, String>>(){

            public void handle(TableColumn.CellEditEvent<BackgroundScriptProperties, String> event) {
                String newValue = (String)event.getNewValue();
                File scriptFile = new File(newValue);
                if (!newValue.isEmpty() && !scriptFile.exists()) {
                    DialogFactory.createExceptionDialog("File does not exist", "Could not locate the specified file - please check the name and the path.", "File named " + scriptFile.getName() + " does not exist at " + scriptFile.getAbsolutePath() + "!");
                    event.consume();
                    ((BackgroundScriptProperties)EditConnectionPublicationsController.this.backgroundPublicationScriptsTable.getSelectionModel().getSelectedItem()).scriptProperty().setValue("");
                } else {
                    BackgroundScriptProperties p = (BackgroundScriptProperties)event.getRowValue();
                    p.scriptProperty().set(newValue);
                    logger.debug("New value = {}", (Object)((BackgroundScriptProperties)EditConnectionPublicationsController.this.backgroundPublicationScriptsTable.getSelectionModel().getSelectedItem()).scriptProperty().getValue());
                    EditConnectionPublicationsController.this.onChange();
                }
            }
        });
    }

    public void init() {
    }

    @FXML
    private void addPublication() {
        BaseTopicProperty item = new BaseTopicProperty("/samplePublication/");
        this.publicationsTable.getItems().add((Object)item);
        this.onChange();
    }

    @FXML
    private void addScript() {
        BackgroundScriptProperties item = new BackgroundScriptProperties("put your script location here...", false, false);
        this.backgroundPublicationScriptsTable.getItems().add((Object)item);
        this.onChange();
    }

    @FXML
    private void removePublication() {
        BaseTopicProperty item = (BaseTopicProperty)this.publicationsTable.getSelectionModel().getSelectedItem();
        if (item != null) {
            this.publicationsTable.getItems().remove((Object)item);
            this.onChange();
        }
    }

    @FXML
    private void removeScript() {
        BackgroundScriptProperties item = (BackgroundScriptProperties)this.backgroundPublicationScriptsTable.getSelectionModel().getSelectedItem();
        if (item != null) {
            this.backgroundPublicationScriptsTable.getItems().remove((Object)item);
            this.onChange();
        }
    }

    public void onChange() {
        this.parent.onChange();
    }

    @Override
    public UserInterfaceMqttConnectionDetails readValues(UserInterfaceMqttConnectionDetails connection) {
        for (BaseTopicProperty publicationDetails : this.publicationsTable.getItems()) {
            PublicationDetails newPublicationDetails = new PublicationDetails();
            newPublicationDetails.setTopic(publicationDetails.topicProperty().getValue());
            connection.getPublication().add(newPublicationDetails);
        }
        connection.setPublicationScripts(this.publicationScriptsText.getText());
        for (BackgroundScriptProperties scriptDetails : this.backgroundPublicationScriptsTable.getItems()) {
            ScriptDetails newScriptDetails = new ScriptDetails();
            newScriptDetails.setFile(scriptDetails.scriptProperty().getValue());
            newScriptDetails.setAutoStart(scriptDetails.autoStartProperty().getValue());
            newScriptDetails.setRepeat(scriptDetails.repeatProperty().getValue());
            connection.getBackgroundScript().add(newScriptDetails);
        }
        return connection;
    }

    @Override
    public void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        this.removePublicationButton.setDisable(true);
        this.publicationsTable.getItems().clear();
        for (PublicationDetails pub : connection.getPublication()) {
            this.publicationsTable.getItems().add((Object)new BaseTopicProperty(pub.getTopic()));
        }
        this.publicationsTable.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                EditConnectionPublicationsController.this.removePublicationButton.setDisable(false);
            }
        });
        this.publicationScriptsText.setText(connection.getPublicationScripts());
        this.removeScriptButton.setDisable(true);
        this.backgroundPublicationScriptsTable.getItems().clear();
        for (ScriptDetails script : connection.getBackgroundScript()) {
            this.backgroundPublicationScriptsTable.getItems().add((Object)new BackgroundScriptProperties(script.getFile(), script.isAutoStart(), script.isRepeat()));
        }
        this.backgroundPublicationScriptsTable.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                EditConnectionPublicationsController.this.removeScriptButton.setDisable(false);
            }
        });
    }

    @Override
    public void setParent(EditMqttConnectionController controller) {
        this.parent = controller;
    }
}

