/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers.edit;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.IEditConnectionSubController;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.formatting.FormattingUtils;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.controllers.FormattersController;
import pl.baczkowicz.spy.ui.events.FormattersChangedEvent;
import pl.baczkowicz.spy.ui.events.ShowFormattersWindowEvent;
import pl.baczkowicz.spy.ui.keyboard.KeyboardUtils;

public class EditConnectionOtherController
extends AnchorPane
implements Initializable,
IEditConnectionSubController {
    private EditMqttConnectionController parent;
    @FXML
    private Button editFormatters;
    @FXML
    private CheckBox autoOpen;
    @FXML
    private CheckBox autoConnect;
    @FXML
    private CheckBox autoSubscribe;
    @FXML
    private TextField maxMessagesStored;
    @FXML
    private TextField minMessagesPerTopicStored;
    @FXML
    private ComboBox<FormatterDetails> formatter;
    private IConfigurationManager configurationManager;
    private final ChangeListener basicOnChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            EditConnectionOtherController.this.onChange();
        }
    };
    private ConfiguredMqttConnectionDetails currentConnection;
    private IKBus eventBus;

    public void initialize(URL location, ResourceBundle resources) {
        this.autoConnect.selectedProperty().addListener(this.basicOnChangeListener);
        this.autoOpen.selectedProperty().addListener(this.basicOnChangeListener);
        this.autoSubscribe.selectedProperty().addListener(this.basicOnChangeListener);
        this.maxMessagesStored.textProperty().addListener(this.basicOnChangeListener);
        this.maxMessagesStored.addEventFilter(KeyEvent.KEY_TYPED, KeyboardUtils.nonNumericKeyConsumer);
        this.minMessagesPerTopicStored.textProperty().addListener(this.basicOnChangeListener);
        this.minMessagesPerTopicStored.addEventFilter(KeyEvent.KEY_TYPED, KeyboardUtils.nonNumericKeyConsumer);
        this.formatter.getSelectionModel().selectedIndexProperty().addListener(this.basicOnChangeListener);
        this.formatter.setCellFactory((Callback)new Callback<ListView<FormatterDetails>, ListCell<FormatterDetails>>(){

            public ListCell<FormatterDetails> call(ListView<FormatterDetails> l) {
                return new ListCell<FormatterDetails>(){

                    protected void updateItem(FormatterDetails item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null || empty) {
                            this.setText(null);
                        } else {
                            this.setText(item.getName());
                        }
                    }
                };
            }
        });
        this.formatter.setConverter((StringConverter)new StringConverter<FormatterDetails>(){

            public String toString(FormatterDetails item) {
                if (item == null) {
                    return null;
                }
                return item.getName();
            }

            public FormatterDetails fromString(String id) {
                return null;
            }
        });
    }

    public void init() {
        this.eventBus.subscribe(this, this::handleFormattersChange, FormattersChangedEvent.class);
        this.refreshFormattersList();
        FormattersController.addFormattersToList(this.configurationManager.getFormatters(), (ObservableList<FormatterDetails>)this.formatter.getItems());
    }

    public void handleFormattersChange(FormattersChangedEvent event) {
        this.refreshFormattersList();
    }

    public void refreshFormattersList() {
        this.formatter.getItems().clear();
        this.formatter.getItems().addAll(FormattingUtils.createBaseFormatters());
        this.formatter.getItems().addAll(FormattingManager.createDefaultScriptFormatters());
    }

    @FXML
    private void editFormatters() {
        this.eventBus.publish(new ShowFormattersWindowEvent(this.getScene().getWindow(), true));
        this.init();
        this.displayConnectionDetails(this.currentConnection);
    }

    public void onChange() {
        this.parent.onChange();
    }

    @Override
    public UserInterfaceMqttConnectionDetails readValues(UserInterfaceMqttConnectionDetails connection) {
        connection.setAutoConnect(this.autoConnect.isSelected());
        connection.setAutoOpen(this.autoOpen.isSelected());
        connection.setAutoSubscribe(this.autoSubscribe.isSelected());
        connection.setFormatter(this.formatter.getSelectionModel().getSelectedItem());
        connection.setMaxMessagesStored(Integer.valueOf(this.maxMessagesStored.getText()));
        connection.setMinMessagesStoredPerTopic(Integer.valueOf(this.minMessagesPerTopicStored.getText()));
        return connection;
    }

    @Override
    public void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        this.currentConnection = connection;
        this.autoConnect.setSelected(connection.isAutoConnect() == null ? false : connection.isAutoConnect());
        this.autoOpen.setSelected(connection.isAutoOpen() == null ? false : connection.isAutoOpen());
        this.autoSubscribe.setSelected(connection.isAutoSubscribe() == null ? false : connection.isAutoSubscribe());
        this.maxMessagesStored.setText(connection.getMaxMessagesStored().toString());
        this.minMessagesPerTopicStored.setText(connection.getMinMessagesStoredPerTopic().toString());
        if (this.formatter.getItems().size() > 0 && connection.getFormatter() != null) {
            for (FormatterDetails item : this.formatter.getItems()) {
                if (!item.getID().equals(((FormatterDetails)connection.getFormatter()).getID())) continue;
                this.formatter.getSelectionModel().select((Object)item);
                break;
            }
        } else {
            this.formatter.getSelectionModel().clearSelection();
        }
    }

    public void setConfigurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    @Override
    public void setParent(EditMqttConnectionController controller) {
        this.parent = controller;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

