/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers.edit;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.AnchorPane;
import pl.baczkowicz.mqttspy.common.generated.PublicationDetails;
import pl.baczkowicz.mqttspy.common.generated.SimpleMqttMessage;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.messages.BaseMqttMessage;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.NewPublicationController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.IEditConnectionSubController;

public class EditConnectionLastWillController
extends AnchorPane
implements Initializable,
IEditConnectionSubController {
    @FXML
    private CheckBox lastWillAndTestament;
    @FXML
    private NewPublicationController lastWillAndTestamentMessageController;
    private final ChangeListener basicOnChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            EditConnectionLastWillController.this.onChange();
        }
    };
    private EditMqttConnectionController parent;

    public void initialize(URL location, ResourceBundle resources) {
        this.lastWillAndTestament.selectedProperty().addListener(this.basicOnChangeListener);
        this.lastWillAndTestamentMessageController.getPublicationTopicText().valueProperty().addListener(this.basicOnChangeListener);
        this.lastWillAndTestamentMessageController.getPublicationData().textProperty().addListener(this.basicOnChangeListener);
        this.lastWillAndTestamentMessageController.getPublicationQosChoice().getSelectionModel().selectedIndexProperty().addListener(this.basicOnChangeListener);
        this.lastWillAndTestamentMessageController.getRetainedBox().selectedProperty().addListener(this.basicOnChangeListener);
        this.lastWillAndTestamentMessageController.hidePublishButton();
    }

    public void init() {
    }

    public void onChange() {
        this.parent.onChange();
    }

    @Override
    public UserInterfaceMqttConnectionDetails readValues(UserInterfaceMqttConnectionDetails connection) {
        BaseMqttMessage message;
        if (this.lastWillAndTestament.isSelected() && (message = this.lastWillAndTestamentMessageController.readMessage(false, false)) != null) {
            connection.setLastWillAndTestament(new SimpleMqttMessage(message.getPayload(), message.getTopic(), message.getQoS(), message.isRetained()));
        }
        return connection;
    }

    @Override
    public void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        this.lastWillAndTestamentMessageController.clearTopics();
        for (PublicationDetails pub : connection.getPublication()) {
            this.lastWillAndTestamentMessageController.recordPublicationTopic(pub.getTopic());
        }
        this.lastWillAndTestament.setSelected(connection.getLastWillAndTestament() != null);
        this.lastWillAndTestamentMessageController.displayMessage(connection.getLastWillAndTestament());
    }

    @Override
    public void setParent(EditMqttConnectionController controller) {
        this.parent = controller;
    }
}

