/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.configuration.generated.TabbedSubscriptionDetails;
import pl.baczkowicz.mqttspy.connectivity.BaseMqttSubscription;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.MqttSubscription;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.ui.controllers.MqttConnectionController;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.ui.charts.ChartFactory;
import pl.baczkowicz.spy.ui.charts.ChartMode;
import pl.baczkowicz.spy.ui.events.MessageIndexToFirstEvent;
import pl.baczkowicz.spy.ui.events.MessageListChangedEvent;
import pl.baczkowicz.spy.ui.properties.SubscriptionTopicSummaryProperties;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.ui.utils.StylingUtils;
import pl.baczkowicz.spy.ui.utils.UiUtils;

public class SubscriptionSummaryTableController
implements Initializable {
    private static final int CHART_TOPIC_COUNT = 10;
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionSummaryTableController.class);
    private ManagedMessageStoreWithFiltering<FormattedMqttMessage> store;
    @FXML
    private TableView<SubscriptionTopicSummaryProperties> filterTable;
    @FXML
    private TableColumn<SubscriptionTopicSummaryProperties, Boolean> showColumn;
    @FXML
    private TableColumn<SubscriptionTopicSummaryProperties, String> topicColumn;
    @FXML
    private TableColumn<SubscriptionTopicSummaryProperties, String> contentColumn;
    @FXML
    private TableColumn<SubscriptionTopicSummaryProperties, Integer> messageCountColumn;
    @FXML
    private TableColumn<SubscriptionTopicSummaryProperties, String> lastReceivedColumn;
    private FilteredList<SubscriptionTopicSummaryProperties<FormattedMqttMessage>> filteredData;
    private MqttConnectionController connectionController;
    private IKBus eventBus;
    private Menu filteredTopicsMenu;
    private ObservableList<SubscriptionTopicSummaryProperties<FormattedMqttMessage>> nonFilteredData;
    private Set<String> shownTopics = new HashSet<String>();

    public void initialize(URL location, ResourceBundle resources) {
        this.showColumn.setCellValueFactory((Callback)new PropertyValueFactory("show"));
        this.showColumn.setCellFactory((Callback)new Callback<TableColumn<SubscriptionTopicSummaryProperties, Boolean>, TableCell<SubscriptionTopicSummaryProperties, Boolean>>(){

            public TableCell<SubscriptionTopicSummaryProperties, Boolean> call(TableColumn<SubscriptionTopicSummaryProperties, Boolean> param) {
                CheckBoxTableCell<SubscriptionTopicSummaryProperties, Boolean> cell = new CheckBoxTableCell<SubscriptionTopicSummaryProperties, Boolean>(){

                    public void updateItem(Boolean checked, boolean empty) {
                        super.updateItem((Object)checked, empty);
                        if (!this.isEmpty() && checked != null && this.getTableRow() != null && this.getTableRow().getItem() != null && SubscriptionSummaryTableController.this.store != null) {
                            SubscriptionSummaryTableController.this.changeShowProperty((SubscriptionTopicSummaryProperties)this.getTableRow().getItem(), checked);
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.topicColumn.setCellValueFactory((Callback)new PropertyValueFactory("topic"));
        this.contentColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastReceivedPayloadShort"));
        this.contentColumn.setCellFactory((Callback)new Callback<TableColumn<SubscriptionTopicSummaryProperties, String>, TableCell<SubscriptionTopicSummaryProperties, String>>(){

            public TableCell<SubscriptionTopicSummaryProperties, String> call(TableColumn<SubscriptionTopicSummaryProperties, String> param) {
                TableCell<SubscriptionTopicSummaryProperties, String> cell = new TableCell<SubscriptionTopicSummaryProperties, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setText(item);
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
        this.messageCountColumn.setCellValueFactory((Callback)new PropertyValueFactory("count"));
        this.messageCountColumn.setCellFactory((Callback)new Callback<TableColumn<SubscriptionTopicSummaryProperties, Integer>, TableCell<SubscriptionTopicSummaryProperties, Integer>>(){

            public TableCell<SubscriptionTopicSummaryProperties, Integer> call(TableColumn<SubscriptionTopicSummaryProperties, Integer> param) {
                TableCell<SubscriptionTopicSummaryProperties, Integer> cell = new TableCell<SubscriptionTopicSummaryProperties, Integer>(){

                    public void updateItem(Integer item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setText(item.toString());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.lastReceivedColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastReceivedTimestamp"));
        this.lastReceivedColumn.setCellFactory((Callback)new Callback<TableColumn<SubscriptionTopicSummaryProperties, String>, TableCell<SubscriptionTopicSummaryProperties, String>>(){

            public TableCell<SubscriptionTopicSummaryProperties, String> call(TableColumn<SubscriptionTopicSummaryProperties, String> param) {
                TableCell<SubscriptionTopicSummaryProperties, String> cell = new TableCell<SubscriptionTopicSummaryProperties, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setText(item.toString());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.filterTable.setRowFactory((Callback)new Callback<TableView<SubscriptionTopicSummaryProperties>, TableRow<SubscriptionTopicSummaryProperties>>(){

            public TableRow<SubscriptionTopicSummaryProperties> call(TableView<SubscriptionTopicSummaryProperties> tableView) {
                TableRow<SubscriptionTopicSummaryProperties> row = new TableRow<SubscriptionTopicSummaryProperties>(){

                    protected void updateItem(SubscriptionTopicSummaryProperties item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item.getSubscription() != null) {
                            BaseMqttSubscription subscription = SubscriptionSummaryTableController.this.connectionController.getConnection().getMqttSubscriptionForTopic(item.getSubscription());
                            if (subscription instanceof MqttSubscription) {
                                this.setStyle(StylingUtils.createBgRGBString(((MqttSubscription)subscription).getColor(), this.getIndex() % 2 == 0 ? 0.8 : 0.6) + " -fx-background-radius: 6; ");
                            } else {
                                this.setStyle(null);
                            }
                        } else {
                            this.setStyle(null);
                        }
                    }
                };
                return row;
            }
        });
    }

    private void changeShowProperty(SubscriptionTopicSummaryProperties item, boolean checked) {
        logger.trace("[{}] Show property changed; topic = {}, show value = {}", this.store.getName(), item.topicProperty().getValue(), checked);
        logger.trace("[{}] Store = {}, filtered store = {}", this.store.getName(), this.store.getNonFilteredMessageList(), this.store.getFilteredMessageStore().getMessageList());
        if (this.store.getFilteredMessageStore().updateTopicFilter(item.topicProperty().getValue(), checked)) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    SubscriptionSummaryTableController.this.eventBus.publish(new MessageIndexToFirstEvent(SubscriptionSummaryTableController.this.store));
                    SubscriptionSummaryTableController.this.eventBus.publish(new MessageListChangedEvent(SubscriptionSummaryTableController.this.store.getMessageList()));
                }
            });
        }
    }

    public void init() {
        this.filterTable.setContextMenu(this.createTopicTableContextMenu(this.connectionController.getConnection()));
        this.nonFilteredData = this.store.getNonFilteredMessageList().getTopicSummary().getObservableMessagesPerTopic();
        this.filteredData = new FilteredList(this.nonFilteredData);
        SortedList sortedData = new SortedList(this.filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.filterTable.comparatorProperty());
        this.filterTable.setItems((ObservableList)sortedData);
        this.filteredData.addListener((ListChangeListener)new ListChangeListener<SubscriptionTopicSummaryProperties>(){

            public void onChanged(ListChangeListener.Change<? extends SubscriptionTopicSummaryProperties> c) {
                SubscriptionSummaryTableController.this.filteredTopicsMenu.setDisable(SubscriptionSummaryTableController.this.filteredData.size() == SubscriptionSummaryTableController.this.nonFilteredData.size());
            }
        });
    }

    public void refreshRowStyling() {
        TableColumn column = new TableColumn();
        column.setMaxWidth(0.0);
        column.setPrefWidth(0.0);
        this.filterTable.getColumns().add((Object)column);
        this.filterTable.getColumns().remove((Object)column);
    }

    public int getFilteredDataSize() {
        return this.filteredData.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTopicFilter(final String topicFilter) {
        FilteredList<SubscriptionTopicSummaryProperties<FormattedMqttMessage>> filteredList = this.filteredData;
        synchronized (filteredList) {
            this.filteredData.setPredicate((Predicate)new Predicate<SubscriptionTopicSummaryProperties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean test(SubscriptionTopicSummaryProperties item) {
                    if (topicFilter == null || topicFilter.isEmpty()) {
                        return true;
                    }
                    String topic = item.topicProperty().getValue();
                    if (topic.toLowerCase().indexOf(topicFilter.toLowerCase()) != -1) {
                        Set set = SubscriptionSummaryTableController.this.shownTopics;
                        synchronized (set) {
                            SubscriptionSummaryTableController.this.shownTopics.add(topic);
                        }
                        return true;
                    }
                    Set set = SubscriptionSummaryTableController.this.shownTopics;
                    synchronized (set) {
                        SubscriptionSummaryTableController.this.shownTopics.remove(topic);
                    }
                    return false;
                }
            });
        }
    }

    private void showChartsWindow(Set<String> topics, ChartMode mode, MqttAsyncConnection connection) {
        String connectionName;
        String string = connectionName = connection != null ? " - " + connection.getName() : "";
        if (ChartMode.USER_DRIVEN_MSG_SIZE.equals((Object)mode)) {
            new ChartFactory<FormattedMqttMessage>().createMessageBasedLineChart(topics, this.store, mode, "Topic", "Size", "bytes", "Message size chart" + connectionName, this.filterTable.getScene(), this.eventBus);
        } else {
            new ChartFactory<FormattedMqttMessage>().createMessageBasedLineChart(topics, this.store, mode, "Topic", "Value", "", "Message content chart" + connectionName, this.filterTable.getScene(), this.eventBus);
        }
    }

    public ContextMenu createTopicTableContextMenu(final MqttAsyncConnection connection) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem subscribeToTopicItem = new MenuItem("Subscribe (and create tab)");
        subscribeToTopicItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    TabbedSubscriptionDetails subscriptionDetails = new TabbedSubscriptionDetails();
                    subscriptionDetails.setTopic(item.topicProperty().getValue());
                    subscriptionDetails.setQos(0);
                    SubscriptionSummaryTableController.this.connectionController.getNewSubscriptionPaneController().subscribe(subscriptionDetails, true);
                }
            }
        });
        contextMenu.getItems().add((Object)subscribeToTopicItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        MenuItem copyTopicItem = new MenuItem("Copy topic to clipboard");
        copyTopicItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    UiUtils.copyToClipboard(item.topicProperty().getValue());
                }
            }
        });
        contextMenu.getItems().add((Object)copyTopicItem);
        MenuItem copyContentItem = new MenuItem("Copy message content to clipboard");
        copyContentItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    UiUtils.copyToClipboard(item.lastReceivedPayloadProperty().getValue());
                }
            }
        });
        contextMenu.getItems().add((Object)copyContentItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        Menu allTopicsMenu = new Menu("Browse all topics");
        MenuItem selectAllTopicsItem = new MenuItem("Select all topics");
        selectAllTopicsItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    SubscriptionSummaryTableController.this.store.setAllShowValues(true);
                    SubscriptionSummaryTableController.this.eventBus.publish(new MessageIndexToFirstEvent(SubscriptionSummaryTableController.this.store));
                }
            }
        });
        allTopicsMenu.getItems().add((Object)selectAllTopicsItem);
        MenuItem toggleAllTopicsItem = new MenuItem("Toggle all topics");
        toggleAllTopicsItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    SubscriptionSummaryTableController.this.store.toggleAllShowValues();
                    SubscriptionSummaryTableController.this.eventBus.publish(new MessageIndexToFirstEvent(SubscriptionSummaryTableController.this.store));
                }
            }
        });
        allTopicsMenu.getItems().add((Object)toggleAllTopicsItem);
        MenuItem removeAllTopicsItem = new MenuItem("Deselect all topics");
        removeAllTopicsItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    SubscriptionSummaryTableController.this.store.setAllShowValues(false);
                    SubscriptionSummaryTableController.this.eventBus.publish(new MessageIndexToFirstEvent(SubscriptionSummaryTableController.this.store));
                }
            }
        });
        allTopicsMenu.getItems().add((Object)removeAllTopicsItem);
        contextMenu.getItems().add((Object)allTopicsMenu);
        this.filteredTopicsMenu = new Menu("Browse filtered topics");
        MenuItem selectFilteredTopicsItem = new MenuItem("Add filtered topics to selection");
        selectFilteredTopicsItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    SubscriptionSummaryTableController.this.store.setShowValues(true, SubscriptionSummaryTableController.this.shownTopics);
                    SubscriptionSummaryTableController.this.eventBus.publish(new MessageIndexToFirstEvent(SubscriptionSummaryTableController.this.store));
                }
            }
        });
        this.filteredTopicsMenu.getItems().add((Object)selectFilteredTopicsItem);
        MenuItem removeAllAndAddFilteredTopicsItem = new MenuItem("Deselect all and selected filtered topics");
        removeAllAndAddFilteredTopicsItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    SubscriptionSummaryTableController.this.store.setAllShowValues(false);
                    SubscriptionSummaryTableController.this.store.setShowValues(true, SubscriptionSummaryTableController.this.shownTopics);
                    SubscriptionSummaryTableController.this.eventBus.publish(new MessageIndexToFirstEvent(SubscriptionSummaryTableController.this.store));
                }
            }
        });
        this.filteredTopicsMenu.getItems().add((Object)removeAllAndAddFilteredTopicsItem);
        MenuItem toggleFilteredTopicsItem = new MenuItem("Toggle selection for filtered topics");
        toggleFilteredTopicsItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    SubscriptionSummaryTableController.this.store.toggleShowValues(SubscriptionSummaryTableController.this.shownTopics);
                    SubscriptionSummaryTableController.this.eventBus.publish(new MessageIndexToFirstEvent(SubscriptionSummaryTableController.this.store));
                }
            }
        });
        this.filteredTopicsMenu.getItems().add((Object)toggleFilteredTopicsItem);
        MenuItem removeFilteredTopicsItem = new MenuItem("Deselect filtered topics");
        removeFilteredTopicsItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    SubscriptionSummaryTableController.this.store.setShowValues(false, SubscriptionSummaryTableController.this.shownTopics);
                    SubscriptionSummaryTableController.this.eventBus.publish(new MessageIndexToFirstEvent(SubscriptionSummaryTableController.this.store));
                }
            }
        });
        this.filteredTopicsMenu.getItems().add((Object)removeFilteredTopicsItem);
        contextMenu.getItems().add((Object)this.filteredTopicsMenu);
        MenuItem selectOnlyThisItem = new MenuItem("Browse & select only this topic");
        selectOnlyThisItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    SubscriptionSummaryTableController.this.store.setAllShowValues(false);
                    SubscriptionSummaryTableController.this.store.setShowValue(item.topicProperty().getValue(), true);
                    SubscriptionSummaryTableController.this.eventBus.publish(new MessageIndexToFirstEvent(SubscriptionSummaryTableController.this.store));
                }
            }
        });
        contextMenu.getItems().add((Object)selectOnlyThisItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        Menu chartsItem = new Menu("Charts");
        MenuItem chartPayloadItem = new MenuItem("Show payload values for this topic");
        chartPayloadItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    String topic = item.topicProperty().getValue();
                    SubscriptionSummaryTableController.this.showChartsWindow(new HashSet<String>(Arrays.asList(topic)), ChartMode.USER_DRIVEN_MSG_PAYLOAD, connection);
                }
            }
        });
        chartsItem.getItems().add((Object)chartPayloadItem);
        MenuItem chartPayloadForAllSelectedItem = new MenuItem("Show payload values for browsed topics");
        chartPayloadForAllSelectedItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    Optional<ButtonType> response;
                    Set<String> topics = SubscriptionSummaryTableController.this.store.getFilteredMessageStore().getBrowsedTopics();
                    if (topics.size() > 10 && (response = DialogFactory.createQuestionDialog("Number of selected topics", "More than 10 topics have been selected to be displayed on a chart. Do you want to proceed?", false)).get() != ButtonType.YES) {
                        return;
                    }
                    SubscriptionSummaryTableController.this.showChartsWindow(topics, ChartMode.USER_DRIVEN_MSG_PAYLOAD, connection);
                }
            }
        });
        chartsItem.getItems().add((Object)chartPayloadForAllSelectedItem);
        chartsItem.getItems().add((Object)new SeparatorMenuItem());
        MenuItem chartSizeItem = new MenuItem("Show payload size for this topic");
        chartSizeItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    String topic = item.topicProperty().getValue();
                    SubscriptionSummaryTableController.this.showChartsWindow(new HashSet<String>(Arrays.asList(topic)), ChartMode.USER_DRIVEN_MSG_SIZE, connection);
                }
            }
        });
        chartsItem.getItems().add((Object)chartSizeItem);
        MenuItem chartSizeForAllSelectedItem = new MenuItem("Show payload size for browsed topics");
        chartSizeForAllSelectedItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SubscriptionTopicSummaryProperties item = (SubscriptionTopicSummaryProperties)SubscriptionSummaryTableController.this.filterTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    Optional<ButtonType> response;
                    Set<String> topics = SubscriptionSummaryTableController.this.store.getFilteredMessageStore().getBrowsedTopics();
                    if (topics.size() > 10 && (response = DialogFactory.createQuestionDialog("Number of selected topics", "More than 10 topics have been selected to be displayed on a chart. Do you want to proceed?", false)).get() != ButtonType.YES) {
                        return;
                    }
                    SubscriptionSummaryTableController.this.showChartsWindow(topics, ChartMode.USER_DRIVEN_MSG_SIZE, connection);
                }
            }
        });
        chartsItem.getItems().add((Object)chartSizeForAllSelectedItem);
        contextMenu.getItems().add((Object)chartsItem);
        return contextMenu;
    }

    public void setStore(ManagedMessageStoreWithFiltering<FormattedMqttMessage> store) {
        this.store = store;
    }

    public void setConnectionController(MqttConnectionController connectionController) {
        this.connectionController = connectionController;
    }

    public Set<String> getShownTopics() {
        return this.shownTopics;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

