/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.io.File;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.ui.MqttConnectionViewManager;
import pl.baczkowicz.mqttspy.ui.MqttViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.MqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controlpanel.MqttConfigControlPanelItem;
import pl.baczkowicz.mqttspy.ui.controlpanel.MqttStatsControlPanelItem;
import pl.baczkowicz.mqttspy.ui.events.ShowNewMqttSubscriptionWindowEvent;
import pl.baczkowicz.spy.configuration.PropertyFileLoader;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.SpyUncaughtExceptionHandler;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.ui.configuration.BaseConfigurationManager;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.configuration.UiProperties;
import pl.baczkowicz.spy.ui.connections.IConnectionFactory;
import pl.baczkowicz.spy.ui.controllers.ControlPanelController;
import pl.baczkowicz.spy.ui.controlpanel.ConnectionsControlPanelItem;
import pl.baczkowicz.spy.ui.events.AddConnectionTabEvent;
import pl.baczkowicz.spy.ui.events.LoadConfigurationFileEvent;
import pl.baczkowicz.spy.ui.events.NewPerspectiveSelectedEvent;
import pl.baczkowicz.spy.ui.events.ShowAboutWindowEvent;
import pl.baczkowicz.spy.ui.events.ShowEditConnectionsWindowEvent;
import pl.baczkowicz.spy.ui.events.ShowExternalWebPageEvent;
import pl.baczkowicz.spy.ui.events.ShowFormattersWindowEvent;
import pl.baczkowicz.spy.ui.events.ShowMessageLogEvent;
import pl.baczkowicz.spy.ui.events.ShowTestCasesWindowEvent;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.SpyPerspective;
import pl.baczkowicz.spy.ui.stats.ConnectionStatsUpdater;
import pl.baczkowicz.spy.ui.stats.StatisticsManager;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.ui.versions.VersionManager;

public class MqttSpyMainController {
    private static final Logger logger = LoggerFactory.getLogger(MqttSpyMainController.class);
    @FXML
    private ControlPanelController controlPanelPaneController;
    @FXML
    private AnchorPane mainPane;
    @FXML
    private TabPane connectionTabs;
    @FXML
    private MenuItem openConfigFileMenu;
    @FXML
    private MenuItem newConnectionMenu;
    @FXML
    private MenuItem newSubscriptionMenu;
    @FXML
    private MenuItem editConnectionsMenu;
    @FXML
    private RadioMenuItem defaultPerspective;
    @FXML
    private RadioMenuItem basicPerspective;
    @FXML
    private RadioMenuItem detailedPerspective;
    @FXML
    private RadioMenuItem spyPerspective;
    @FXML
    private RadioMenuItem superSpyPerspective;
    @FXML
    private CheckMenuItem resizeMessagePaneMenu;
    private IConfigurationManager configurationManager;
    private Stage stage;
    private Scene scene;
    private IKBus eventBus;
    private StatisticsManager statisticsManager;
    private MqttConnectionViewManager connectionViewManager;
    private double lastWidth;
    private double lastHeight;
    private VersionManager versionManager;
    private MqttViewManager viewManager;
    private IConnectionFactory connectionFactory;

    public MqttSpyMainController() throws XMLException {
        Thread.setDefaultUncaughtExceptionHandler(new SpyUncaughtExceptionHandler());
    }

    public void init() {
        this.statisticsManager.loadStats();
        this.scene = this.getParentWindow().getScene();
        this.getParentWindow().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                MqttSpyMainController.this.exit();
            }
        });
        this.scene.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneWidth, Number newSceneWidth) {
                if (!MqttSpyMainController.this.getStage().isMaximized()) {
                    MqttSpyMainController.this.setLastWidth((Double)newSceneWidth);
                }
            }
        });
        this.scene.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneHeight, Number newSceneHeight) {
                if (!MqttSpyMainController.this.getStage().isMaximized()) {
                    MqttSpyMainController.this.setLastHeight((Double)newSceneHeight);
                }
            }
        });
        this.stage.setTitle(this.configurationManager.getDefaultPropertyFile().getApplicationName());
        this.controlPanelPaneController.setUserAndConfigItem(new MqttConfigControlPanelItem(this.configurationManager, this.eventBus));
        this.controlPanelPaneController.setConnectionsItem(new ConnectionsControlPanelItem(this.configurationManager, this.connectionViewManager, this.connectionFactory, this.eventBus));
        this.controlPanelPaneController.setStatsItem(new MqttStatsControlPanelItem(this.configurationManager, this.eventBus));
        this.controlPanelPaneController.setConfigurationMananger(this.configurationManager);
        this.controlPanelPaneController.setEventBus(this.eventBus);
        this.controlPanelPaneController.setVersionManager(this.versionManager);
        this.controlPanelPaneController.init();
        new Thread(new ConnectionStatsUpdater(this.connectionViewManager)).start();
        this.resizeMessagePaneMenu.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                MqttSpyMainController.this.configurationManager.getUiPropertyFile().setProperty("application.panes.message.resize", newValue.toString());
            }
        });
        this.eventBus.subscribe(this, this::onConnectionTabAdded, AddConnectionTabEvent.class);
    }

    @FXML
    public void createNewConnection() {
        logger.trace("Creating new connection...");
        this.eventBus.publish(new ShowEditConnectionsWindowEvent(this.getParentWindow(), true, null));
    }

    @FXML
    public void editConnections() {
        this.eventBus.publish(new ShowEditConnectionsWindowEvent(this.getParentWindow(), false, null));
    }

    @FXML
    public void newSubscription() {
        Tab selectedTab = (Tab)this.getConnectionTabs().getSelectionModel().getSelectedItem();
        MqttConnectionController controller = (MqttConnectionController)this.connectionViewManager.getControllerForTab(selectedTab);
        if (controller != null) {
            this.eventBus.publish(new ShowNewMqttSubscriptionWindowEvent(controller, PaneVisibilityStatus.DETACHED, controller.getNewSubscriptionPaneStatus().getVisibility()));
        }
    }

    @FXML
    private void showFormatters() {
        this.eventBus.publish(new ShowFormattersWindowEvent(this.getParentWindow(), false));
    }

    @FXML
    public void showTestCases() {
        this.eventBus.publish(new ShowTestCasesWindowEvent(this.getParentWindow()));
    }

    @FXML
    public void openMessageLog() {
        this.eventBus.publish(new ShowMessageLogEvent(this.getParentWindow()));
    }

    @FXML
    public void exit() {
        this.connectionViewManager.disconnectAll();
        this.statisticsManager.saveStats();
        this.configurationManager.saveUiProperties(this.getLastWidth(), this.getLastHeight(), this.stage.isMaximized(), this.viewManager.getPerspective(), this.resizeMessagePaneMenu.isSelected());
        System.exit(0);
    }

    private void updateSelectedPerspective(SpyPerspective selectedPerspective) {
        switch (selectedPerspective) {
            case BASIC: {
                this.basicPerspective.setSelected(true);
                break;
            }
            case DETAILED: {
                this.detailedPerspective.setSelected(true);
                break;
            }
            case SPY: {
                this.spyPerspective.setSelected(true);
                break;
            }
            case SUPER_SPY: {
                this.superSpyPerspective.setSelected(true);
                break;
            }
            default: {
                this.defaultPerspective.setSelected(true);
            }
        }
        this.eventBus.publish(new NewPerspectiveSelectedEvent(selectedPerspective));
    }

    public TabPane getConnectionTabs() {
        return this.connectionTabs;
    }

    public void onConnectionTabAdded(AddConnectionTabEvent event) {
        this.addConnectionTab(event.getTab());
    }

    private void addConnectionTab(Tab tab) {
        this.connectionTabs.getTabs().add((Object)tab);
    }

    private Window getParentWindow() {
        return this.mainPane.getScene().getWindow();
    }

    @FXML
    public void openConfigurationFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select configuration file to open");
        String extensions = "xml";
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("XML file", new String[]{extensions}));
        File selectedFile = fileChooser.showOpenDialog(this.getParentWindow());
        if (selectedFile != null) {
            this.eventBus.publish(new LoadConfigurationFileEvent(selectedFile));
        }
    }

    @FXML
    private void showPerspective() {
        SpyPerspective selectedPerspective = this.spyPerspective.isSelected() ? SpyPerspective.SPY : (this.superSpyPerspective.isSelected() ? SpyPerspective.SUPER_SPY : (this.detailedPerspective.isSelected() ? SpyPerspective.DETAILED : (this.basicPerspective.isSelected() ? SpyPerspective.BASIC : SpyPerspective.DEFAULT)));
        this.eventBus.publish(new NewPerspectiveSelectedEvent(selectedPerspective));
    }

    @FXML
    private void resizeMessagePane() {
        for (MqttConnectionController controller : this.connectionViewManager.getConnectionControllers()) {
            controller.getResizeMessageContentMenu().setSelected(this.resizeMessagePaneMenu.isSelected());
        }
        for (MqttConnectionController controller : this.connectionViewManager.getOfflineConnectionControllers()) {
            controller.getResizeMessageContentMenu().setSelected(this.resizeMessagePaneMenu.isSelected());
        }
    }

    @FXML
    private void restoreConfiguration() {
        if (DialogFactory.showDefaultConfigurationFileMissingChoice("Restore defaults", this.mainPane.getScene())) {
            this.eventBus.publish(new LoadConfigurationFileEvent(BaseConfigurationManager.getDefaultConfigurationFileObject()));
        }
    }

    @FXML
    private void showAbout() {
        this.eventBus.publish(new ShowAboutWindowEvent(this.getParentWindow()));
    }

    @FXML
    private void openGettingInvolved() {
        this.eventBus.publish(new ShowExternalWebPageEvent(this.configurationManager.getDefaultPropertyFile().getApplicationWikiUrl() + "Getting-involved"));
    }

    @FXML
    private void overviewWiki() {
        this.eventBus.publish(new ShowExternalWebPageEvent(this.configurationManager.getDefaultPropertyFile().getApplicationWikiUrl() + "Overview"));
    }

    @FXML
    private void changelogWiki() {
        this.eventBus.publish(new ShowExternalWebPageEvent(this.configurationManager.getDefaultPropertyFile().getApplicationWikiUrl() + "Changelog"));
    }

    @FXML
    private void scriptingWiki() {
        this.eventBus.publish(new ShowExternalWebPageEvent(this.configurationManager.getDefaultPropertyFile().getApplicationWikiUrl() + "Scripting"));
    }

    @FXML
    private void messageSearchWiki() {
        this.eventBus.publish(new ShowExternalWebPageEvent(this.configurationManager.getDefaultPropertyFile().getApplicationWikiUrl() + "MessageSearch"));
    }

    public void setStage(Stage primaryStage) {
        this.stage = primaryStage;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setConfigurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setConnectionManager(MqttConnectionViewManager connectionManager) {
        this.connectionViewManager = connectionManager;
    }

    public void setStatisticsManager(StatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    public double getLastWidth() {
        return this.lastWidth;
    }

    public void setLastWidth(double lastWidth) {
        this.lastWidth = lastWidth;
    }

    public double getLastHeight() {
        return this.lastHeight;
    }

    public void setLastHeight(double lastHeight) {
        this.lastHeight = lastHeight;
    }

    private CheckMenuItem getResizeMessagePaneMenu() {
        return this.resizeMessagePaneMenu;
    }

    public void setViewManager(MqttViewManager viewManager) {
        this.viewManager = viewManager;
    }

    public void setVersionManager(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    public MenuItem getNewConnectionMenu() {
        return this.newConnectionMenu;
    }

    public void setNewConnectionMenu(MenuItem newConnectionMenu) {
        this.newConnectionMenu = newConnectionMenu;
    }

    public MenuItem getEditConnectionsMenu() {
        return this.editConnectionsMenu;
    }

    public void setEditConnectionsMenu(MenuItem editConnectionsMenu) {
        this.editConnectionsMenu = editConnectionsMenu;
    }

    public MenuItem getNewSubuscriptionMenu() {
        return this.newSubscriptionMenu;
    }

    public void updateUiProperties(PropertyFileLoader uiPropertyFile) {
        this.updateSelectedPerspective(UiProperties.getApplicationPerspective(this.configurationManager.getUiPropertyFile()));
        this.getResizeMessagePaneMenu().setSelected(UiProperties.getResizeMessagePane(this.configurationManager.getUiPropertyFile()));
    }

    public void setConnectionFactory(IConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

